/**
 * Copyright umi_kappa ( http://wonderfl.net/user/umi_kappa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lcoL
 */

/*曲げセンサーをGainerで使ってみる練習。
 * まずは、見てくれは関係なしに曲げた値をとってみる。
 * */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.text.*;
	import funnel.*;
	
    public class Main extends Sprite {
		private var _gio:Gainer;
		//曲げセンサーの入力を入れるピン
		private var _mage_Pin:Pin;
		
		private var _tf:TextField;
		
        public function Main() {
			_tf = new TextField();
			addChild(_tf);
			
			addEventListener(Event.ADDED_TO_STAGE, add);
        }
		
		//配置完了！
		private function add(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, add);
			
			_gio = new Gainer();
			//アナログINの0を使うよ
			_mage_Pin = _gio.analogInput(0);
			
			_mage_Pin.addFilter(new Scaler(0.5, 0.8, 0, 100, Scaler.LINEAR, true));
			/*曲げセンサを曲げる前　→　0.5
			 * 曲げた後　→　0.8
			 * 0.5～0.8 を　0～100にしてる。
			 * 0.5とかの確かめ方は、このFilerをコメントアウトして実行してみたらわかるよ。
			 * */
			
            _mage_Pin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            //Convolution.MOVING_AVERAGE 移動平均フィルタのカーネル　なにそれ？?
            //ブレが少なくなるみたい
			
			addEventListener(Event.ENTER_FRAME, onEF);
		}
		
		private function onEF(e:Event):void 
		{
			//曲げセンサーの値を毎フレーム見る。
			_tf.text = String(_mage_Pin.value);
		}
    }
}