/**
 * Copyright nonkasvas ( http://wonderfl.net/user/nonkasvas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lcmh
 */

// forked from nonkasvas's 編集中
// forked from yaneura9's forked from: [PV3D] Field of Blur
// forked from clockmaker's [PV3D] Field of Blur
/**
* Papervision3Dで被写界深度
* 参照： http://clockmaker.jp/blog/2008/07/pv3d_gw_blur/
*/
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	
	import org.papervision3d.view.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*
	import org.papervision3d.events.InteractiveScene3DEvent;
		
        [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
	
	public class Main extends BasicView 
	{	
		// const vars
		static private const OBJ_LENGTH   :int = 10;
		static private const CIRCLE_RANGE :int = 350;
		
		// 3d vars
		private var list :Array = []
		private var wrap :DisplayObject3D;
		private var isMouseDown:Boolean = false;
		private var oldX:Number = 0 ;
		//private var targetRot:Number = 0 ;
		private var rot:Number = 0 // 角度
		/**
		 * Constructor
		 */



				     
		
		 


		
		
		public function Main()
		{
			//camera
			camera.x         = 0;
			camera.y         = 80;
			camera.z         = 500;
			camera.rotationX = 3
			
			// wrap
			wrap = new DisplayObject3D();
			scene.addChild(wrap);
			
			for (var i:int = 0; i < OBJ_LENGTH; i++)
			{
				var rot1:Number = 360 * i / OBJ_LENGTH ;
				
				var m:ColorMaterial = new ColorMaterial(0xffffff);
				m.doubleSided = true;
				
				var o:Plane = new Plane(m, 100, 100);
				o.x = CIRCLE_RANGE * Math.sin(rot1 * Math.PI / 180);
				o.y = 0;
				o.z = CIRCLE_RANGE * Math.cos(rot1 * Math.PI / 180);
				o.rotationY = rot1;
				o.useOwnContainer = true; //ココ重要
				
                                // 配列に追加　＆　wrapの子供にする
				list.push(wrap.addChild(o));
			}
			
			addEventListener(Event.ENTER_FRAME, loop);
			startRendering(); 
		
			
		}
		
                // loop
		private function loop(event:Event):void
		{
			wrap.rotationY -= 0.25;
			var targetRot:Number = ( mouseX / stage.stageWidth ) * 360;
			var rot1:Number = 360 * i / OBJ_LENGTH ;
			rot1 += (targetRot - rot1) * 0.1;	 
		// 角度に応じてカメラの位置を設定
			
			
			wrap.x = 500 * Math.sin(rot1 * Math.PI / 180)
			wrap.z = 700 * Math.cos(rot1 * Math.PI / 180)
			
                        
                        // 被写界深度
			for (var i:int = 0; i < list.length; i++)
			{
				var o:DisplayObject3D = list[i] as DisplayObject3D;
				var blur:Number = Math.ceil((CIRCLE_RANGE - o.sceneZ) / 100); 
				o.filters = [new BlurFilter(blur, blur, 2)];
				
			}
		}
	}
}