/**
 * Copyright dansl ( http://wonderfl.net/user/dansl )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lbmv
 */

package {
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.events.KeyboardEvent;
	import flash.utils.Timer;
	import Box2D.Dynamics.*;
	import Box2D.Collision.*;
	import Box2D.Collision.Shapes.*;
	import Box2D.Common.Math.*;
	import Box2D.Dynamics.Joints.*;
	
	// Coded by: dansl
	// Push any key to spawn another monkey :)
	
	public class MonkeyBarrel extends MovieClip{
	
		private var m_world:b2World;
		private var mousePVec:b2Vec2 = new b2Vec2();
		private var real_x_mouse:Number;
		private var real_y_mouse:Number;
		private var pixels_in_a_meter:Number = 30;
		private var worldAABB:b2AABB = new b2AABB();
		private var gravity:b2Vec2 = new b2Vec2(0.0,15.0);
		private var mouseJoint:b2MouseJoint;
		
		private var okToDrop:Boolean = true;
		private var mouseDownTest:Boolean = false;
		
		private var resetMonkeyDrop:Timer = new Timer(2000);
		
		public function MonkeyBarrel():void{
			if(stage){
				init();
			}else{
				addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
			}
		}
		
		private function init(e:Event = null):void{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			resetMonkeyDrop.addEventListener("timer", resetOK);
			
			addEventListener(Event.ENTER_FRAME, render, false, 0, true);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, on_mouse_down, false, 0, true);
			stage.addEventListener(MouseEvent.MOUSE_UP, on_mouse_up, false, 0, true);
			
			stage.addEventListener (KeyboardEvent.KEY_DOWN, dropMonkey, false, 0, true);
			
			buildWorld();
		}
		
		private function resetOK(e:TimerEvent):void{
			okToDrop = true;
			resetMonkeyDrop.stop();
		}
		
		private function buildWorld():void{

			worldAABB.lowerBound.Set(-100.0, -100.0);
			worldAABB.upperBound.Set(100.0, 100.0);
			m_world = new b2World(worldAABB,gravity,true);
			
			var m_sprite:Sprite;
			m_sprite = new Sprite();
			addChild(m_sprite);
			var dbgDraw:b2DebugDraw = new b2DebugDraw();
			var dbgSprite:Sprite = new Sprite();
			m_sprite.addChild(dbgSprite);
			dbgDraw.m_sprite = m_sprite;
			dbgDraw.m_drawScale = 30;
			dbgDraw.m_alpha = 1;
			dbgDraw.m_fillAlpha = 0.5;
			dbgDraw.m_lineThickness = 1;
			dbgDraw.m_drawFlags = b2DebugDraw.e_shapeBit|b2DebugDraw.e_jointBit;
			m_world.SetDebugDraw(dbgDraw);		
			
			//(_Width:Number, _Height:Number, _X:Number, _Y:Number, _Angle:Number, _Friction:Number, _Density:Number, _Restitution:Number)	
			// Cieling 
			createBox(25, 0.1, 3, -3, 0, 0.3, 0, 0);
			//left side
			createBox(0.1, 25, 0, 10, 0, 0.3, 0, 0);
			//right side
			createBox(0.1, 25, 15.5, 10, 0, 0.3, 0, 0);
			//Floor
			createBox(25, 0.2, 3, 15.5, 0, 0.3, 0, 0);
			
			//(_Width:Number, _Height:Number, _Radius:Number, _X:Number, _Y:Number, _Friction:Number, _Density:Number, _Restitution:Number)
			createCircle(0.4, 0.4, 0.2, 10, 3, 0.5, 0, 0);
			createCircle(0.4, 0.4, 0.2, 5, 3, 0.5, 0, 0);
			
			// Creates First Monkey!
			createMonkey(1.7, 1);
		}
		
		private function createMonkey(_X:Number, _Y:Number):void {
			var monkeyDef:b2BodyDef = new b2BodyDef();
			monkeyDef.position.Set(_X, _Y);
			
			var monkey:b2Body = new b2Body(monkeyDef, m_world);
			monkey = m_world.CreateBody(monkeyDef);
			
			var monkDesity:Number = 5;
			
			//top left hand
			var leftHandDef:b2PolygonDef = new b2PolygonDef();
			leftHandDef.SetAsOrientedBox(0.25, 0.1, new b2Vec2(0.3, 0.9), -0.5);
			leftHandDef.density = monkDesity;
			leftHandDef.friction = 0.4;
			leftHandDef.restitution = 0.1;
			monkey.CreateShape(leftHandDef);
			
			//mid left hand
			var leftHandDef2:b2PolygonDef = new b2PolygonDef();
			leftHandDef2.SetAsOrientedBox(0.1, 0.4, new b2Vec2(0.3, 1.3), -0.7);
			leftHandDef2.density = monkDesity;
			leftHandDef2.friction = 0.4;
			leftHandDef2.restitution = 0.1;
			monkey.CreateShape(leftHandDef2);
			
			//arms
			var armsDef:b2PolygonDef = new b2PolygonDef();
			armsDef.SetAsOrientedBox(1.7, 0.1, new b2Vec2(2, 0.9), -0.5);
			armsDef.density = monkDesity;
			armsDef.friction = 0.4;
			armsDef.restitution = 0.1;
			monkey.CreateShape(armsDef);
			
			//head
			var headDef:b2PolygonDef = new b2PolygonDef();
			headDef.SetAsOrientedBox(0.25, 0.25, new b2Vec2(1.8, 0.5), -0.5);
			headDef.density = monkDesity;
			headDef.friction = 0.4;
			headDef.restitution = 0.1;
			monkey.CreateShape(headDef);
			
			//mid right hand
			var rightHandHandDef:b2PolygonDef = new b2PolygonDef();
			rightHandHandDef.SetAsOrientedBox(0.1, 0.4, new b2Vec2(3.8, 0.3), -0.8);
			rightHandHandDef.density = monkDesity;
			rightHandHandDef.friction = 0.4;
			rightHandHandDef.restitution = 0.1;
			monkey.CreateShape(rightHandHandDef);
			
			//top right hand
			var rightHandHandDef2:b2PolygonDef = new b2PolygonDef();
			rightHandHandDef2.SetAsOrientedBox(0.25, 0.1, new b2Vec2(3.8, 0.8), -0.8);
			rightHandHandDef2.density = monkDesity;
			rightHandHandDef2.friction = 0.4;
			rightHandHandDef2.restitution = 0.1;
			monkey.CreateShape(rightHandHandDef2);
			
			//body
			var bodyDef:b2PolygonDef = new b2PolygonDef();
			bodyDef.SetAsOrientedBox(0.3, 0.5, new b2Vec2(2.1, 1.3), -0.1);
			bodyDef.density = monkDesity;
			bodyDef.friction = 0.4;
			bodyDef.restitution = 0.1;
			monkey.CreateShape(bodyDef);
			
			//left leg
			var leftLegDef:b2PolygonDef = new b2PolygonDef();
			leftLegDef.SetAsOrientedBox(0.1, 0.4, new b2Vec2(1.6, 2), 0.2);
			leftLegDef.density = monkDesity;
			leftLegDef.friction = 0.4;
			leftLegDef.restitution = 0.1;
			monkey.CreateShape(leftLegDef);
			
			//right leg
			var rightLegDef:b2PolygonDef = new b2PolygonDef();
			rightLegDef.SetAsOrientedBox(0.1, 0.4, new b2Vec2(2.4, 2.2), 0.2);
			rightLegDef.density = monkDesity;
			rightLegDef.friction = 0.4;
			rightLegDef.restitution = 0.1;
			monkey.CreateShape(rightLegDef);
			
			monkey.SetMassFromShapes();
			
		}
		
		private function createTri(e:Event):void{
			var bodyDef:b2BodyDef = new b2BodyDef();
			bodyDef.position.Set(14, 10);	
			var triangleDef:b2PolygonDef = new b2PolygonDef()
			triangleDef.vertexCount = 3
			triangleDef.friction=.5;
			triangleDef.density=.5;
			triangleDef.restitution = .5;
			triangleDef.vertices[0].Set(-1.0, 0.0)
			triangleDef.vertices[1].Set(1.0, 0.0)
			triangleDef.vertices[2].Set(0.0, 2.0)
			var body:b2Body = new b2Body(bodyDef, m_world);
			body = m_world.CreateBody(bodyDef);
			body.CreateShape(triangleDef);
			body.SetMassFromShapes();
		}
		
		private function createBox(_Width:Number, _Height:Number, _X:Number, _Y:Number, _Angle:Number, _Friction:Number, _Density:Number, _Restitution:Number):void {
			var bodyDef:b2BodyDef = new b2BodyDef();
			bodyDef.position.Set(_X, _Y);
			bodyDef.angle = _Angle;
			var boxDef:b2PolygonDef = new b2PolygonDef();
			boxDef.SetAsBox(_Width, _Height);
			boxDef.friction = _Friction;
			boxDef.density = _Density;
			boxDef.restitution = _Restitution;
			var body:b2Body = new b2Body(bodyDef, m_world);
			body = m_world.CreateBody(bodyDef);
			body.CreateShape(boxDef);
			body.SetMassFromShapes();
		}
		
		private function createCircle(_Width:Number, _Height:Number, _Radius:Number, _X:Number, _Y:Number, _Friction:Number, _Density:Number, _Restitution:Number):void {
			var bodyDef:b2BodyDef = new b2BodyDef();
			bodyDef.position.x = _X;
			bodyDef.position.y = _Y;
			var cir_width:Number = _Width;
			var cir_height:Number = _Height;
			var cirDef:b2CircleDef = new b2CircleDef();
			cirDef.radius = _Radius;
			cirDef.density = _Density;
			cirDef.friction = _Friction;
			cirDef.restitution = _Restitution;
			var body:b2Body = new b2Body(bodyDef, m_world);
			body = m_world.CreateBody(bodyDef);
			body.CreateShape(cirDef);
			body.SetMassFromShapes();	
		}
		
		private function render(e:Event):void {
			m_world.Step(1/24, 10);
			if (mouseJoint) {
				var mouseXWorldPhys:Number = mouseX/pixels_in_a_meter;
				var mouseYWorldPhys:Number = mouseY/pixels_in_a_meter;
				var p2:b2Vec2 = new b2Vec2(mouseXWorldPhys,mouseYWorldPhys);
				mouseJoint.SetTarget(p2);
			}
			for (var bb:b2Body = m_world.m_bodyList; bb; bb = bb.m_next) {
				if (bb.m_userData is Sprite) {
					bb.m_userData.x=bb.GetPosition().x*pixels_in_a_meter;
					bb.m_userData.y=bb.GetPosition().y*pixels_in_a_meter;
					bb.m_userData.rotation = bb.GetAngle() * (180/Math.PI);
				}
			}
		}
		
		private function on_mouse_down(evt:MouseEvent):void {
			mouseDownTest = true;
			var body:b2Body = GetBodyAtMouse();
			if (body) {
				var mouse_joint:b2MouseJointDef = new b2MouseJointDef  ;
				mouse_joint.body1 = m_world.GetGroundBody();
				mouse_joint.body2 = body;
				mouse_joint.target.Set(mouseX/pixels_in_a_meter, mouseY/pixels_in_a_meter);
				mouse_joint.maxForce = 5000;
				mouse_joint.timeStep = 1/24;
				mouseJoint=m_world.CreateJoint(mouse_joint) as b2MouseJoint;
			}
		}
		
		private function on_mouse_up(evt:MouseEvent):void {
			mouseDownTest = false;
			if (mouseJoint) {
				m_world.DestroyJoint(mouseJoint);
				mouseJoint = null;
			}
		}
		
		private function GetBodyAtMouse(includeStatic:Boolean=false):b2Body {
			real_x_mouse = (stage.mouseX)/pixels_in_a_meter;
			real_y_mouse = (stage.mouseY)/pixels_in_a_meter;
			mousePVec.Set(real_x_mouse, real_y_mouse);
			var aabb:b2AABB = new b2AABB();
			aabb.lowerBound.Set(real_x_mouse - 0.001, real_y_mouse - 0.001);
			aabb.upperBound.Set(real_x_mouse + 0.001, real_y_mouse + 0.001);
			var k_maxCount:int=10;
			var shapes:Array = new Array();
			var count:int=m_world.Query(aabb,shapes,k_maxCount);
			var body:b2Body=null;
			for (var i:int = 0; i < count; ++i) {
				if (shapes[i].m_body.IsStatic()==false||includeStatic) {
					var tShape:b2Shape=shapes[i] as b2Shape;
					var inside:Boolean=tShape.TestPoint(tShape.m_body.GetXForm(),mousePVec);
					if (inside) {
						body=tShape.m_body;
						break;
					}
				}
			}
			return body;
		}
		
		private function dropMonkey(e:KeyboardEvent):void{
			if(okToDrop == true){
				createMonkey(10, -2);
				okToDrop = false;
				resetMonkeyDrop.start();
			}
		}
	}
}