/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lax6
 */

/*
Matrix3D.prependTranslation();
と同じ機能の関数を作ってみる。
MAC 10,0,2,54,MAC 10,0,12,36,MAC 10,0,22,87で動作確認。

処理としては
パラメーターで作った行列にentity行列をprependする。

パラメーターで作る行列は
x,y,zを変化させるだけなので行列は作らずに、
対応する要素毎に加算するのみ。


各要素をrandomで値を入れて、prependTranslationし、
行列の各要素を比較して確認とした。

Matrix3D.prependTranslation()
http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/geom/Matrix3D.html#prependTranslation()
*/
package {
	import flash.display.Sprite;
	import flash.geom.Matrix3D;
	import flash.text.TextField;
	import flash.geom.Vector3D;
	import flash.system.Capabilities;
	public class Main extends Sprite {
		public function Main() {
			var txt:String="◆同機能関数Mtrx3D.prependTranslation　"+Capabilities.version+"での実行結果\n\n";
			
			var entity:Matrix3D=new Matrix3D(Util.random16());
			var entity1:Matrix3D=entity.clone();
			var entity2:Matrix3D=entity.clone();
			var x:Number=Math.random()*200-100;
			var y:Number=Math.random()*200-100;
			var z:Number=Math.random()*200-100;
			
			entity1.prependTranslation(x,y,z);
			var entity1RawData:Vector.<Number>=entity1.rawData;
			txt+="↓Matrix3D.prependTranslationの結果\n"+entity1RawData+"\n";
			Mtrx3D.prependTranslation(entity2,x,y,z);
			var entity2RawData:Vector.<Number>=entity2.rawData;

			txt+="\n↓同機能関数Mtrx3D.prependTranslationの結果\n"+entity2RawData+"\n\n";
			txt+=Util.hikaku(entity1RawData,entity2RawData);


			var tf:TextField = new TextField();
			tf.width=stage.stageWidth;
			tf.height=stage.stageHeight;
			tf.wordWrap=true;
			stage.addChild(tf);
			tf.text=txt;
		}
	}
}
import flash.display.Sprite;
class Mtrx3D extends Sprite {
	import flash.geom.Matrix3D;
	import flash.geom.Vector3D;
	public static function prependTranslation(entity:Matrix3D,x:Number, y:Number, z:Number):void{
		//e[15]の値がおかしい20？？？
		
		//バグ対応。10,0,22,87未満の場合バグを含むように。
		var bug:int = 1;
		if(Util.version() <1000022087){
			bug = 20;
		}
		
		var e:Vector.<Number> = Vector.<Number>(entity.rawData);
		e[12] += e[0]*x+e[4]*y+e[8]*z;
		e[13] += e[1]*x+e[5]*y+e[9]*z;
		e[14] += e[2]*x+e[6]*y+e[10]*z;
		e[15] += e[3]*x*bug+e[7]*y*bug+e[11]*z*bug;
		entity.rawData = e;
	}
}
class Util {
	import flash.system.Capabilities;	
	public static function version():uint{
		//例10,0,22,87→10+00+022+087→1000022087
		var ver_array:Array = Capabilities.version.substr(4).split(",");
		return int(ver_array[0])*100000000+int(ver_array[1])*1000000+int(ver_array[2])*1000+int(ver_array[3]);
	}
	
	public static function hikaku(v0:Vector.<Number>,v1:Vector.<Number>):String {
		var _str:String="↓二つのMatrix3Dの要素毎の差\n";
		var _n:int=v0.length;
		for (var i:int=0; i<_n; i++) {
			_str += "["+i+"]:"+(v0[i]-v1[i])+"\n";
		}
		return _str;
	}

	public static function random16():Vector.<Number> {
		var _v:Vector.<Number>=new Vector.<Number>(16,true);
		for (var i:int=0; i<16; i++) {
			_v[i]=Math.random()*200-100;
		}
		return _v;
	}
}