/**
 * Copyright aina ( http://wonderfl.net/user/aina )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/lauW
 */

package {
    import flash.display.*;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.media.Video;
    import flash.geom.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.geom.Matrix;
    import com.actionsnippet.qbox.*;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.Joints.b2RevoluteJoint;
    import Box2D.Collision.Shapes.*;
    import Box2D.Collision.*;
    import Box2D.Dynamics.*;
    import Box2D.Collision.*;
    import com.demonsters.debugger.MonsterDebugger;
    import com.bit101.components.PushButton;
    import flash.events.MouseEvent;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    
    public class Main extends MovieClip {
        private var con:QuickContacts
        private var sim:QuickBox2D;
        private var box1:QuickObject;
        private var cir1:QuickObject;
        private var cir2:QuickObject;
        private var canvas:MovieClip;
        private var dx:Number = 0;
        private var dy:Number = 0;
        private var time:Number = 0;
        private var scale:Number = 1;
        private var scaleDest:Number = 1.0;
        private var currQuick:QuickObject;
        private var xx:Number = 0;
        private var yy:Number = 0;
        private var _key:Object;

    public function Main() {        
    
    if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            canvas = new MovieClip();
            addChild(canvas);
            sim = new QuickBox2D(canvas, {debug:false});
            
            //仕掛けとか
            sim.addBox({x:15, y:15.5, width:30, height:1, density:0 });
            sim.addPoly({x:15, y:15, angle:9.1,verts:[[0, 0, 3, 1, 0, 1.2]],density:0});
            sim.addBox({x:39.5, y:16.4, width:20, height:1,angle:0.1, density:0});
            sim.addBox({x:55, y:17.4, width:15, height:1,density:0});
            sim.addPoly({x:60, y:16.9, angle:8.9,verts:[[0, 0, 2, 1, 0, 1]],density:0});
            sim.addBox({x:65, y:19, width:15, height:1,density:0});
            sim.addBox({x:77.5, y:19, width:7, height:1,density:0});
            sim.addBox({x:66, y:40, width:35, height:1, density:0});
            sim.addBox({x:44.7, y:43, width:10, height:1, angle:2.5, density:0});
            sim.addBox({x:34, y:46.8, width:15, height:1, density:0});
            sim.addBox({x:22, y:50, width:20, height:1,angle:0.8, density:0});
            sim.addBox({x:34, y:55, width:15, height:1, density:0});
            
            //ダミーゴール
            var goal:QuickObject=sim.addBox({x:73, y:31, width:2, height:0.2});
            var hidari:QuickObject=sim.addBox({x:72, y:30, width:0.2, height:2, density:0});
            var pole:QuickObject=sim.addBox({x:74, y:28.5, width:0.2, height:5, density:0});
            var joint1:QuickObject = sim.addJoint({type:"revolute", a:goal.body, b:sim.w.GetGroundBody(), x1:74, y1:31});
            var joint2:b2RevoluteJoint=sim.addJoint({a:goal.body, b:hidari.body, x1:72, y1:31, frequencyHz:5,dampingRatio:0} ).joint as b2RevoluteJoint;
            sim.addPoly({x:74, y:26, verts:[[0, 0, 2, 0.5, 0, 1]],density:0, fillColor:0xff0000});
            
            //本物ゴール
            sim.addBox({x:55, y:93, width:3, height:0.2, density:0});
            sim.addBox({x:53.5, y:92, width:0.2, height:2, density:0});
            sim.addBox({x:56.5, y:90.5, width:0.2, height:5, density:0});
            sim.addPoly({x:56.5, y:88, verts:[[0, 0, 2, 0.5, 0, 1]],density:0, fillColor:0x0000ff});
            
            
            //box1=sim.addBox({x:5,y:5,width:10,height:0.5,density:0,isBullet:true,fillColor:0x000000});
            //ボール
            cir1=sim.addCircle({x:3,y:11,radius:0.5,fillColor:0xff0000});
            cir2=sim.addCircle({x:30,y:45,radius:0.5,fillColor:0x0000ff});
            
            
            //車（大）
            var body1:QuickObject = sim.addBox( { x:2.5, y:13, width:4, height:0.2 } );
            var bodya:QuickObject = sim.addBox( { x:0.7, y:12, width:0.2, height:2 } );
            var bodyb:QuickObject = sim.addBox( { x:4.3, y:12, width:0.2, height:2 } );
            var wheelA:QuickObject = sim.addCircle( { x:1.5, y:14, radius:0.5 } );
            var wheelB:QuickObject = sim.addCircle( { x:3.5, y:14, radius:0.5 } );
            sim.setDefault({type:"revolute", enableMotor:true, maxMotorTorque:250});
            var jointa1:b2RevoluteJoint = sim.addJoint( { a:body1.body, b:bodya.body, x1:0.7, y1:13,frequencyHz:0,dampingRatio:0 } ).joint as b2RevoluteJoint;
            var jointb1:b2RevoluteJoint = sim.addJoint( { a:body1.body, b:bodyb.body, x1:4.3, y1:13,frequencyHz:0,dampingRatio:0 } ).joint as b2RevoluteJoint;
            var jointa2:b2RevoluteJoint = sim.addJoint( { a:body1.body, b:bodya.body, x1:0.7, y1:11,frequencyHz:0,dampingRatio:0 } ).joint as b2RevoluteJoint;
            var jointb2:b2RevoluteJoint = sim.addJoint( { a:body1.body, b:bodyb.body, x1:4.3, y1:11,frequencyHz:0,dampingRatio:0 } ).joint as b2RevoluteJoint;
            var jointA:b2RevoluteJoint = sim.addJoint( { a:body1.body, b:wheelA.body, x1:wheelA.x, y1:wheelA.y } ).joint as b2RevoluteJoint;
            var jointB:b2RevoluteJoint = sim.addJoint( { a:body1.body, b:wheelB.body, x1:wheelB.x, y1:wheelB.y } ).joint as b2RevoluteJoint;
            jointA.SetMotorSpeed(4);
            jointB.SetMotorSpeed(4);
            //sim.setDefault({});
            
            //車（小）
            var body2:QuickObject = sim.addBox( { x:3.5, y:11, width:0.2, height:2 } );
            var bodyc:QuickObject = sim.addBox( { x:2.5, y:10, width:2, height:0.2 } );
            var bodyd:QuickObject = sim.addBox( { x:2.5, y:12, width:2, height:0.2 } );
            var wheelC:QuickObject = sim.addCircle( { x:4, y:12, radius:0.3 } );
            var wheelD:QuickObject = sim.addCircle( { x:4, y:10, radius:0.3 } );
            sim.setDefault({type:"revolute", enableMotor:true, maxMotorTorque:250});
            var jointc1:b2RevoluteJoint = sim.addJoint( { a:body2.body, b:bodyc.body, x1:1.5, y1:10,frequencyHz:0,dampingRatio:0 } ).joint as b2RevoluteJoint;
            var jointd1:b2RevoluteJoint = sim.addJoint( { a:body2.body, b:bodyd.body, x1:1.5, y1:12,frequencyHz:0,dampingRatio:0 } ).joint as b2RevoluteJoint;
            var jointc2:b2RevoluteJoint = sim.addJoint( { a:body2.body, b:bodyc.body, x1:3.5, y1:10,frequencyHz:0,dampingRatio:0 } ).joint as b2RevoluteJoint;
            var jointd2:b2RevoluteJoint = sim.addJoint( { a:body2.body, b:bodyd.body, x1:3.5, y1:12,frequencyHz:0,dampingRatio:0 } ).joint as b2RevoluteJoint;
            var jointC:b2RevoluteJoint = sim.addJoint( { a:body2.body, b:wheelC.body, x1:wheelC.x, y1:wheelC.y } ).joint as b2RevoluteJoint;
            var jointD:b2RevoluteJoint = sim.addJoint( { a:body2.body, b:wheelD.body, x1:wheelD.x, y1:wheelD.y } ).joint as b2RevoluteJoint;
            jointC.SetMotorSpeed(7);
            jointD.SetMotorSpeed(7);
            sim.setDefault({});

            //var con:QuickContacts = sim.addContactListener();
            //con.addEventListener(QuickContacts.ADD, function onAdd(evt:Event):void {
             //   if (con.isCurrentContact(cir,box1)){
              //   sim.destroy();
               // while (canvas.numChildren) canvas.removeChildAt(canvas.numChildren-1);
                //reset();
             //   }
            //});
            
            //ドミノ
            var domino:Array = []
            for (var i:int = 0; i < 10; i++) 
            {
                domino.push(sim.addBox( { x:57.7 - i, y:39, width:0.15, height:1 } ));
            }
            
            var domino2:Array = []
            for (var j:int = 0; j < 10; j++) 
            {
                domino2.push(sim.addBox( { x:40.2 - j, y:46, width:0.15, height:1 } ));
            }
            
            sim.addTimeStepSequence({ time:70, callback:camera, args:[cir2, 1] },
                                    { time:150, callback:camera, args:[cir1, 1] },
                                    { time:2800, callback:camera, args:[domino[1], 1] },
                                    { time:2900, callback:camera, args:[domino[5], 1] },
                                    { time:3000, callback:camera, args:[domino[9], 1] },
                                    { time:3150, callback:camera, args:[domino2[1], 1] },
                                    { time:3250, callback:camera, args:[domino2[9], 1] },
                                    { time:3350, callback:camera, args:[cir2, 1] },
                                    { time:100000, callback:camera, args:[cir1, 1] }
                                    );
          
            sim.start();
            sim.mouseDrag();
            _key = {};
            stage.addEventListener(KeyboardEvent.KEY_DOWN, _onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, _onKeyUp);
            addEventListener(Event.ENTER_FRAME, _onLoop);
            addEventListener(Event.ENTER_FRAME, loop);
            loop()
        }
       
    private function loop(e:Event = null):void 
        {
            scale += (scaleDest - scale) * 0.2;
            dx += (currQuick.x * 30+xx - dx) * 0.2;
            dy += (currQuick.y * 30+yy - dy) * 0.2;
            var m:Matrix = canvas.transform.matrix;
            m.identity();
            m.translate(-dx+100,-dy+200);
            m.scale(scale, scale);
            canvas.transform.matrix = m;
        }   
        
     private function camera(quickObj:QuickObject, scale:Number = -1, x:Number = 0, y:Number = 0):void
        {
            currQuick = quickObj;
            xx = x;
            yy = y;
            if (scale != -1){
                scaleDest = scale;
            }
           
            //public function reset():void {
            //sim = new QuickBox2D(this)
            //sim.addBox( { x:50, y:15.5, width:100, height:1, density:0 } );
            //sim.addBox( { x:60, y:15.5, width:10, height:1, angle:-0.5, density:0 } );
            //box1=sim.addBox({x:2,y:10,width:2,height:2,isBullet:true,fillColor:0x000000});
            //cir=sim.addCircle({x:4,y:1,radius:0.5,fillColor:0xff0000});
            //sim.setDefault({});
            //sim.start();
            //}
        }
        
        //キーボード操作（赤玉）
           private function _onLoop(e:Event):void 
        {
            var vel:b2Vec2 = cir1.body.GetLinearVelocity();
            var ang:Number = cir1.body.GetAngularVelocity();
            
            if (_key[Keyboard.LEFT])
            {
                vel.x -= 1;
                ang -= 1;
            }
            else if (_key[Keyboard.RIGHT])
            { 
                vel.x += 1;
                ang += 1;
            }
            
            if (_key[Keyboard.UP])
            {
                vel.y = -10;
                ang *= 0.8;
            }
            
            ang *= 0.9;
            vel.x *= 0.9;
            
            cir1.body.SetLinearVelocity(vel);
            cir1.body.SetAngularVelocity(ang);
            
            canvas.x = -cir1.x * 30 + stage.stageWidth / 2;
            if (canvas.x > 15) canvas.x = 15;
            if (canvas.x < -2535) canvas.x = -2535;
        }
         private function _onKeyDown(e:KeyboardEvent):void 
        {
            _key[e.keyCode] = true;
        }
        
        private function _onKeyUp(e:KeyboardEvent):void 
        {
            _key[e.keyCode] = false;
        }        
    }
}
    