/**
 * Copyright designquest ( http://wonderfl.net/user/designquest )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/la9R
 */

// forked from designquest's Alternativa3D Hello World
// Original code from : http://docs.alternativaplatform.com/display/TDEN/Hello%2C+Alternativa3D

package {
	import alternativ5.engine3d.controllers.CameraController;
	import alternativ5.engine3d.core.Camera3D;
	import alternativ5.engine3d.core.Object3D;
	import alternativ5.engine3d.core.Scene3D;
	import alternativ5.engine3d.display.View;
	import alternativ5.engine3d.materials.WireMaterial;
	import alternativ5.engine3d.primitives.Box;
	import alternativ5.utils.FPS;
	
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;

	[SWF(backgroundColor="#000000", frameRate="100")]

	public class HelloAlternativa3D extends Sprite	{
		
		private var scene:Scene3D;
		private var view:View;
		private var camera:Camera3D;
		private var cameraController:CameraController;
		private var box:Box;
		
		public function HelloAlternativa3D()	{
			addEventListener(Event.ADDED_TO_STAGE, init);
		}

		public function init(e:Event): void {
			removeEventListener(Event.ADDED_TO_STAGE, init);

			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			// Creating scene
			scene = new Scene3D();
			scene.root = new Object3D();
			box = new Box(50, 100, 100, 1, 5, 1);
			box.cloneMaterialToAllSurfaces(new WireMaterial(1, 0xFFFFFF));
			scene.root.addChild(box);
			
			// Adding camera and view
			camera = new Camera3D();
			camera.x = 100;
			camera.y = -150;
			camera.z = 100;
			scene.root.addChild(camera);
			
			view = new View();
			addChild(view);
			view.camera = camera;

			// Connecting camera controller
			cameraController = new CameraController(stage);
			cameraController.camera = camera;
			cameraController.setDefaultBindings();
			cameraController.checkCollisions = true;
			cameraController.collisionRadius = 20;
			cameraController.lookAt(box.coords);
			cameraController.controlsEnabled = true;

			// FPS display launch
			FPS.init(stage);

			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			onResize(null);
		}
		
		private function onResize(e:Event):void {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}
		
		private function onEnterFrame(e:Event):void {
			// User input processing
			cameraController.processInput();
			// Scene calculating
			scene.calculate();
		}
	}
}