/**
 * Copyright set0 ( http://wonderfl.net/user/set0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lYVX
 */

package 
{
  import flash.display.*;
  import flash.events.*;
  import flash.net.*;
  import flash.system.*;
  import flash.geom.*;
  import flash.text.*;
  import flash.filters.*;
  import org.libspark.betweenas3.*;
  
  [SWF(width=465, height=465, frameRate=60, backgroundColor=0xffffff)]
  public class FlashTest extends Sprite {
      
      private var image_width:Number = 0;
      private var image_height:Number = 0;
      private var image_x:Number = 0;
      private var image_y:Number = 0;
      private var pixel_x:int = 0;
      private var pixel_y:int = 0;
      private var pixel_n:int = 0;
      private var pixel_max:int = 0;
      private var image_array:Array = [];
      private var sp_array:Vector.<Sprite> = Vector.<Sprite>([new Sprite()]);

      
      public function FlashTest()
      {
          var image_url:String = "http://farm2.static.flickr.com/1271/1168949483_4b0523cc19_m.jpg";
          
          var loader:Loader = new Loader();
          loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoadComplete);
          loader.load(new URLRequest(image_url), new LoaderContext(true));
          
      }
      
      private function onImageLoadComplete(e:Event):void
      {
         var loader:Loader = LoaderInfo(e.target).loader;
         var base:BitmapData = Bitmap(loader.content).bitmapData;
         var bmp:Bitmap = loader.content as Bitmap
         
         image_width = loader.width;
         image_height = loader.height;
         image_x = stage.stageWidth / 2 - image_width / 2;
         image_y = stage.stageHeight / 2 - image_height / 2;
         
         var count:int = 0;
         
         for(var img_y:int=1;img_y<=image_height;img_y++) {
             for(var img_x:int=1;img_x<=image_width;img_x++) {
                 image_array[count] = [];
                 image_array[count]["color"] = getColorArray(base.getPixel(img_x, img_y));
                 image_array[count]["x"] = String(img_x);
                 image_array[count]["y"] = String(img_y);
                 //image_array[count]["x"] = String(img_x);
                 //image_array[count]["y"] = String(img_y);
                 
                 count++;
             }
         }
         
         pixel_max = image_array.length;
         //image_array.sortOn("color");
         
         
 
         addEventListener(Event.ENTER_FRAME, onEnterFramePre);
       }
       
       private function drawImage(tmp_x:int, tmp_y:int, color:uint):Sprite
       {
           var sp:Sprite = new Sprite();
           addChild(sp);
           
           var from_x:int = int(tmp_x);
	       var from_y:int = int(tmp_y);
	       var to_x:int = from_x + 1;
	       var to_y:int = from_y + 1;
	       
	       sp.graphics.lineStyle(1, color, 1.0, false, "none");
	       sp.graphics.moveTo (from_x, from_y);
	       sp.graphics.lineTo(to_x, to_y);

               sp.x = pixel_x;
               sp.y = pixel_y +300;
	       
	       return sp;
       }

       private function onEnterFramePre(e:Event):void
       {
           for(var i:int=0;i< image_width/4;i++) {
               if(pixel_n > pixel_max) {
                   removeEventListener(Event.ENTER_FRAME, onEnterFramePre);
                   
                   //for(var n:int=0;n<pixel_max;n++) {
                   //    BetweenAS3.tween(sp_array[n], {x:int(image_array[n]["x"]), y:int(image_array[n]["y"])}).play();
                   //}
                   return;
               }
             
               var d:int = pixel_n % image_width;
             
               if(d == 0 && pixel_n != 0) {
                   pixel_x = 0;
                   pixel_y++;
               }

              sp_array[pixel_n] = new Sprite();
              //sp_array[pixel_n] = drawImage(pixel_x + image_x, pixel_y + image_y, image_array[pixel_n]["color"]);
              //sp_array[pixel_n] = drawImage(image_x, image_y, image_array[pixel_n]["color"]);
              sp_array[pixel_n] = drawImage(image_x, image_y, image_array[pixel_n]["color"]);
              
              BetweenAS3.tween(sp_array[pixel_n], {x:int(image_array[pixel_n]["x"]), y:int(image_array[pixel_n]["y"])}).play();
              
              pixel_x++;
              pixel_n++;
           }
       }
       
     
       
       private function getColorArray(c:Number):String
       {
         var c_string:String = "0x" + getRgbString(c);
        
         return c_string;
       }
       
       private function getRgbString(c:Number):String
       {
           var rgb:String = ("00000" + c.toString(16)).substr(-6).toUpperCase();
           return rgb;
       }
  }
}