/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lVtc
 */

package 
{
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.geom.Matrix3D;
	import flash.geom.Utils3D;
	import flash.geom.Vector3D;
	import flash.utils.getTimer;
	import net.hires.debug.Stats;
	
	/**
	 * ローレンツアトラクタの勉強
	 * 下記を参考にさせて頂きました。
	 * http://rest-term.com/archives/90/
	 */
	[SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
	public class Main extends Sprite 
	{
		
		private var vec:Vector.<Number> = new Vector.<Number>();
		private var vec2d:Vector.<Number> = new Vector.<Number>();
		
		private var oldVec:Vector.<Number> = new Vector.<Number>();
		private var oldVec2d:Vector.<Number> = new Vector.<Number>();
		
		private var uvts:Vector.<Number> = new Vector.<Number>();
		
		private var shape:Shape = new Shape();
		
		private var matrix3d:Matrix3D = new Matrix3D();
		
		public function Main():void 
		{
			this.init();
		}
		
		private function init(e:Event = null):void 
		{
			this.stage.quality = StageQuality.LOW;
			
			this.addChild( new Stats() );
			
			this.addChild( this.shape );
			this.shape.x = 232;
			this.shape.y = 232;
			
			this.vec[0] = 1;
			this.vec[1] = 2;
			this.vec[2] = 3;
			
			this.addEventListener(Event.ENTER_FRAME , enterFrameHandler);
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			this.shape.graphics.clear();
			this.matrix3d.appendRotation( 0.6, Vector3D.X_AXIS);
			this.matrix3d.appendRotation( 0.8, Vector3D.Y_AXIS);
			this.matrix3d.appendRotation( 1.0, Vector3D.Z_AXIS);
			for (var i:int = 0; i < 1000; i++) this.update();
		}
		
		private function update():void
		{
			this.move();
			this.move();
			this.draw();
		}
		
		private function move():void
		{
			this.oldVec[0] = this.vec[0];
			this.oldVec[1] = this.vec[1];
			this.oldVec[2] = this.vec[2];
			
			var p:Number = (Math.sin(getTimer() / 5000)/2 + 0.5) * 3 + 9;
			var r:Number = (Math.sin(getTimer() / 4000)/2 + 0.5) * 8 + 24;
			var b:Number = (Math.sin(getTimer() / 6000)/2 + 0.5) * 3 + 3;
			var k:Number = (Math.sin(getTimer() / 6000)*0.5 + 0.5) * 0.01 + 0.01;
			
			var dx:Number = -p * this.vec[0] + p * this.vec[1];
			var dy:Number =  r * this.vec[0] - this.vec[1] - this.vec[0] * this.vec[2];
			var dz:Number = -b * this.vec[2] + this.vec[0] * this.vec[1];
			
			this.vec[0] += dx * k;
			this.vec[1] += dy * k;
			this.vec[2] += dz * k;
			
		}
		
		private function draw():void
		{
			
			var scale:Number = 5;
			
			Utils3D.projectVectors(this.matrix3d , this.vec , this.vec2d , this.uvts);
			Utils3D.projectVectors(this.matrix3d , this.oldVec , this.oldVec2d , this.uvts);
			
			var g:Graphics = this.shape.graphics;
			g.lineStyle(0.1, 0 , 0.3);
			g.moveTo( this.oldVec2d[0] * scale , this.oldVec2d[1] * scale );
			g.lineTo( this.vec2d[0] * scale , this.vec2d[1] * scale );
			
		}
		
	}
	
}