/**
 * Copyright Evolutor ( http://wonderfl.net/user/Evolutor )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lUgp
 */

// forked from ProjectNya's ひよこちゃんをフリックする
////////////////////////////////////////////////////////////////////////////////
// ひよこちゃんをフリックする
//
// 背景クリックで、フルスクリーン表示になります。
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
     import flash.display.StageAlign;
    import flash.display.StageDisplayState;
    import flash.display.MovieClip;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.system.LoaderContext;
    import flash.display.Shape;
    import flash.geom.Matrix;
    import flash.display.GradientType;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var background:Shape;
        private var loader:Loader;
        private static var piyoPath:String = "http://www.project-nya.jp/images/flash/piyo2d.swf";
        private var Piyo:Class;
        private var piyo:MovieClip;
        private var position:Number = 0;
        private var clickPos:Number = 0;
        private static var deceleration:Number = 0.5;
        private var velocity:Number = 0;
        private var releasePos:Number = 0;

        public function Main() {
            //Wonderfl.disable_capture();
            Wonderfl.capture_delay(4);
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
        }

        private function init(evt:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            draw();
            Security.allowDomain("www.project-nya.jp");
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(new URLRequest(piyoPath), new LoaderContext(true));
            stage.addEventListener(Event.RESIZE, resize, false, 0, true);
            stage.addEventListener(MouseEvent.CLICK, click, false, 0, true);
        }
        private function complete(evt:Event):void {
            loader.removeEventListener(Event.COMPLETE, complete);
            var content:MovieClip = MovieClip(evt.target.content);
            //Piyoクラス
            Piyo = MovieClip(content.piyo).constructor;
            setup();
            loader = null;
        }
        private function setup():void {
            //Piyoインスタンス
            piyo = new Piyo();
            addChild(piyo);
            piyo.x = 232;
            piyo.y = 380;
            piyo.scale = 2;
            //ドラッグできるようにする
            piyo.mouseChildren = false;
            piyo.buttonMode = true;
            piyo.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
        }
        //マウスダウンでドラッグ開始
        private function press(evt:MouseEvent):void {
            piyo.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutside, false, 0, true);
            stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
            clickPos = piyo.mouseX;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, drag, false, 0, true);
        }
        //マウスアップでドラッグ停止
        private function release(evt:MouseEvent):void {
            piyo.removeEventListener(MouseEvent.MOUSE_UP, release);
            stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
            stage.removeEventListener(Event.MOUSE_LEAVE, leave);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
            releasePos = stage.mouseX;
            stage.addEventListener(Event.ENTER_FRAME, observe, false, 0, true);
        }
        //ドラッグ停止
        private function releaseOutside(evt:MouseEvent):void {
            piyo.removeEventListener(MouseEvent.MOUSE_UP, release);
            stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
            stage.removeEventListener(Event.MOUSE_LEAVE, leave);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
            releasePos = stage.mouseX;
            stage.addEventListener(Event.ENTER_FRAME, observe, false, 0, true);
        }
        private function leave(evt:Event):void {
            piyo.removeEventListener(MouseEvent.MOUSE_UP, release);
            stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
            stage.removeEventListener(Event.MOUSE_LEAVE, leave);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
            releasePos = stage.mouseX;
            stage.addEventListener(Event.ENTER_FRAME, observe, false, 0, true);
        }
        //ドラッグ
        private function drag(evt:MouseEvent):void {
            position = stage.mouseX - clickPos;
            if (position < 60) position = 60;
            if (position > stage.stageWidth - 60) position = stage.stageWidth - 60;
            if (!hasEventListener(Event.ENTER_FRAME)) addEventListener(Event.ENTER_FRAME, slide, false, 0, true);
            evt.updateAfterEvent();
        }
        private function slide(evt:Event):void {
            piyo.x += (position - piyo.x)*deceleration;
            if (Math.abs(position - piyo.x) < 0.5) {
                piyo.x = position;
                removeEventListener(Event.ENTER_FRAME, slide);
            }
        }
        private function observe(evt:Event):void {
            stage.removeEventListener(Event.ENTER_FRAME, observe);
            velocity = stage.mouseX - releasePos;
            if (Math.abs(velocity) > 5) flick();
            releasePos = stage.mouseX;
        }
        private function flick():void {
            position += velocity*10;
            if (position < 60) position = 60;
            if (position > stage.stageWidth - 60) position = stage.stageWidth - 60;
        }
        /////////////////////////////////////////////
        //フルスクリーン
        /////////////////////////////////////////////
        private function resize(evt:Event):void {
            background.width = stage.stageWidth;
            background.height = stage.stageHeight;
            piyo.x = uint(background.width/2);
            piyo.y = uint(background.height/465*350) + 30;
            if (stage.displayState == StageDisplayState.NORMAL) {
                stage.addEventListener(MouseEvent.CLICK, click, false, 0, true);
            }
        }
        private function click(evt:MouseEvent):void {
            if (stage.displayState == StageDisplayState.NORMAL) {
                stage.displayState = StageDisplayState.FULL_SCREEN;
                stage.removeEventListener(MouseEvent.CLICK, click);
            } else {
                stage.displayState = StageDisplayState.NORMAL;
            }
        }
        /////////////////////////////////////////////
        //背景
        /////////////////////////////////////////////
        private function draw():void {
            background = new Shape();
            addChild(background);
            drawSky();
            drawGround();
        }
        private function drawSky():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 350, 0.5*Math.PI, 0, 0);
            background.graphics.beginGradientFill(GradientType.LINEAR, [0x3F68AB, 0x77B2EE], [1, 1], [0, 255], matrix);
            background.graphics.drawRect(0, 0, 465, 350);
            background.graphics.endFill();
        }
        private function drawGround():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 150, 0.5*Math.PI, 0, 350);
            background.graphics.beginGradientFill(GradientType.LINEAR, [0x99CC33, 0x7EB133], [1, 1], [0, 255], matrix);
            background.graphics.drawRect(0, 350, 465, 150);
            background.graphics.endFill();
        }

    }

}
