/**
 * Copyright OneInchPunch ( http://wonderfl.net/user/OneInchPunch )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lUEE
 */

// forked from OneInchPunch's TYPOGRAPHY LESSON 101 (090526)
// ビットマップにつっこんでみた。
// タイポでなにかしてみたい
// なんかもっさりしてる。ビットマップ化したほうがよさそう

package {
    import flash.display.*;
    import flash.events.*;
    import flash.utils.Timer;
    import flash.text.*;
    import caurina.transitions.Tweener;
    
    [SWF(backgroundColor="#000000", frameRate=30)]
    
    
    public class TextOverflow extends Sprite {
        [Embed(systemFont="serif", fontName="font", unicodeRange="U+0041-U+005A", mimeType="application/x-font")]
        private var font:Class;
        
        private var stageW:Number = stage.stageWidth;
        private var stageH:Number = stage.stageHeight;
        
        
        public function TextOverflow():void {
            var _timer:Timer = new Timer(1000, 20);
            _timer.addEventListener(TimerEvent.TIMER, textSet);
            _timer.start();
        }
        
        
        public function textSet(e:TimerEvent):void {
            var typo:Array = new Array();
            var typoContainer:Sprite = new Sprite();
            var bitmapData:BitmapData = new BitmapData(stageW, stageH, true, 0x00000000);
            var bitmap:Bitmap = new Bitmap();
            
            typo = 'E M B E D'.split(' ');
            
            // ダイナミックテキストにアルファ効かす
            blendMode = BlendMode.LAYER;
            
            var tfm:TextFormat = new TextFormat();
            tfm.size = 100;
            tfm.font = "font";
            tfm.align = TextFormatAlign.CENTER;
            
            for (var i:int=0; i<typo.length; i++) {
                var textRGB:Number = Math.random() * 0xffffff;
                tfm.color = textRGB;
                
                var textPosX:Number = Math.floor(Math.random()*(stageW/2)-100);
                var textPosY:Number = Math.floor(Math.random()*(stageH/2)-100);
                var textScale:Number = Math.floor((Math.random()*5)+2);
                
                var tf:TextField = new TextField();
                tf.defaultTextFormat = tfm;
                tf.text = typo[i];
                tf.alpha = 0.5;
                tf.background = false;
                tf.selectable = false;
                tf.wordWrap = false;
                
                tf.x = textPosX;
                tf.y = textPosY;
                tf.scaleX = textScale;
                tf.scaleY = textScale;
                
                typoContainer.addChild(tf);
            }
            
            bitmapData.draw(typoContainer);
            bitmap.bitmapData = bitmapData;
            bitmap.x = 0;
            bitmap.y = 0;
            bitmap.blendMode = BlendMode.ADD;
            bitmap.smoothing = true;
            bitmap.alpha = 0;
            Tweener.addTween(bitmap, {alpha:0.5, time:5, transition:"liner"});
            addChild(bitmap);
        }
    }
}