/**
 * Copyright pupoppy ( http://wonderfl.net/user/pupoppy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lTzr
 */

/*********************************************************
 * XMLクラスの構造は
 * XML.children() → XMLList
 * XMLList[n] → XML
 * となっているので、こんな風に取得できるという小ネタ。
 *********************************************************/
package {
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var txt:TextField = new TextField();
            txt.autoSize = TextFieldAutoSize.LEFT;
            txt.text = xmlTracer(XML(XML_DATA));
            addChild(txt);
        }

        private static const XML_DATA:String =
            "<?xml version=\"1.0\" encoding=\"shift-jis\" ?>" + "\n" +
            "<root>" + "\n" +
            "  <hoge />" + "\n" +
            "  <employees type=\"Array\">" + "\n" +
            "    <item type=\"Object\">" + "\n" +
            "      <id type=\"String\" primary=\"true\">1234567890</id>" + "\n" +
            "      <name type=\"String\">東京太郎</name>" + "\n" +
            "    </item>" + "\n" +
            "    <item type=\"Object\">" + "\n" +
            "      <id type=\"String\" primary=\"true\">12345ABCDE</id>" + "\n" +
            "      <name type=\"String\">バングラデシュ太郎</name>" + "\n" +
            "    </item>" + "\n" +
            "  </employees>" + "\n" +
            "  <employees type=\"Array\">" + "\n" +
            "    <item type=\"Object\">" + "\n" +
            "      <id type=\"String\" primary=\"true\">ABDEFGHIJKLMN</id>" + "\n" +
            "      <name type=\"String\">アンゴラ共和国太郎</name>" + "\n" +
            "    </item>" + "\n" +
            "  </employees>" + "\n" +
            "</root>";

        private function xmlTracer(xml:XML, nest:uint = 0):String
        {
            var i:uint;
            var result:String = "";
            // インデント処理
            for (i = 0; i < nest * 2; i++) result += " ";
            // xml.nameがある場合はブロックが存在している
            if (xml.name()) {
                // タグ名取得
                result += "<" + xml.name().toString();
                // 属性名・値取得
                for each (var attr:XML in xml.attributes())
                    result += " " + attr.name().toString() + "=\"" + attr.toString() + "\"";
                // 子がある場合は再帰
                if (xml.children().length() > 0) {
                    // タグ末尾設定
                    result += ">\n";
                    for each (var child:XML in xml.children())
                        result += xmlTracer(child, nest + 1);
                    // インデント処理
                    for (i = 0; i < nest * 2; i++) result += " ";
                    // タグ閉じる
                    result += "</" + xml.name().toString() + ">\n";
                }
                // 子がいない場合はタグを一行で閉じる
                else
                    result += " />\n"
            }
            // xml.nameがない場合は値のみとみなす
            else
                result += xml.toString() + "\n";
            return result;
        }
    }
}