/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lTD8
 */






package 
{
    import flash.events.*;
    import org.papervision3d.Papervision3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.core.math.Matrix3D;
    import caurina.transitions.*;

    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#FFFFFF")]


    public class Matrix3d extends BasicView 
    {
        private var _cube:Cube;
        private var _particleField:ParticleField;        
        private var _particlesVertices:Array/*vertices*/;
        private var _cubeVertices:Array/*vertices*/;        
        private var _flg1:Boolean = false;
        private var _flg2:Boolean = false;
        //----------------------------------------------------------------------------------
        // constructor
        //----------------------------------------------------------------------------------
        public function Matrix3d() {
            Papervision3D.PAPERLOGGER.unregisterLogger(Papervision3D.PAPERLOGGER.traceLogger);        
            super(645, 645, true, false);
            
            //camera setting
            camera.x = 200;
            camera.y = 120;
            camera.z = 200;
            
            //create Cube
            var mat:WireframeMaterial = new WireframeMaterial(0xBBBBBB);
            mat.doubleSided = true;
            var matList:MaterialsList = new MaterialsList({all:mat});
            _cube = new Cube(matList, 100, 100, 100, 2, 2, 2);
            _cubeVertices = _cube.geometry.vertices;
            scene.addChild(_cube);
            
            //create ParticleField
            _particleField = new ParticleField(new ParticleMaterial(0xFF0000, 1, 1), _cubeVertices.length, 5, 300, 300, 300);
            _particlesVertices = _particleField.geometry.vertices;
            scene.addChild(_particleField);
            
            //click event
            stage.addEventListener(MouseEvent.CLICK, clickHandler);
            
            //start Rendering
            startRendering();
        }
        //----------------------------------------------------------------------------------
        // clickHandler
        //----------------------------------------------------------------------------------
        private function clickHandler(e:MouseEvent):void {
            _flg1 = !_flg1;
            
            for (var v:Object in _cubeVertices) {
                if (_flg1) {
                    Tweener.addTween(_particlesVertices[v], { 
                        x:_cubeVertices[v].x, 
                        y:_cubeVertices[v].y, 
                        z:_cubeVertices[v].z, 
                        time:0.6, transition:"easeInOutExpo", 
                        onComplete:func, 
                        onCompleteParams:[true] } 
                    );
                }else {
                    Tweener.addTween(_particlesVertices[v], {
                        x:(Math.random() - 0.5) * 300, 
                        y:(Math.random() - 0.5) * 300, 
                        z:(Math.random() - 0.5) * 300, 
                        time:0.6, transition:"easeInOutExpo", 
                        onStart:func, 
                        onStartParams:[false] }
                    );
                }
            };
        }
        //----------------------------------------------------------------------------------
        // func
        //----------------------------------------------------------------------------------
        private function func(boolean:Boolean):void {
            _flg2 = boolean;
        }
        //----------------------------------------------------------------------------------
        // onRenderTick
        //----------------------------------------------------------------------------------
        override protected function onRenderTick(e:Event = null):void {
            super.onRenderTick();    
            
            //回転について　↓のどちらかのコードをコメントアウト比べてみてください。
            _cube.transformVertices(Matrix3D.rotationMatrix(0, 1, 0, 0.03));    //これを使うと追いかける
            //_cube.rotationY += 1.5;                                             //これを使うと追いかけない
            
            //移動について　↓のどちらかのコードをコメントアウト比べてみてください。
            //_cube.transformVertices(Matrix3D.translationMatrix(0.1, 0, 0));     //これを使うと追いかける
            //_cube.x += 0.1;                                                     //これを使うと追いかけない
            
            //伸縮について　↓のどちらかのコードをコメントアウト比べてみてください。
            //_cube.transformVertices(Matrix3D.scaleMatrix(0.999, 0.999, 0.999)); //これを使うと追いかける
            //_cube.scale -= 0.001;                                               //これを使うと追いかけない
            
            if (_flg2) {
                for ( var v:Object in _cubeVertices ) {
                    var p:Object = _particlesVertices[v];
                    p.x = _cubeVertices[v].x;
                    p.y = _cubeVertices[v].y;
                    p.z = _cubeVertices[v].z;
                }
            }else {
                _particleField.transformVertices(Matrix3D.rotationMatrix(0, -1, 0, 0.004));
            }
        }
    }
}