/**
 * Copyright ishihara ( http://wonderfl.net/user/ishihara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lT66
 */

// forked from okmt_masaaki's Bitmap transition
package {
    
    /*
    
    okmt.masaaki
    http://twitter.com/okamotomasaaki

    画面転換を自由度の高い効果で実行するためのクラス
    切り替えたい画像と、転換制御用の白黒画像をつっこむと
    自動的にアニメーション生成して画面転換してくれるというもの。
    切り替え用の画像は黒いところから順に表示されます。
    用途としてはプレゼンテーションやスライドショーとか？？
    
    var a:BitmapTransition = new BitmapTransition(
    切り替えたい画像のbitmapdata,
    転換制御用のbitmapData,
    切替速度のしきい値
    )
    */
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.utils.getDefinitionByName;
    

    
    import flash.text.TextField;
    public class Main extends Sprite {
        
        public static var refer:Main;
        private const imgMasterURL:String = "http://farm3.static.flickr.com/2796/4483236718_97a259a18a.jpg";
        private const imgAlphaURL:String = "http://farm3.static.flickr.com/2454/4388828622_e781f47762.jpg";
        //private const imgAlphaURL:String = "http://masaaki.s261.xrea.com/alpha2.jpg";
        //private const imgAlphaURL:String = "http://masaaki.s261.xrea.com/alpha3.jpg";
        private const imgBaseURL:String = "http://farm3.static.flickr.com/2454/4388828622_e781f47762.jpg";
        
        private var imgMaster:Bitmap;
        private var imgAlpha:Bitmap;
        private var imgBase:Bitmap;
        private var imgAr:Vector.<Bitmap> = new Vector.<Bitmap>();
        
        //　めんどい。。。画像の読み込み
        
        public function Main():void{imgloading(imgMasterURL, 0, imgload1)}
        private function imgload1():void{    imgloading(imgAlphaURL, 1, imgload2)}
        private function imgload2():void{    imgloading(imgBaseURL, 2, initialize)}
        private function imgloading(url:String, cnt:uint , nextFunc:Function):void
        {
            var myLoader:Loader = new Loader();
            var myURLRequest:URLRequest = new URLRequest(url);
            var myLoaderContext:LoaderContext = new LoaderContext(true);
            myLoader.load(myURLRequest , myLoaderContext);
            myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void
            {
                imgAr[cnt]= e.target.content;
                nextFunc();
            });    
        }
        
        private function initialize():void
        {
            
            //背景の設置
            addChild(imgAr[2]);
            
            //トランジッション設定　たったこれだけ！（第一引数：切り替えたい画像のbitmapdata    第二引数：切替に使う白黒画像    第三引数：切替速度1～10ぐらいまで？ ）
            addChild(new BitmapTransition(imgAr[0].bitmapData, imgAr[1].bitmapData, 4));
            
            //↓はサムネイル表示用のゴミ
            var sub1:Bitmap = new Bitmap(imgAr[2].bitmapData);
            var sub2:Bitmap = new Bitmap(imgAr[1].bitmapData);
            var sub3:Bitmap = new Bitmap(imgAr[0].bitmapData);
            sub1.width = sub2.width = sub3.width = 120;
            sub1.height = sub2.height = sub3.height = 90;
            sub1.y = sub2.y = sub3.y = imgAr[0].bitmapData.height+30;
            sub1.x = 0;
            sub2.x = 130;
            sub3.x = 260;
            addChild(sub1);
            addChild(sub2);
            addChild(sub3);
            
            var t1:TextField = new TextField();
            var t2:TextField = new TextField();
            var t3:TextField = new TextField();
            t1.text = "元画像";
            t2.text = "転換用画像";
            t3.text = "切り替え後の画像";
            t1.y = t2.y = t3.y = imgAr[0].bitmapData.height+10;
            t1.x =0;
            t2.x = 130;
            t3.x = 260;
            addChild(t1);
            addChild(t2);
            addChild(t3);


        }
    }
}

//ここからがイケてるクラス

import flash.display.Bitmap;
import flash.display.Sprite;
import flash.display.BitmapData;
import flash.events.Event;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import flash.utils.getTimer;

internal class BitmapTransition extends Sprite
{
    //private var _bmpTemp:BitmapData;
    private var _bmpAlpha:BitmapData;
    private var _bmpResult:BitmapData;
    private var _bmpMaster:BitmapData;
    private var _sizeMaster:Rectangle;
    
    private var _duration:Number;
    private var _delay:Number;
    private var _cnt:uint = 0;
    
    public function BitmapTransition(bmpMaster:BitmapData, bmpAlpha:BitmapData, delay:Number=5 ) 
    {
        _bmpMaster = bmpMaster;
        _sizeMaster = new Rectangle(0, 0, bmpMaster.width, bmpMaster.height);
        
        _delay = delay;
        
        createResult();
        createAlpha(bmpAlpha);
        addEventListener(Event.ENTER_FRAME, reDraw);
    }
    
    
    private function createResult():void
    {
        _bmpResult = new BitmapData(_sizeMaster.width, _sizeMaster.height, true, 0x00000000);
        addChild(new Bitmap(_bmpResult));
    }
    private function createAlpha(bmp:BitmapData):void
    {
        _bmpAlpha = new BitmapData(_sizeMaster.width, _sizeMaster.height, false);
        var mtx:Matrix = new Matrix();
        mtx.scale(_sizeMaster.width / bmp.width, _sizeMaster.height / bmp.height);
        _bmpAlpha.draw(bmp, mtx);
    }
    
    private function reDraw(e:Event = null):void
    {
        
        var v:uint = _sizeMaster.height;
        var h:uint = _sizeMaster.width;
        var mydelay:uint;
        var color:uint
        _bmpResult.lock();
        
        //↓だれか最適化してください。。。。
        for (var j:int = 0; j < v; j++) {
            for (var i:int = 0; i < h; i++) {
                mydelay = uint((_bmpAlpha.getPixel(i, j) >> 16) / _delay );//0~255までの値を吐く
                if ((mydelay <= _cnt && mydelay+10 >= _cnt))
                {
                    color  = uint((_cnt - mydelay) / 10 * 255) << 24
                    _bmpResult.setPixel32(i, j, color | uint(_bmpMaster.getPixel(i, j)));
                }
            }
        }
        _bmpResult.unlock();
        _cnt++;
        if (_cnt > 255/_delay+10)
        {
            removeEventListener(Event.ENTER_FRAME, reDraw);
        }
    }
}


