/**
 * Copyright mex_ny ( http://wonderfl.net/user/mex_ny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lRMR
 */

/**
 * Copyright mex_ny ( http://wonderfl.net/user/mex_ny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lRMR
 */

/*
TwitterのTL見たらこういう
(ttp://fichtre.net/yop.html)のが流行ってる(?)
みたいなので、タグ生成のジェネレータを作ってみた。
生成後のタグはCtrl+Aとかでコピーしてください。
*/


package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import com.bit101.components.PushButton;
	import flash.events.MouseEvent;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.filters.BlurFilter;
	import flash.geom.Matrix;
	import flash.net.FileReference;
	import flash.net.FileFilter;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	
	public class Main extends Sprite 
	{
 
		private const IMAGE_SIZE:uint = 400;
		private const TEXT_FORM_WIDTH:uint = 400;
		private const INPUT_TEXT_FORM_HEIGHT:uint = 100;
		private const DOT_SIZE:uint = 8;
		private const DEFAULT_TEXT:String = "画像ファイルを読み込んだ後に文字を入力してください。全角文字だけの方が良いかもしれません。画像読み込み完了＆文字入力完了後に下のボタンをぽちっとな。生成後のタグはCtrl+Aとかでコピーしてhtmlファイルに張り付けてください。";
		private var _fileRef:FileReference;
		private var _loader:Loader;
		private var _bg:Sprite;
		private var _loadButton:PushButton;
		private var _createButton:PushButton;
		private var _inputTextForm:TextField;
		private var _generatTextForm:TextField;
		private var _cg:CodeGenerator;
		private var _loadImageBitmap:Bitmap;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init( $e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			Wonderfl.capture_delay( 15 );
		
			stage.align = StageAlign.TOP_LEFT;
			stage.quality = StageQuality.HIGH;
			stage.scaleMode = StageScaleMode.NO_SCALE;

			_fileRef = new FileReference();
			_loader = new Loader();
			
			addChild( _bg = new Sprite() );
			_cg = new CodeGenerator( _bg );
			addForm();
			addChild( _cg );
		}
		
		private function addForm():void
		{
			_loadButton = new PushButton( this, 0, 0, "IMAGE LOAD", loadHandler );
			addInputTextForm();
			_createButton = new PushButton( this , 0 , _loadButton.height + INPUT_TEXT_FORM_HEIGHT , "CREATE HTML CODE" , createHandler );
			addTextField();
		}
		
		private function loadHandler(e:MouseEvent):void
		{
			if ( _loadImageBitmap != null )
			{
				_loadImageBitmap.bitmapData.dispose();
				while ( _bg.numChildren > 0 ) _bg.removeChildAt( 0 );
				_loadImageBitmap = null;
			}
			_cg.removeBitmap();
			_fileRef.addEventListener( Event.SELECT, selectedHandler );
			_fileRef.browse( [ new FileFilter( "Images", "*.jpg;*.jpeg;*.gif;*.png" ) ] );
		}
		
		private function selectedHandler( $e:Event ):void
		{
			_fileRef.removeEventListener(Event.SELECT, selectedHandler);
			_fileRef.addEventListener(Event.COMPLETE, loadCompleteHandler );
			_fileRef.load();
		}
		
		private function loadCompleteHandler( $e:Event ):void
		{
			_fileRef.removeEventListener(Event.COMPLETE, loadCompleteHandler );
			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, refDataLoadCompleteHandler );
			_loader.loadBytes( _fileRef.data );
		}
		
		private function refDataLoadCompleteHandler( $e:Event ):void
		{
			_loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, refDataLoadCompleteHandler );
			addImage( Bitmap( _loader.content ).bitmapData );
		}
		
		private function addImage( bmd:BitmapData ):void {
			var w:uint, h:uint, scale:Number,data:BitmapData;
			w = bmd.width;
			h = bmd.height;
			scale = Math.min( IMAGE_SIZE / w, IMAGE_SIZE / h );
			if (scale > 1) scale = 1;
			if (data) data.dispose();
			data = new BitmapData( w * scale, h * scale );
			data.draw( bmd, new Matrix(scale, 0, 0, scale) );
			_bg.addChild( _loadImageBitmap = new Bitmap( data ) );
		}

		private function addInputTextForm():void
		{
			addChild( _inputTextForm = new TextField() );
			_inputTextForm.border = true;
			_inputTextForm.background = true;
			_inputTextForm.backgroundColor = 0xFFFFFF;
			_inputTextForm.y = _loadButton.height;
			_inputTextForm.width = TEXT_FORM_WIDTH;
			_inputTextForm.height = INPUT_TEXT_FORM_HEIGHT;
			_inputTextForm.filters = [ new BlurFilter( 0 , 0 ) ];
			_inputTextForm.alpha = .5;
			_inputTextForm.wordWrap = true;
			_inputTextForm.type = TextFieldType.INPUT;
			_inputTextForm.text = DEFAULT_TEXT;
		}
		
		private function createHandler( $e:Event ):void
		{
			var text:String = ( _inputTextForm.text != "" ) ? _inputTextForm.text : DEFAULT_TEXT;
			
			if ( _loadImageBitmap != null )
			{
				_cg.makeCode( _loadImageBitmap , text , DOT_SIZE  );
				generatTextFormUpdate();
			}
		}

		private function addTextField():void
		{
			addChild( _generatTextForm = new TextField() );
			_generatTextForm.y = _loadButton.height + INPUT_TEXT_FORM_HEIGHT + _createButton.height;
			_generatTextForm.border = true;
			_generatTextForm.multiline = true;
			_generatTextForm.background = true;
			_generatTextForm.backgroundColor = 0xCCCCCCC;
			_generatTextForm.textColor = 0x0000ff;
			_generatTextForm.width = TEXT_FORM_WIDTH;
                         _generatTextForm.height = 300;
			_generatTextForm.wordWrap = true;
			_generatTextForm.filters = [ new BlurFilter( 0 , 0 ) ];
			_generatTextForm.alpha = .8;
		}
		
		private function generatTextFormUpdate():void
		{
			_generatTextForm.text = _cg.htmlText;
		}
	}
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Point;
import flash.display.Sprite;

class CodeGenerator extends Sprite
{
	
	private var _htmlText:String;
	private var _layer:Sprite;

	public function CodeGenerator( layer:Sprite ):void
	{
		_layer = layer;
		_htmlText = "";
	}

	public function makeCode( bmp:Bitmap , text:String , perticleSize:uint = 10 ):void
	{
		var xLen:uint , yLen:uint , yCount:uint , i:uint , j:uint , baseX:uint , baseY:uint, color:uint , imgBitmapData:BitmapData , positionX:Number , perticleHalfSize:Number , bitmapData:BitmapData, makeBitmap:Bitmap, cssText:String, htmlText:String;
		var r:uint , g:uint , b:uint, textLen:uint, textCount:uint, cssTextObject:Object, classNameObject:Object, key:String, counter:uint;

		yCount = textCount = 0;
		xLen = bmp.width /  perticleSize;
		yLen = bmp.height / perticleSize;
		imgBitmapData = bmp.bitmapData;
		perticleHalfSize = perticleSize / 2;
		cssText = htmlText = "";
		textLen = text.length;
		cssTextObject = classNameObject = new Object();
		counter = 1;

		for ( i = 0; i < yLen; i++)
		{
			baseY = i * perticleSize;
			htmlText += '<div id="l' + yCount + '">';
			
			for ( j = 0; j < xLen; j++ )
			{
				baseX = j * perticleSize;
				positionX = baseX + perticleHalfSize;
				color = imgBitmapData.getPixel32( positionX , baseY + perticleHalfSize);
				r = ( color & 0xff0000 ) >> 16;
				g = ( color & 0xff00  ) >> 8;
				b = color & 0xff;
				key = String( r ) + String( g ) + String( b );
				if( !cssTextObject[key] )
				{
					cssText += '.c' + counter + '::selection {background: rgb(' + r+ ', ' + g + ',' + b + ');color: rgb(0, 0, 0)}';
					cssText += '.c' + counter + '::-moz-selection {background: rgb(' + r + ', ' + g + ',' + b + ');color: rgb(0, 0, 0)}';
					cssTextObject[key] = counter;
					counter += 1;
				}
				htmlText += '<span class="c' + cssTextObject[key] + '">'+ text.substr( textCount , 1 ) +'</span>';

				bitmapData = new BitmapData( perticleSize, perticleSize, false , color );
				makeBitmap = new Bitmap( bitmapData );
				makeBitmap.x = baseX;
				makeBitmap.y = baseY;
				_layer.addChild(makeBitmap);
				
				textCount += 1;
				if ( textCount == textLen ) textCount = 0;
			}
			yCount += 1;
			htmlText += '</div>'
		}
		//cssText += 'span {letter-spacing: 8px;}';
		
		_htmlText = '<!DOCTYPE HTML><html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8"><title>hoge</title><style type="text/css" media="screen">';
		_htmlText += cssText;
		_htmlText += '</style></head><body><pre id="sel">';
		_htmlText += htmlText;
		_htmlText += '</pre></body></html>';
	}
	
	public function removeBitmap():void
	{
		var bm:Bitmap;
		
		while ( _layer.numChildren > 0 )
		{
			bm = getChildAt( 0 ) as Bitmap;
			_layer.removeChild( bm );
			bm.bitmapData.dispose();
		}
	}
	
	public function get htmlText():String { return _htmlText; }
}
