/**
 * Copyright devon_o ( http://wonderfl.net/user/devon_o )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lQLR
 */

package 
{
    
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageScaleMode;
import flash.events.Event;
import flash.geom.Point;

/**
 * Quick clock idea
 * @author Devon O.
 */

[SWF(width='465', height='465', backgroundColor='#000000', frameRate='60')]
public class Main extends Sprite 
{
    public static const COLOR_SECONDS:uint = 0xFFFF00;
    public static const COLOR_MINUTES:uint = 0xFF0000;
    public static const COLOR_HOURS:uint = 0x0000FF;
    
    private var secondsHand:Shape;
    private var secondsTarget:Number;
    
    private var minutesHand:Shape;
    private var minutesTarget:Number;
    
    private var hoursHand:Shape;
    private var hoursTarget:Number;
    
    public function Main():void 
    {
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event = null):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        
        initStage();
        initClock();
        
        addEventListener(Event.ENTER_FRAME, update);
    }
    
    private function initStage():void
    {
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;
        stage.showDefaultContextMenu = false;
    }
    
    private function initClock():void
    {
        //background
        graphics.beginFill(0x000000);
        graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        graphics.endFill();
        
        // Little white line every 5 minute mark
        const numItems:int = 12;
        const rad:int = 200;
        const arcLength:Number = ( Math.PI * 2  ) / numItems;
        const cx:int = stage.stageWidth >> 1;
        const cy:int = stage.stageHeight >> 1;
        
        for (var i:int = 0; i < numItems; i++) 
        {
            var p:Point = Point.polar(rad, (i * arcLength));
            var s:Shape = new Shape();
            s.graphics.lineStyle(0, 0xFFFFFF);
            s.graphics.moveTo(0, 0);
            s.graphics.lineTo(15, 0);
            s.x = p.x + cx;
            s.y = p.y + cy;
            var dx:Number = cx - s.x;
            var dy:Number = cy - s.y;
            s.rotation = Math.atan2(dy, dx) * 180 / Math.PI;
            addChild(s);
        }
        
        // Hours hand
        this.hoursHand = new Shape();
        this.hoursHand.rotation = -90;
        this.hoursHand.x = stage.stageWidth >> 1;
        this.hoursHand.y = stage.stageHeight >> 1;
        addChild(this.hoursHand);
        
        // Minutes hand
        this.minutesHand = new Shape();
        this.minutesHand.rotation = -90;
        this.minutesHand.x = stage.stageWidth >> 1;
        this.minutesHand.y = stage.stageHeight >> 1;
        addChild(this.minutesHand);
        
        // Seconds hand
        this.secondsHand = new Shape();
        this.secondsHand.rotation = -90;
        this.secondsHand.x = stage.stageWidth >> 1;
        this.secondsHand.y = stage.stageHeight >> 1;
        addChild(this.secondsHand);
        
        // Covers up center
        var cover:Shape = new Shape();
        cover.graphics.beginFill(0x000000);
        cover.graphics.drawCircle(0, 0, 120);
        cover.x = stage.stageWidth >> 1;
        cover.y = stage.stageHeight >> 1;
        addChild(cover);
        
        // set initial data
        var now:Date = new Date();
        
        this.secondsTarget = now.seconds / 60;
        this.minutesTarget = now.minutes / 60;
        
        var h:Number = now.hours;
        h = h > 12 ? h - 12 : h;
        this.hoursTarget = h / 12;
    }
    
    private function drawCircleSegment(g:Graphics, radius:Number = 100, endAngle:Number = 1):void
    {
        var startAngle:Number = 0.0;
        endAngle = 2 * Math.PI * endAngle;
        var d:Number = Math.abs(endAngle - startAngle);
        var divs:int = int(d / (Math.PI / 4) ) + 1;
        var span:Number = d / (2 * divs);
        var rc:Number = radius / Math.cos(span);
        g.moveTo(Math.cos(startAngle) * radius, Math.sin(startAngle) * radius);
        while (divs--) 
        {
            endAngle = startAngle + span;
            startAngle = endAngle + span;
            g.curveTo(Math.cos(endAngle)   * rc, 
                      Math.sin(endAngle)   * rc, 
                      Math.cos(startAngle) * radius, 
                      Math.sin(startAngle) * radius );
        }
        g.lineTo(0, 0);
    }
    
    private function update(event:Event):void
    {
        var now:Date = new Date();
        
        var seconds:Number = now.seconds;
        var minutes:Number = now.minutes;
        var hours:Number = now.hours;
        hours = hours > 12 ? hours - 12 : hours;
        
        var secondsRatio:Number = seconds / 60;
        var minutesRatio:Number = minutes / 60;
        var hoursRatio:Number = hours / 12;
        
        this.secondsTarget += (secondsRatio - this.secondsTarget) / 8;
        this.minutesTarget += (minutesRatio - this.minutesTarget) / 8;
        this.hoursTarget += (hoursRatio - this.hoursTarget) / 8;
        
        this.secondsHand.graphics.clear();
        this.secondsHand.graphics.beginFill(COLOR_SECONDS);
        drawCircleSegment(this.secondsHand.graphics, 130, this.secondsTarget);
        this.secondsHand.graphics.endFill();
        
        this.minutesHand.graphics.clear();
        this.minutesHand.graphics.beginFill(COLOR_MINUTES);
        drawCircleSegment(this.minutesHand.graphics, 150, this.minutesTarget);
        this.minutesHand.graphics.endFill();
        
        this.hoursHand.graphics.clear();
        this.hoursHand.graphics.beginFill(COLOR_HOURS);
        drawCircleSegment(this.hoursHand.graphics, 170, this.hoursTarget);
        this.hoursHand.graphics.endFill();
    }
    
}
    
}