/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lPfC
 */

// forked from termat's flash on 2010-6-3
package
{
    import flash.display.Sprite;
    import flash.events.Event;

    [SWF(width = "480", height = "480", backgroundColor = "0x000000", fps = "30")] 
    public class Practice73 extends Sprite{
        
        private var list:Array;
        private var color:uint = 0;
        
        public function Practice73() {
            list = new Array();
            var prev:Ball = null;
            for (var i:int = 0; i< 4; i++) {
                var b:Ball = new Ball(8, getColor((9*color++) % 360,1.0));
                if (prev != null) {
                    prev.next = b;
                }
                b.prev = prev;
                list.push(b);
                addChild(b);
                prev = b;
            }
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void {
            graphics.clear();
            for (var i:int = 0; i < list.length; i++) list[i].move(mouseX, mouseY);
            for (i = 0; i < list.length; i++) {
                list[i].update();
                if (list[i].prev != null) {
                    graphics.lineStyle(0.1, 0x330000ff);
                    graphics.moveTo(list[i - 1].x, list[i - 1].y);
                    graphics.lineTo(list[i].x, list[i].y);
                }
            }
        }
        
        private function getColor(i:int, saturation:Number):uint {
            var h:Number = i / 60;
            var ii:Number = Math.floor(h);
            var ff:Number = h - ii;
            var p1:Number = (1.0 - saturation);
            var p2:Number = (1.0 - saturation * ff);
            var p3:Number = (1.0 - saturation * (1.0 - ff));
            var rv:Number, gv:Number, bv:Number;
            switch(ii) {
            case 0:
                rv = 1.0, gv = p3, bv = p1;
                break;
            case 1:
                rv = p2, gv = 1.0, bv = p1;
                break;
            case 2:
                rv = p1, gv = 1.0, bv = p3;
                break;
            case 3:
                rv = p1, gv = p2, bv = 1.0;
                break;
            case 4:
                rv = p3, gv = p1, bv = 1.0;
                break;
            default:
                rv = 1.0, gv = p1, bv = p2;
            }
            var color:uint = (Math.max(0, Math.min(255, rv * 255)) << 16) + (Math.max(0, Math.min(255, gv * 255)) << 8) + Math.max(0, Math.min(255, bv * 255));
            return color;
        }
    }
}
import flash.display.Sprite;
class Ball extends Sprite {
    public var prev:Ball=null;
    public var next:Ball=null;
    public var size:int;
    public var color:uint;
    private var vx:Number=0;
    private var vy:Number=0
    
    public function Ball(s:int, c:uint) {
        size = s;
        color = c;
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, s);
    }
    
    public function move(mx:Number, my:Number):void {
        if (prev != null) {
            vx += (prev.x - x) / 35.0;
            vy += (prev.y - y) / 35.0;
        }else {
            vx += (mx - x) / 35.0;
            vy += (my - y) / 35.0;
        }
        if (next != null) {
            vx += (next.x - x) / 40.0;
            vy += (next.y - y) / 40.0;
        }
    }
    
    public function update():void {
        x += vx;
        y += vy;
    }
}