/**
 * Copyright Jenya ( http://wonderfl.net/user/Jenya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lOxK
 */

// forked from signedvoid's Rotated IsometricProjectionText 等角投影立体文字
// forked from nackpan's IsometricProjectionText 等角投影立体文字
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.ui.Keyboard;
    
    [SWF(width=465, height=465, backgroundColor=0xFFFFFF, frameRate=60)]
    public class Text3D extends Sprite {
        private var bmp:Bitmap;
        private var txt:TextField;
        private var angle:Number = 0;
        
        public function Text3D()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, onResize);
            var shape:Shape = new Shape();
            shape.graphics.drawRect(0, 0, 465, 465);
            stage.addChild(shape);
            
            bmp = new Bitmap();
            addChild(bmp);
            var str:String = "FFFUUU";
            setText(str, bmp);
            
            txt = new TextField();
            txt.border = true;
            txt.width = 100;
            txt.height = 20;
            txt.background = true;
            txt.backgroundColor = 0xeeeeee;
            txt.type = "input";
            txt.maxChars = 12;
            txt.text = str;
            addChild(txt);
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void
        {
            setText(txt.text, bmp);
            angle += 1.0;
        }
        
        private function setText(str:String, bmp:Bitmap):void
        {
            if (!str || str == "") return;
            var i:int;
            
            var sp:Shape = new Shape();
            var s_w:Number = stage.stageWidth;
            var s_h:Number = stage.stageWidth;
            var rot_m:Matrix = new Matrix();
            rot_m.createGradientBox(s_w, s_h/3, Math.PI / 2);
            with (sp) {
                graphics.clear();
                graphics.beginGradientFill("linear", [0xB0B0AA, 0xFFFFFF], [1, 0], [0, 255], rot_m);
                graphics.drawRect(0, 0, s_w, s_h/3);
                graphics.endFill();
            }
            
            var canvas:BitmapData =  new BitmapData(stage.width, stage.height, true, 0);
            canvas.draw(sp);
            
            var tf:TextField = new TextField();
            //addChild(tf);
            var fontSize:uint = stage.stageWidth / 5;
            var fmt:TextFormat = new TextFormat("_sans", fontSize, 0xffffff, true);// 7F7FFF, true); 
            tf.defaultTextFormat = fmt;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = str;
            var w:Number = tf.width;
            var h:Number = tf.height;
            var len:Number = (w > h)?w:h;
            
            //tf.filters = [new GlowFilter(0x7f0000,1,2,2,3)];
            var txt0:BitmapData = new BitmapData(w, h, true, 0);// false, 0x0);
            txt0.draw(tf);
            var degree:Number = angle;
            var rad:Number = Math.PI * degree / 180;
            var dx:Number = (0.5 - 0.5 * Math.cos(rad)) * w;
            var dy:Number = h * (1.0 - Math.sin(rad));
            var ipMatrix:Matrix = new Matrix();
            ipMatrix.rotate(rad);
            ipMatrix.scale(1, .5);
            ipMatrix.translate(dx, dy);
            //
            var txtSource:BitmapData =  new BitmapData(len + h, len + h, true, 0);
            txtSource.draw(txt0, ipMatrix, null, null, null, true);
            
            //
            var txtDataColumn:BitmapData = txtSource.clone();
            txtDataColumn.applyFilter(txtDataColumn, txtDataColumn.rect, new Point(0, 0), new BevelFilter(4,10, 0xFFFFFF,1,0xEEE0E0,1,1,1,1,1,"inner"));
            //txtDataColumn.applyFilter(txtDataColumn, txtDataColumn.rect, new Point(0, 0), new BlurFilter(2, 1, 1));
            
            //Shadow
            var txtDataShadow:BitmapData = txtSource.clone();
            var ctfShadow:ColorTransform = new ColorTransform(0, 0, 0);
            txtDataShadow.colorTransform(txtDataShadow.rect, ctfShadow);
            txtDataShadow.applyFilter(txtDataShadow, txtDataShadow.rect, new Point(0, 0), new BlurFilter(12,12,1));
            
            var m:Matrix = new Matrix();
            //stageの中央に描画する。(映りこみから描くので、やや下から描く)
            m.tx = (stage.stageWidth - w) / 2 + 10;
            m.ty = ((stage.stageHeight - h) / 2) + 62;
            
            var s:int = 0;
            //reflection
            var maxRef:int = 30;
            var cftRef:ColorTransform = new ColorTransform();
            cftRef.alphaMultiplier = 0;
            cftRef.redOffset = -30;
            cftRef.blueOffset = -30;
            cftRef.greenOffset = -30;
            for (i = 0; i < 30; i++) {
                canvas.draw(txtDataColumn, m, cftRef);// , null, null, true);
                cftRef.alphaMultiplier += .01;
                m.ty--;
            }
            //shadow
            canvas.draw(txtDataShadow, m);// , cft);// , null, null, true);
            m.ty -= 2;

            //shade
            s = 0;
            var max:int = 30;
            var colorOffsets:Array = [-20,0,0,-20];
            var ratios:Array = [0, .6, .8, 1];
            var ctfShade:ColorTransform = new ColorTransform();
            var color_d:Number = 0;
            for (i = 0; i < 30; i++) {
                if (i >= ratios[s] * max) {
                    var p_from:int = ratios[s] * max;
                    var colorOffset_from:Number = colorOffsets[s];
                    s++;
                    var p_to:int = ratios[s] * max;
                    var colorOffset_to:Number = colorOffsets[s];
                    color_d = (colorOffset_to - colorOffset_from) / ( p_to - p_from);
                    
                    ctfShade.redOffset = colorOffset_from;
                    ctfShade.blueOffset = colorOffset_from;
                    ctfShade.greenOffset = colorOffset_from;
                    
                    
                }
                canvas.draw(txtDataColumn, m, ctfShade);// , null, null, true);
                
                ctfShade.redOffset += color_d;
                ctfShade.blueOffset += color_d;
                ctfShade.greenOffset += color_d;
                m.ty--;
            }
            //
            
            //face
            var cf:ColorTransform = new ColorTransform(1, .6, .2);
            txtSource.colorTransform(txtSource.rect, cf);
            txtSource.applyFilter(txtSource, txtSource.rect, new Point(0, 0), new GlowFilter(0x202020, 1, 2, 2, 2, 1));
            canvas.draw(txtSource, m,null,null,null,true);
            bmp.bitmapData = canvas;
        }
        
        private function onResize(event:Event):void
        {
            var str:String = txt.text;
            setText(str, bmp);
        }
    }
}