/**
 * Copyright chomo ( http://wonderfl.net/user/chomo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lNke
 */

//
//flexでマンデルブロ集合ってどう書くのかなー、って思ってたらもう書いてる方がいたので動かしつつ読んでる
//http://hi.baidu.com/wsvny/blog/item/c2cc43947822ad007af4804a.html
//

package
{

    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;

    public class Mandelbrot extends Sprite
    {

        // display dimensions, set this as default size
        private static var DWTH:Number = 550;
        private static var DHTH:Number = 380;

        // maximum function cycles
        private static var CYCLES:Number = 128;

        // the set's bitmapdata
        private var bitmapData:BitmapData;

        public function Mandelbrot ( )
        {

            // creating new bitmap instance
            var setBitmap:Bitmap = new Bitmap( );

            // creating new bitmapdata
            bitmapData = new BitmapData( DWTH , DHTH , false , 0x000000 );

            // attaching bitmapdata to bitmap
            setBitmap.bitmapData = bitmapData;

            // attaching bitmap to display list
            addChild( setBitmap );

            // start drawing
            drawSet( -2 , 1 , -1 , 1 );

        }

        public function drawSet ( rmin:Number ,     // interval minimum on real axis
                                  rmax:Number ,     // interval maximum on real axis
                                  imin:Number ,     // interval minimum on imaginary axis
                                  imax:Number ):void
        {

            // real axis stepping
            var rStep:Number = ( rmax - rmin ) / DWTH;
            // imaginary axis stepping
            var iStep:Number = ( imax - imin ) / DHTH;

            // actual real coordinate
            var r:Number;
            // actual imaginary coordinate
            var i:Number;

            // looping thorugh every display point
            for ( var px:int = 0 ; px < DWTH ; px++ )
            {

                r = rmin + px * rStep;

                for ( var py:int = 0 ; py < DHTH ; py++ )
                {

                    i = imin + py * iStep;

                    var color:uint;
                    var cycles:int = getCycles( r , i );

                    // if cycles == CYCLES, the function tends to infinity
                    if ( cycles == CYCLES ) color = 0x000000;
                    // in not, we generate a greenish colour with bitwise left shit
                    else color = cycles << 16 | ( cycles + 50 ) << 8 | cycles;

                    // putting pixel
                    bitmapData.setPixel( px , py , color );

                }

            }

        }

        // calculating function cycle number

        public function getCycles ( r:Number , i:Number ):uint
        {

            var zr:Number = 0;
            var zi:Number = 0;

            var cr:Number = r;
            var ci:Number = i;

            // z's old values
            var ozr:Number = 0;
            var ozi:Number = 0;

            // z's old square values
            var zrsq:Number = 0;
            var zisq:Number = 0;

            for ( var a:int = 0 ; a < CYCLES ; a++ )
            {

                zi = ozr * ozi * 2 + ci;
                zr = zrsq - zisq + cr;

                zrsq = zr * zr;
                zisq = zi * zi;

                ozr = zr;
                ozi = zi;

                if ( ( zrsq + zisq ) > 4 ) break;

            }   
            return a;
        }
    }
}