/**
 * Copyright katapad ( http://wonderfl.net/user/katapad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lMjt
 */

package  
{
	import caurina.transitions.Tweener;
	import com.bit101.components.PushButton;
	import gs.*;
	import flash.events.MouseEvent;
	import mx.controls.Button;
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	
	[SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")]
	/**
	 * 
	 */
	public class TestTweenMax extends Sprite 
	{
		//----------------------------------
		//  static var/const
		//----------------------------------
		public static const POS:Array = [50, 100, -20, 200]
		
		//----------------------------------
		//  instance var 
		//----------------------------------
		private var _square:DisplayObject;
		private var _normalTweenBtn:PushButton;
		private var _fixTweenBtn:PushButton;
		private var _onstartBtn:PushButton;
		private var _startAtBtn:PushButton;
		private var _useFrameBtn:PushButton;
		private var _fromToBtn:PushButton;
		
		private var _immediateRender1Btn:PushButton;
		private var _immediateRender2Btn:PushButton;
		
		private var _tweenerBtn:PushButton;
		//
		/**
		 * コンストラクタ
		 */
		public function TestTweenMax() 
		{
			_init();
		}
		
		/**
		 * 初期化
		 */
		private function _init():void 
		{
			_square = addChild(new Square());
			_square.y = 250;
			_reset();
			
			var xx:Number = 5;
			var totalY:int = 290;
			_normalTweenBtn = new PushButton(this, xx, totalY, 'animTime = 0 is buggy', _normalTween);
			var margin:int = _normalTweenBtn.width + 5;
			
			_fixTweenBtn = new PushButton(this, xx + margin, totalY, 'animTime = 0.01...', _delayTween);
			
			_onstartBtn = new PushButton(this, xx + margin * 0, totalY += 25, 'use onStart', _onstart);
			_startAtBtn = new PushButton(this, xx + margin * 1, totalY, 'use startAt', _startAt);
			_useFrameBtn = new PushButton(this, xx + margin * 2, totalY, 'use frame', _useFrame);
			//_fromToBtn = new PushButton(this, xx + margin * 3, totalY, 'use fromto', _fromTo);
			
			
			_tweenerBtn = new PushButton(this, xx + 0, totalY += 25 , 'Tweener', _tweener);
			
			
			_immediateRender1Btn = new PushButton(this, xx + 0, totalY += 25 , 'immediateRender false', _immediateRender1);
			_immediateRender2Btn = new PushButton(this, xx +  margin * 1, totalY , 'immediateRender true', _immediateRender2);
		}
		
		
		private function _tweener(event:MouseEvent):void
		{
			_reset()
			Tweener.addTween(_square, { x: POS[1], time: 1.0, delay: 0, transition: "easeOutQuad"});
			Tweener.addTween(_square, { x: POS[2], time: 0.0, delay: 1.0, transition: "linear"});
			Tweener.addTween(_square, { x: POS[3], time: 1.0, delay: 1.0, transition: "easeOutQuad"});
		}
		
		private function _reset():void
		{
			TweenMax.killAll();
			Tweener.removeAllTweens();
			_square.x = POS[0];
		}
		private function _normalTween(event:MouseEvent):void
		{
			_reset();
			TweenMax.to(_square, 1.0, { x: POS[1], delay: 0 });
			TweenMax.to(_square, 0.0, { x: POS[2], delay: 1.01, onStart:trace, onStartParams:[1], overwrite: 2 });
			TweenMax.to(_square, 1.0, { x: POS[3], delay: 1.02, onStart:trace, onStartParams:[2], overwrite: 2 });
		}
		
		
		private function _delayTween(event:MouseEvent):void
		{
			_reset();
			TweenMax.to(_square, 1.0, { x: POS[1], delay: 0 });
			TweenMax.to(_square, 0.01, { x: POS[2], delay: 1.01, onStart:trace, onStartParams:[1] });
			TweenMax.to(_square, 1.0, { x: POS[3], delay: 1.02, onStart:trace, onStartParams:[2] } );
		}
		
		private function _onstart(event:MouseEvent):void
		{
			_reset();
			TweenMax.to(_square, 1.0, { x: POS[1], delay: 0 });
			TweenMax.to(_square, 1.0, { x: POS[3], delay: 1.01, onStart: _squareMove} );
		}
		
		private function _startAt(event:MouseEvent):void
		{
			_reset();
			TweenMax.to(_square, 1.0, { x: POS[1], delay: 0 });
			TweenMax.to(_square, 1.0, { startAt: {x: POS[2]}, x: POS[3], delay: 1.01, onStart: _squareMove} );
		}
		
		private function _useFrame(event:MouseEvent):void
		{
			_reset();	
			TweenMax.to(_square, 30, { x: POS[1], delay: 0, useFrames: true });
			TweenMax.to(_square, 0.00, { x: POS[2], delay: 31, useFrames: true, onStart:trace, onStartParams:[1] });
			TweenMax.to(_square, 30, { x: POS[3], delay: 31, useFrames: true, onStart:trace, onStartParams:[2] } );
		}
		
		private function _fromTo(event:MouseEvent):void
		{
			_reset();	
			TweenMax.to(_square, 1.0, { x: POS[1], delay: 0 });
			//TweenMax.fromTo(_square, 1.0, { x: POS[2], delay: 2}, { x: POS[3], delay: 1.01 } );
		}
		
		private function _squareMove():void
		{
			_square.x = POS[2];
		}
		
		private function _immediateRender1(event:MouseEvent):void
		{
			_reset();	
			TweenMax.to(_square, 1.0, { x: POS[1], delay: 0 });
			TweenMax.to(_square, 0.0, { x: POS[2], delay: 1.01, onStart:trace, onStartParams:[1], immediateRender: false });
			TweenMax.to(_square, 1.0, { x: POS[3], delay: 1.02, onStart:trace, onStartParams:[2], immediateRender: false });
		}
		
		private function _immediateRender2(event:MouseEvent):void
		{
			_reset();	
			TweenMax.to(_square, 1.0, { x: POS[1], delay: 0, immediateRender: true });
			TweenMax.to(_square, 0.0, { x: POS[2], delay: 1.01, onStart:trace, onStartParams:[1], immediateRender: true });
			TweenMax.to(_square, 1.0, { x: POS[3], delay: 1.02, onStart:trace, onStartParams:[2], immediateRender: true });
		}
		
	
	}
	
}
import flash.display.Shape;
class Square extends Shape
{
	function Square(w:Number = 50, h:Number = 50, color:uint = 0, alpha:Number = 1)
	{
		graphics.beginFill(color, alpha);
		graphics.drawRect( -w * 0.5, -h * 0.5, w, h);
		graphics.endFill();
	}
	
	
}
