/**
 * Copyright Kihara ( http://wonderfl.net/user/Kihara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lMXK
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.AntiAliasType;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.core.math.Plane3D;
    import org.papervision3d.core.utils.MeshUtil;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.typography.Text3D;
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.papervision3d.view.BasicView;

    public class mesh_test2 extends BasicView
    {
        private var plane:Plane;
        private var sp:Sprite;
        private var text:TextField;
        private var mesh0:TriangleMesh3D;
        private var mesh1:TriangleMesh3D;
        private var mouse_flag:Boolean;
        public function mesh_test2()
        {
            mouse_flag=false;
            sp=new Sprite();
            text_func();
            var bmp:BitmapData=new BitmapData(text.width, text.height);
            bmp.draw(sp);
            var bm:Bitmap = new Bitmap(bmp);
            bm.smoothing = true;
            var bmpData:BitmapData=bm.bitmapData;
            var material:BitmapMaterial=new BitmapMaterial(bmpData);
            material.doubleSided=true;
            plane=new Plane(material, 150, 100, 1, 2);

            var normal:Number3D=new Number3D(0, 0.5, 0);
            var point:Number3D=new Number3D(0, 0.5, 0);
            var cutPlane:Plane3D=Plane3D.fromNormalAndPoint(normal, point);

            var meshes:Array=MeshUtil.cutTriangleMesh(plane, cutPlane);

            mesh0=meshes[0];
            scene.addChild(mesh0);

            mesh1=meshes[1];
            scene.addChild(mesh1);
    
            startRendering();
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            addEventListener(MouseEvent.CLICK, click);
        }

        public function click(e:MouseEvent):void
        {
            mouse_flag=true;
        }
        public function text_func():void
        {
            var tf:TextFormat=new TextFormat();
            tf.font="Arial";
            tf.size=32;
            text=new TextField();
            text.antiAliasType=AntiAliasType.ADVANCED;
            text.autoSize=TextFieldAutoSize.LEFT;
            text.defaultTextFormat=tf;
            text.text="test";
            sp.addChild(text);
        }

        public function onEnterFrame(e:Event):void
        {
            if (mouse_flag)
            {
                mesh0.rotationX += (360-mesh0.rotationX)*0.1;
                mesh1.rotationX += (360-mesh1.rotationX)*0.1;
                mesh0.y+=(200 - mesh0.y) * 0.2;
                mesh1.y+=(-200 - mesh1.y) * 0.2;
            }
        }
    }
}