/**
 * Copyright leichtgewicht ( http://wonderfl.net/user/leichtgewicht )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lLzJ
 */

package {
    import flash.text.AntiAliasType;
    import flash.utils.setTimeout;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.text.Font;
    import flash.text.TextFormat;
    import flash.events.FocusEvent;
    import flash.events.TextEvent;
    import flash.events.Event;
    import flash.system.System;
    import flash.events.IMEEvent;
    import flash.system.IMEConversionMode;
    import flash.system.IME;
    import com.bit101.components.List;
    import flash.system.Capabilities;
    import flash.text.TextFieldType;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var imeSprite:Sprite;
        private var inputTxt:TextField;
        private var outputTxt:TextField;
        private var combo:com.bit101.components.List;
        private var _formerMode:String;
        
        
        public function FlashTest() {
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            // Wait one frame to see what "korean" has to be
            addEventListener(Event.ENTER_FRAME, init);
        }
        
        private function init(e:Event):void {
            removeEventListener(Event.ENTER_FRAME, init);
            
            combo = new (com.bit101.components.List)(null, 0, 0, [
                new Item("Alphanumeric (full)", IMEConversionMode.ALPHANUMERIC_FULL),
                new Item("Alphanumeric (half)", IMEConversionMode.ALPHANUMERIC_HALF),
                new Item("Chinese", IMEConversionMode.CHINESE),
                new Item("Japanese Hiragana", IMEConversionMode.JAPANESE_HIRAGANA),
                new Item("Japanese Katakana (full)", IMEConversionMode.JAPANESE_KATAKANA_FULL),
                new Item("Japanese Katakana (half)", IMEConversionMode.JAPANESE_KATAKANA_HALF),
                new Item("Korean",IMEConversionMode.KOREAN),
                new Item("Unknown", IMEConversionMode.UNKNOWN)
            ]);
            combo.width = 200;
            combo.autoHideScrollBar = true;
            combo.height = 160;
            combo.x = 2;
            combo.y = 2;
            addChild(combo);
            combo.draw();

            imeSprite = new Sprite();
            addChild(imeSprite);
            
            outputTxt = new TextField();
            outputTxt.defaultTextFormat = new TextFormat("Arial", 10);
            outputTxt.y = combo.y+combo.height+4;
            imeSprite.addChild(outputTxt);

            inputTxt = new TextField();
            inputTxt.multiline = true;
            
            inputTxt.type = TextFieldType.INPUT;
            inputTxt.width = 200;
            inputTxt.height = 18;
            inputTxt.y = 2;
            inputTxt.defaultTextFormat = new TextFormat("Arial", 10);
            inputTxt.x = combo.x+combo.width+2
            inputTxt.border = true;
            inputTxt.background = true;
            imeSprite.addChild(inputTxt);
            
            
            _formerMode = IME.conversionMode;
            
            trace( "Player: ", Capabilities.version," ", Capabilities.isDebugger ? "(debug)" : "(non-debug)"," ", Capabilities.hasIME ? "(hasIME)" : "(without IME)"," ", Capabilities.playerType );
            if( IME.isSupported ) {
                if( IME.enabled ) {
                    trace("IME is supported and enabled");
                } else {
                    trace("IME is supported but not enabled");
                }
                trace("Current conversionMode:", _formerMode );
            } else {
                trace("IME is not supported");
            }
            
            imeSprite.addEventListener("imeStartComposition", compositionOptions);
            stage.addEventListener("imeStartComposition", compositionOptions);
            System.ime.addEventListener("imeStartComposition", compositionOptions);
            System.ime.addEventListener(IMEEvent.IME_COMPOSITION, compositeFullWidthToHalfWidth);
            inputTxt.addEventListener(TextEvent.TEXT_INPUT, onTextInput);
            inputTxt.addEventListener(Event.CHANGE, onTextChange);
            addEventListener(Event.ENTER_FRAME, checkModeChange);
            combo.addEventListener(Event.SELECT, setSelectedCompositionMode);
            stage.addEventListener(Event.RESIZE, updateOutputSize);
            updateOutputSize(null);
        }
        
        private function onTextChange(e:Event):void {
            trace("Text changed: ", inputTxt.text);
        }

        
        private function onTextInput(e:TextEvent):void {
            trace("Textinput: ", e.text);
        }

        
        private function compositionOptions(e:IMEEvent):void {
            trace("Asking for composition options for: ");
        }

        
        private function checkModeChange(e:Event): void {
            if( _formerMode != IME.conversionMode ) {
                _formerMode = IME.conversionMode;
                trace("Conversion mode changed:", _formerMode);
            }
        }

        
        private function compositeFullWidthToHalfWidth(e:IMEEvent):void {
            trace("Accepting IME input: ", e.text);
        }

        
        private function setSelectedCompositionMode(e:Event): void {
            if( IME.isSupported ) {
                
                if( !IME.enabled ) {
                    try {
                        IME.enabled = true;
                        trace("Enabled IME");
                    } catch( e: Error ) {
                        trace("IME hasn't been enabled successfully");
                    }
                }
                
                try {
                    IME.conversionMode = combo.selectedItem.ime;
                    trace("New conversionMode:", IME.conversionMode);
                } catch(e:Error ) {
                    trace("Error occured while trying to set conversionMode:", combo.selectedItem.ime);
                    trace(e.toString());
                    trace("Current conversionMode:", IME.conversionMode);
                }
                _formerMode = IME.conversionMode;

            } else {
                trace( "IME not Supported" );
            }
        }
        
        private function updateOutputSize(e:Event):void {
            var lineHeight: int = outputTxt.textHeight/outputTxt.numLines;
            outputTxt.width = stage.stageWidth;
            var newHeight: int = stage.stageHeight-outputTxt.y;
            newHeight -= newHeight%lineHeight;
            outputTxt.height = newHeight;
            outputTxt.scrollV = outputTxt.maxScrollV;
        }
        
        private function trace(...args:Array):void {
            outputTxt.appendText(args.join("")+"\n");
            outputTxt.scrollV = outputTxt.maxScrollV;
        }
    }
}

class Item {
    private var _ime:String;
    private var _label:String;
    
    public function Item(label:String, ime:String) {
        _ime = ime;
        _label = label;
    }
    
    public function get label():String {
        return _label;
    }

    
    public function get ime():String {
        return _ime;        
    }

    public function toString():String {
        return "[Item label="+label+" ime="+ime+"]";
    }


}
