/**
 * Copyright Makoto_Tanaka ( http://wonderfl.net/user/Makoto_Tanaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lLt1
 */

package {
    import flash.display.Sprite;
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2DebugDraw;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
    		
    		private static const DRAW_SCALE:Number = 100;
    		
    		private var _world:b2World;
    		private var _bBox:b2Body;
    		
        public function FlashTest() {
            var worldRegion:b2AABB = new b2AABB();
            worldRegion.lowerBound.Set(-1, -1);
            worldRegion.upperBound.Set(6.5, 5);
            var gravity:b2Vec2 = new b2Vec2(0, 9.8);
            _world = new b2World(worldRegion, gravity, true);
            
            var bdFloor:b2BodyDef = new b2BodyDef();
            bdFloor.position.Set(5.5 / 2, 3);
            var pdFloor:b2PolygonDef = new b2PolygonDef();
            pdFloor.SetAsBox(2, 0.15);
            var bFloor:b2Body = _world.CreateBody(bdFloor);
            bFloor.CreateShape(pdFloor);
            
            var bdBox:b2BodyDef = new b2BodyDef();
            bdBox.position.Set(5.5 / 2, 1);
            var pdBox:b2PolygonDef = new b2PolygonDef();
            pdBox.SetAsBox(0.3, 0.2);
            pdBox.density = 1;
            
            _bBox = _world.CreateBody(bdBox);
            _bBox.CreateShape(pdBox);
            _bBox.SetMassFromShapes();
            
            var dd:b2DebugDraw = new b2DebugDraw();
            dd.m_sprite = this;
            dd.m_drawScale = DRAW_SCALE;
            dd.m_fillAlpha = 0.3;
            dd.SetFlags(b2DebugDraw.e_shapeBit);
            _world.SetDebugDraw(dd);
            
            addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
        }
        
        private function _enterFrameHandler(eventObj:Event):void {
        	_world.Step(1 / 24, 10);
        }	
    }
}