/**
 * Copyright milkmidi ( http://wonderfl.net/user/milkmidi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lLhz
 */

/*
milkmidi.com
add plane width and height paramater
*/
package {		
	import flash.display.*;	
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import gs.TweenMax
	import gs.easing.*;	
	import org.papervision3d.cameras.CameraType;
	import org.papervision3d.events.InteractiveScene3DEvent;	
	import org.papervision3d.materials.BitmapMaterial;
	import org.papervision3d.materials.utils.BitmapMaterialTools;
	import org.papervision3d.view.BasicView;
	[SWF(width = "950", height = "500", frameRate = "41", backgroundColor = "#cccccc")]
	public class PV3DFitScreen extends BasicView 	{	
		
		private var _obj:MilkDoublePlane;
		private static const WIDTH:int = 465;
		private static const HEIGHT:int = 465;		
		
		private var _disArr			:Array = [];			
		
		public function PV3DFitScreen(){
			super(0, 0, true, true, CameraType.TARGET);	
			viewport.buttonMode = true;
			loadingImg();
		}	
		private function loadingImg():void {
			var _ldr:Loader = new Loader();
			_ldr.load(new URLRequest("http://assets.wonderfl.net/images/related_images/e/e1/e18c/e18ca4ebe44ad3c5aa082cbd2742c8581cafcf86"),new LoaderContext(true ));
			_ldr.contentLoaderInfo.addEventListener(Event.COMPLETE , _completeHandler);
			_ldr = new Loader();
			_ldr.load(new URLRequest("http://assets.wonderfl.net/images/related_images/e/ee/eed8/eed824227b0f145757eb3dd9b03027d90829cca6"),new LoaderContext(true ));
			_ldr.contentLoaderInfo.addEventListener(Event.COMPLETE , _completeHandler);
		}
		private function _completeHandler(e:Event):void {
			_disArr.push(Bitmap(e.currentTarget.loader.content).bitmapData);			
			if (_disArr.length>=2) {
				
				init3DObjects();			
				startRendering();		
			}
		}
		
		private function init3DObjects():void {
			var _bitFrontMat:BitmapMaterial = new BitmapMaterial(_disArr[0], true);			
			_bitFrontMat.interactive = true;		
			_bitFrontMat.precise = true;
			
			var _bitBackMat:BitmapMaterial = new BitmapMaterial(_disArr[1], true);
			_bitBackMat.interactive = true;			
			_bitBackMat.precise = true;			
			
			_obj = new MilkDoublePlane( _bitFrontMat , _bitBackMat, WIDTH, HEIGHT);	
			//這時候就會有width和height的屬性可以使用。
			
			trace(_obj.width , _obj.height);
			
			_obj.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK , clickHandler);
			scene.addChild(_obj);				
		}
		
		private function clickHandler(e:InteractiveScene3DEvent):void {	
			//click button, tween obj width and height.
			//剛好圖片的大小是和場景寬、高一樣，
			//並使用screenZ公式，讓物件100%呈現。
			TweenMax.to( _obj , 1, 
			{
				z			:screenZ,
				rotationY	:180,
				width		:stage.stageWidth,
				height		:stage.stageHeight,
				ease		:Cubic.easeInOut,
				yoyo		:true,
				onComplete	:tweenComplete
			} );
		}
		private function tweenComplete():void {			
			trace(_obj.width, _obj.height);				
		}

		public function get screenZ():Number {
			return camera.focus * camera.zoom - Math.abs(camera.z);			
		}		
	}
}




	import org.papervision3d.Papervision3D;
	import org.papervision3d.core.geom.*;
	import org.papervision3d.core.geom.renderables.Triangle3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.core.math.NumberUV;
	import org.papervision3d.core.proto.*;
	import org.papervision3d.materials.utils.MaterialsList;	

	/**
	* The Cube class lets you create and display flat rectangle objects.
	* <p/>
	* The rectangle can be divided in smaller segments. This is usually done to reduce linear mapping artifacts.
	* <p/>
	* Dividing the Cube in the direction of the perspective or vanishing point, helps to reduce this problem. Perspective distortion dissapears when the Cube is facing straignt to the camera, i.e. it is perpendicular with the vanishing point of the scene.
	*/
	class DoublePlaneEx extends TriangleMesh3D
	{
		/**
		* Number of segments per axis. Defaults to 1.
		*/
		public var segments :Number3D;
	
		/**
		* No faces selected.
		*/
		static public var NONE   :int = 0x00;
	
		/**
		* Front face selection
		*/
		static public var FRONT  :int = 0x01;
	
		/**
		* Back face selection
		*/
		static public var BACK   :int = 0x02;
	
		/**
		* Right face selection
		*/
		static public var RIGHT  :int = 0x04;
	
		/**
		* Left face selection
		*/
		static public var LEFT   :int = 0x08;
	
		/**
		* Top face selection
		*/
		static public var TOP    :int = 0x10;
	
		/**
		* Bottom face selection
		*/
		static public var BOTTOM :int = 0x20;
	
		/**
		* All faces selected.
		*/
		static public var ALL    :int = FRONT + BACK + RIGHT + LEFT + TOP + BOTTOM;
	
		// ___________________________________________________________________________________________________
		//                                                                                               N E W
		// NN  NN EEEEEE WW    WW
		// NNN NN EE     WW WW WW
		// NNNNNN EEEE   WWWWWWWW
		// NN NNN EE     WWW  WWW
		// NN  NN EEEEEE WW    WW
	
		/**
		* Create a new Cube object.
		* <p/>
		* @param	materials	A MaterialObject3D object that contains the material properties of the object.
		* 
		* Supported materials are: front, back, right, left, top, bottom & all, for example: 
		* 
		*	var materials:MaterialsList = new MaterialsList(
		*	{
		*		all:	new MovieAssetMaterial( "Front", true ), // This is the default material
		*		front:  new MovieAssetMaterial( "Front", true ),
		*		back:   new MovieAssetMaterial( "Back", true ),
		*		right:  new MovieAssetMaterial( "Right", true ),
		*		left:   new MovieAssetMaterial( "Left", true ),
		*		top:    new MovieAssetMaterial( "Top", true ),
		*		bottom: new MovieAssetMaterial( "Bottom", true )
		*	} );
		* 
		* <p/>
		* @param	width			[optional] - Desired width.
		* <p/>
		* @param	depth			[optional] - Desired depth.
		* <p/>
		* @param	height			[optional] - Desired height.
		* <p/>
		* @param	segmentsS		[optional] - Number of segments sagitally (plane perpendicular to width). Defaults to 1.
		* <p/>
		* @param	segmentsT		[optional] - Number of segments transversally (plane perpendicular to depth). Defaults to segmentsS.
		* <p/>
		* @param	segmentsH		[optional] - Number of segments horizontally (plane perpendicular to height). Defaults to segmentsS.
		* <p/>
		* @param	insideFaces		[optional] - Faces that are visible from the inside. Defaults to Cube.NONE.
		*
		* You can add or sustract faces to your selection. For examples: Cube.FRONT+Cube.BACK or Cube.ALL-Cube.Top.
		* 
		* <p/>
		* @param	excludeFaces	[optional] - Faces that will not be created. Defaults to Cube.NONE.
		* 
		* You can add or sustract faces to your selection. For examples: Cube.FRONT+Cube.BACK or Cube.ALL-Cube.Top.
		* 
		* <p/>
		* @param	initObject		[optional] - An object that contains user defined properties with which to populate the newly created GeometryObject3D.
		* <p/>
		* It includes x, y, z, rotationX, rotationY, rotationZ, scaleX, scaleY scaleZ and a user defined extra object.
		* <p/>
		* If extra is not an object, it is ignored. All properties of the extra field are copied into the new instance. The properties specified with extra are publicly available.
		*/
		public function DoublePlaneEx( materials:MaterialsList, width:Number=500, depth:Number=500, height:Number=500, segmentsS:int=1, segmentsT:int=1, segmentsH:int=1, insideFaces:int=0, excludeFaces:int=0, initObject:Object=null )
		{
			super( materials.getMaterialByName( "all" ), new Array(), new Array(), null);
			
			this.materials = materials;
			
			this.insideFaces  = insideFaces;
			this.excludeFaces = excludeFaces;
	
			segments = new Number3D( segmentsS, segmentsT, segmentsH );
	
			buildCube( width, height, depth );
		}
	
		private function buildCube( width:Number, height:Number, depth:Number ):void
		{
			var width2  :Number = width  /2;
			var height2 :Number = height /2;
			var depth2  :Number = depth  /2;
			
			if( ! (excludeFaces & FRONT) )
				buildPlane( "front", "x", "y", width, height, depth2, ! Boolean( insideFaces & FRONT ) );
	
			  if( ! (excludeFaces & BACK) )
				buildPlane( "back", "x", "y", width, height, -depth2, Boolean( insideFaces & BACK ) );
	        
			/*if( ! (excludeFaces & RIGHT) )
				buildPlane( "right", "z", "y", depth, height, width2, Boolean( insideFaces & RIGHT ) );
	        */
			/* if( ! (excludeFaces & LEFT) )
				buildPlane( "left", "z", "y", depth, height, -width2, ! Boolean( insideFaces & LEFT ) );
	
			if( ! (excludeFaces & TOP) )
				buildPlane( "top", "x", "z", width, depth, height2, Boolean( insideFaces & TOP ) );
	
			if( ! (excludeFaces & BOTTOM) )
				buildPlane( "bottom", "x", "z", width, depth, -height2, ! Boolean( insideFaces & BOTTOM ) ); */
	
			mergeVertices();
	
			this.geometry.ready = true;
			
			if(Papervision3D.useRIGHTHANDED)
				this.geometry.flipFaces();
		}
	
		private function buildPlane( mat:String, u:String, v:String, width:Number, height:Number, depth:Number, reverse:Boolean=false ):void
		{
			var matInstance:MaterialObject3D;
			if( ! (matInstance= materials.getMaterialByName( mat )))
			{
				if(!(matInstance=materials.getMaterialByName( "all" ))){
					//Papervision3D.log( "Cube: Required material not found in given materials list. Supported materials are: front, back, right, left, top, bottom & all." );
					return;
				}
			}
	
			// Find w depth axis
			var w :String;
			if( (u=="x" && v=="y") || (u=="y" && v=="x") ) w = "z";
			else if( (u=="x" && v=="z") || (u=="z" && v=="x") ) w = "y";
			else if( (u=="z" && v=="y") || (u=="y" && v=="z") ) w = "x";
	
			// Mirror
			var rev :Number = reverse? -1 : 1;
	
			// Build plane
			var gridU    :Number = this.segments[ u ];
			var gridV    :Number = this.segments[ v ];
			var gridU1   :Number = gridU + 1;
			var gridV1   :Number = gridV + 1;
	
			var vertices   :Array = this.geometry.vertices;
			var faces      :Array = this.geometry.faces;
			var planeVerts :Array = new Array();
	
			var textureU :Number = width /2;
			var textureV :Number = height /2;
	
			var incU     :Number = width / gridU;
			var incV     :Number = height / gridV;
	
			// Vertices
			for( var iu:int = 0; iu < gridU1; iu++ )
			{
				for( var iv:int = 0; iv < gridV1; iv++ )
				{
					var vertex:Vertex3D = new Vertex3D();
					
					//var myUin:Number=20*(1-iu*iu/((gridU1-1)*(gridU1-1)));
					//var myVin:Number=20*(1-iv*iv/((gridV1-1)*(gridV1-1)));
					
					vertex[ u ] = (iu * incU - textureU) ;
					vertex[ v ] = iv * incV - textureV;
					if(mat=="front"){
					vertex[ w ] = .1;
					}else{
					vertex[ w ] = 0;
					}
					
					vertices.push( vertex );
					planeVerts.push( vertex );
				}
			}
	
			// Faces
			var uvA :NumberUV;
			var uvC :NumberUV;
			var uvB :NumberUV;
	
			for(  iu = 0; iu < gridU; iu++ )
			{
				for(  iv= 0; iv < gridV; iv++ )
				{
					// Triangle A
					var a:Vertex3D = planeVerts[ iu     * gridV1 + iv     ];
					var c:Vertex3D = planeVerts[ iu     * gridV1 + (iv+1) ];
					var b:Vertex3D = planeVerts[ (iu+1) * gridV1 + iv     ];
	
					uvA =  new NumberUV( iu     / gridU, iv     / gridV );
					uvC =  new NumberUV( iu     / gridU, (iv+1) / gridV );
					uvB =  new NumberUV( (iu+1) / gridU, iv     / gridV );
	
					faces.push(new Triangle3D(this, [ a, b, c ], matInstance, [ uvA, uvB, uvC ] ) );
	
					// Triangle B
					a = planeVerts[ (iu+1) * gridV1 + (iv+1) ];
					c = planeVerts[ (iu+1) * gridV1 + iv     ];
					b = planeVerts[ iu     * gridV1 + (iv+1) ];
	
					uvA =  new NumberUV( (iu+1) / gridU, (iv+1) / gridV );
					uvC =  new NumberUV( (iu+1) / gridU, iv     / gridV );
					uvB =  new NumberUV( iu     / gridU, (iv+1) / gridV );
	
					faces.push(new Triangle3D(this, [ c, a, b ], matInstance, [ uvC, uvA, uvB ] ) );
				}
			}
		}
		private var insideFaces  :int;
		private var excludeFaces :int;
		
	}
	import flash.display.BitmapData;
	import flash.geom.Matrix;
	import org.papervision3d.core.proto.MaterialObject3D;
	import org.papervision3d.materials.BitmapMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.primitives.Plane;
	
	class MilkDoublePlane extends DoublePlaneEx {				
		
		private var _width	:int;
		private var _height	:int;
		public function MilkDoublePlane(pFrontMat:MaterialObject3D, pBackMat:MaterialObject3D, pWidth:uint, pHeight:uint, pSegmentsW:uint = 0, pSegmentsH:uint = 0)  {			
			
			var _ml:MaterialsList = new MaterialsList(); 			
			
			var _backBitmap:BitmapData = pBackMat.bitmap.clone();			
			_backBitmap.lock();
			var _matrix:Matrix = new Matrix();
			_matrix.translate( -_backBitmap.width, 0);			
			_matrix.scale( -1,1);
			_backBitmap.draw( pBackMat.bitmap , _matrix);			
			_backBitmap.unlock();						
			
			pBackMat.bitmap = _backBitmap;
			pBackMat.opposite = true;
			_ml.addMaterial(pFrontMat, "front" ); 			
			_ml.addMaterial(pBackMat, "back" ); 				
			
			_width = pWidth;
			_height = pHeight;
			
			super(_ml, pWidth, 0, pHeight);			
			
			_ml = null;
			_matrix = null;
			_backBitmap = null;
			
		}		
		
		public function get width():int { 
			return super.scaleX * _width;			
		}		
		public function set width(pWidth:int):void {
			//_width = pWidth;
			super.scaleX = pWidth / _width;			
		}
		
		public function get height():int { 
			return super.scaleY * _height; 			
		}		
		public function set height(pHeight:int):void {
			//_height = pHeight;
			super.scaleY = pHeight / _height;			
		}

	}	