/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lLIg
 */

// forked from 883108's Color Composition
package {
    import flash.display.Sprite;
    import flash.text.*;
    import flash.events.*;

    public class RGBConverterDocument extends Sprite {
        // RGBそれぞれの値を調整するスライダーです。
        private var _rBar:RGBSlider;
        private var _gBar:RGBSlider;
        private var _bBar:RGBSlider;
        // RGB値を実際に表示するスプライトのサブクラスです。
        private var _composition:Composition;
        // 結果の補記部分です。
        private var _resultField:TextField;

        public function RGBConverterDocument() {
            init();
        }

        private function init():void {
            // 説明文をフィールドに追加します。
            var description:TextField = new TextField();
            addChild(description);
            description.x = 10;
            description.y = 10;
            description.width = 450;
            description.height = 40;
            description.multiline = true;
            description.text = 
                            'RGBカラーをスライダー位置に合わせてその場で合成するサンプルです。' + '\n' +
                            'スライダー位置が0-255までの値に換算され10進数/16進数/2進数で表示されます。';
            // 以下、R値、G値、B値それぞれのスライダーを初期化し、
            // どのスライダーがドラッグされても、changeColorハンドラが呼び出されるように設定します。            
            addChild(_rBar = new RGBSlider(stage, 'R :'));
            _rBar.x = 10;
            _rBar.y = 50;
            _rBar.addEventListener(RGBSlider.ON_DRAG, changeColor);
            //
            addChild(_gBar = new RGBSlider(stage, 'G :'));
            _gBar.x = 10;
            _gBar.y = 100;
            _gBar.addEventListener(RGBSlider.ON_DRAG, changeColor);
            //
            addChild(_bBar = new RGBSlider(stage, 'B :'));
            _bBar.x = 10;
            _bBar.y = 150;
            _bBar.addEventListener(RGBSlider.ON_DRAG, changeColor);
            // RGBスライダーの合成結果を色で表すスプライトのサブクラスをインスタンス化します。
            addChild(_composition = new Composition);
            _composition.x = 10;
            _composition.y = 200;
            // 結果の補記部分です。
            addChild(_resultField = new TextField);
            _resultField.x = _composition.x + _composition.width + 10;
            _resultField.y = _composition.y;
            _resultField.width = 300;
            _resultField.height = _composition.height;
            _resultField.multiline = true;
        }

        private function changeColor($event:Event):void {
            // RGBそれぞれのスライダーが現在示している値を取得します。
            var r:Number = _rBar.value;
            var g:Number = _gBar.value;
            var b:Number = _bBar.value;
            // R値、G値、B値をそれぞれ必要な分だけシフトしてRGBカラーを合成します。
            // 例 : R,G,Bともに1の場合
            // R : 00000001 << 16 は 000000010000000000000000
            // G : 00000001 <<  8 は 000000000000000100000000
            // B : 00000001       は 000000000000000000000001
            // R<<16|G<<8|B       は 000000010000000100000001
            _composition.color = r << 16 | g << 8 | b;

            _resultField.text = 'RGB : [ ' + 
            StringU.pad(r, 16, 2) + 
            StringU.pad(g, 16, 2) + 
            StringU.pad(b, 16, 2) + 
            '] ' ;
            
            _resultField.setTextFormat(new TextFormat('mono-space', 20, 0x000000, true));
        }
    }
}

import flash.display.*;
import flash.text.*;
import flash.events.MouseEvent;
import flash.events.Event;
import flash.geom.Rectangle;

class Composition extends Sprite {
    public function set color($color:int):void {
        // パラメータに受け取った値を元に、塗りのカラーを設定します。
        graphics.beginFill($color);
        graphics.lineStyle(0, 0x888888);
        graphics.drawRect(0, 0, 100, 100);
        graphics.endFill();
    }

    public function Composition() {
        init();
    }

    private function init():void {
        color = 0x000000;
    }
}


class RGBSlider extends Sprite {
    // カスタムイベント用のイベント定数です。
    public static const ON_DRAG:String = 'ON_DRAG';
    
    private var _stage:Stage;
    private var _label:String;
    private var _handle:Sprite;
    
    private var _valueField:TextField;
    private var _valueFieldFormat:TextFormat;
    private var _binValueField:TextField;
    private var _hexadecimalValueField:TextField;
    private var _sliderWidth:Number = 250;
    private var _handleWidth:Number = 8;

    private var _value:Number;
    public function get value():Number {
        return _value;
    }

    public function set value($value:Number):void {
        _value = $value;
        _valueField.text = _value.toString();
        _valueField.setTextFormat(_valueFieldFormat);
        _binValueField.text = StringU.pad(_value, 2, 8);
        _binValueField.setTextFormat(_valueFieldFormat);
        _hexadecimalValueField.text = StringU.pad(_value, 16, 2);
        _hexadecimalValueField.setTextFormat(_valueFieldFormat);
    }

    function RGBSlider($stage:Stage, $label:String) {
        _stage = $stage;
        _label = $label;
        init();
    }

    private function init():void {
        graphics.beginFill(0x999999);
        graphics.drawRoundRect(0, 8, _sliderWidth, 6, 3);
        graphics.beginFill(0xbbbbbb);
        graphics.drawRoundRect(1, 8 + 1, _sliderWidth -2, 4, 2);
        graphics.endFill();
        // 
        var label:TextField = new TextField  ;
        addChild(label);
        label.text = _label;
        label.width = 15;
        label.x = _sliderWidth + 10;
        label.y = 4;
        //
        _valueFieldFormat = new TextFormat();
        _valueFieldFormat.align = TextFormatAlign.RIGHT;
        //
        addChild(_valueField = new TextField);
        _valueField.width = 30;
        _valueField.height = 16;
        _valueField.x = label.x + label.width + 10;
        _valueField.y = label.y;
        _valueField.border = true;
        _valueField.borderColor = 0xcccccc;
        //
        addChild(_hexadecimalValueField = new TextField);
        _hexadecimalValueField.width = 30;
        _hexadecimalValueField.height = 16;
        _hexadecimalValueField.x = _valueField.x + _valueField.width + 10;
        _hexadecimalValueField.y = label.y;
        _hexadecimalValueField.border = true;
        _hexadecimalValueField.borderColor = 0xcccccc;
        //
        addChild(_binValueField = new TextField);
        _binValueField.width = 80;
        _binValueField.height = 16;
        _binValueField.x = _hexadecimalValueField.x + _hexadecimalValueField.width + 10;
        _binValueField.y = label.y;
        _binValueField.border = true;
        _binValueField.borderColor = 0xcccccc;
        // - - - - - - - - - - - - - - - - - - - - - - - - - 
        // setter valueを呼び出し、初期値0を入れて、
        // 各テキストフィールドの表示内容を初期化します。
        // - - - - - - - - - - - - - - - - - - - - - - - - - 
        value = 0;
        // - - - - - - - - - - - - - - - - - - - - - - - - - 
        // ハンドルを描画し、ドラッグ&ドロップ動作を設定します。
        // - - - - - - - - - - - - - - - - - - - - - - - - - 
        addChild(_handle = new Sprite);
        _handle.graphics.beginFill(0x666666);
        _handle.graphics.drawRoundRect(0, 5, _handleWidth*1.2, 12, 4);
        _handle.graphics.endFill();
        _handle.buttonMode = true;
        _handle.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
        _stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
    }

    private function mouseDownHandler($event:MouseEvent):void {
        _handle.startDrag(false, new Rectangle(0, 0, _sliderWidth - _handleWidth, 0));
        _stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
    }

    private function mouseMoveHandler($event:MouseEvent):void {
        // - - - - - - - - - - - - - - - - - - - - - - - - - 
        // ドラッグ中は、ステージ上をマウスが移動する度にこのイベントが呼び出されます。
        // 現在のハンドル位置をRGB値の値に換算してsetter valueに代入した後、
        // 合成イベントをディスパッチします。
        // - - - - - - - - - - - - - - - - - - - - - - - - - 
        value = _handle.x / (_sliderWidth - _handleWidth) * 255 | 0;
        dispatchEvent(new Event(ON_DRAG));
        $event.updateAfterEvent();

    }

    private function mouseUpHandler($event:MouseEvent):void {
        _handle.stopDrag();
        _handle.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
    }
}

class StringU {
    public static function pad($value:int, $base:uint, $length:uint):String{
        var st:String = $value.toString($base);
        var len:uint = $length - st.length;
        /* 
        for( var i:uint = 0; i<len; st = '0' + st, i++);
            return st;
        }
        */
    return st;
    }
}