/**
 * Copyright ruiko ( http://wonderfl.net/user/ruiko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lKh9
 */

// forked from ruiko's flash on 2010-7-31
package {
    import flash.trace.Trace;
    import flash.ui.Mouse;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.ui.Keyboard;
    [SWF(width="640", height="400", backgroundColor="0xffffff", frameRate="24")]

    public class Drag extends Sprite {
        
        private var inputText:TextField;  
        private var screen:Sprite = new Sprite();
        private var s:Sprite = new Sprite();
        private var flag:int = 1;
        private var right:Sprite = new Sprite();
        private var left:Sprite = new Sprite();
        
        public function Drag():void {
            screen= new Sprite();
            screen.graphics.beginFill(0x00ff00,1);
            screen.graphics.drawRect(0,0,stage.stageWidth*3,stage.stageHeight);
            screen.graphics.endFill();
            screen.x = -stage.stageWidth;
            
            addChild(screen);
            
            var cover:Sprite = new Sprite();
            cover.graphics.beginFill(0xff0000);
            cover.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            //cover.graphics.drawRect(0,0,300,screen.height); 
            cover.graphics.endFill();
            
            screen.addChild(cover);
            
            //テキストボックス
            inputText = new TextField();
            inputText.border = true;
            inputText.type = "input";
            screen.addChild(inputText);
            
            if(flag==0 || flag==1){
                right.graphics.beginFill(0x000000);
                right.graphics.drawCircle(stage.stageWidth-25,stage.stageHeight-40,20);
                right.graphics.endFill();
                addChild(right);
            }
            if(flag==1 || flag==2){
                left.graphics.beginFill(0x000000);
                left.graphics.drawCircle(25,stage.stageHeight-40,20);
                left.graphics.endFill();
                addChild(left); 
            }
            inputText.text=flag.toString();
            
            // クリックイベントを監視する
            stage.addEventListener("click", stageClick);
            right.addEventListener("click", moveRight);
            left.addEventListener("click", moveLeft);
        }
        
        //右に移動（オブジェクトを左にずらす）
        private function moveLeft(event:MouseEvent):void {
            if(flag>0){
                screen.x+=stage.stageWidth;
                flag-=1;
            }
            inputText.text=flag.toString();
            if(flag==0 || flag==1){
                addChild(right);
            }else{
                removeChild(right);
            }

            if(flag==1 || flag==2){
                addChild(left);
            }else{
                removeChild(left);
            }

        }
        
        //左に移動（オブジェクトを右にずらす）
        private function moveRight(event:MouseEvent):void {
            if(flag<2){
                screen.x -= stage.stageWidth; 
                flag+=1;
            }
            inputText.text=flag.toString();
           if(flag==0 || flag==1){
                addChild(right);
            }else{
                removeChild(right);
            }

            if(flag==1 || flag==2){
                addChild(left);
            }else{
                removeChild(left);
            }

        }

        
        //イベントハンドラ
        private function stageClick(event:MouseEvent):void {
            if(event.target != stage) {
                return;
            }
            // 四角を作成
            var s:Sprite = new Sprite();
            s.graphics.beginFill(Math.random() * 0x1000000);
            s.graphics.drawRect(0, 0, 120,50);
            s.graphics.endFill();
            screen.addChild(s);
           
            // 四角をクリックされた位置に移動
            s.x = event.stageX + stage.stageWidth * flag;
            s.y = event.stageY;
            
            s.doubleClickEnabled=true;
            // テキストを取得して作成
            var tf:TextField = new TextField();
            tf.text = inputText.text;
            //addChild(tf);
            inputText.text=flag.toString();

            // テキストをクリックされた位置に移動
            tf.x = s.x + 10;
            tf.y = s.y + 10;
            

            //マウスボタンダウン
            s.addEventListener(MouseEvent.MOUSE_DOWN, rectClickDown);
            //マウスボタンアップ
            s.addEventListener(MouseEvent.MOUSE_UP, rectClickUp);
            //ダブルクリック
            s.addEventListener(MouseEvent.DOUBLE_CLICK, rectDoubleClick);
        }
        
        //ドラッグ開始
        private function rectClickDown(event:MouseEvent):void{
            event.target.startDrag( );
        }
        //ドラッグ終了
        private function rectClickUp(event:MouseEvent):void{
            event.target.stopDrag( );
        }
        //ダブルクリック
        private function rectDoubleClick(event:MouseEvent):void{
            //消す
            screen.removeChild(DisplayObject(event.target));
        }

   }
}