/**
 * Copyright tomrx ( http://wonderfl.net/user/tomrx )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lKVI
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.PixelSnapping;
    import flash.events.*;
     /**
     * [←][→]移動
     * [z]+[←][→]ダッシュ移動
     * [x]ジャンプ
     * 敵に当ってもミスにならないので無敵です
     */
    [SWF(width = "465", height = "465", backgroundColor = "0x5080ff", frameRate = "60")]
 
    public class FlashTest extends Sprite {
        private var bmp_data:BitmapData;
        private var bmp_obj:Bitmap;
        private var _scene:Scene;
        public function FlashTest() {
            // write as3 code here..
            var I:int = 0 ;
            for ( I = 0; I < 256; ++I ) { Global._key[I] = false; }
            stage.addEventListener( KeyboardEvent.KEY_DOWN, function ( E:KeyboardEvent ):void { Global._key[ E.keyCode ] = true;  } );
            stage.addEventListener( KeyboardEvent.KEY_UP  , function ( E:KeyboardEvent ):void { Global._key[ E.keyCode ] = false; } );
            

            _scene=new Scene();
            addChild(_scene);
            Global._canvas.setPixel(0,0,0xff0000);
        }
    }
}
import flash.system.LoaderContext;
import flash.net.URLRequest;
import flash.display.Loader;
import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.display.PixelSnapping;
import flash.events.*;
import flash.geom.Rectangle;
import flash.geom.Point;
class MapData
    {
        public var wall:Array = [
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1],            
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1],            
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1],            
            [0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1],            
            [0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],            
            [0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],            
            [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],        
            
        ]

        public function WallhitTest(x:int, y:int):int{
            return wall[y][x];
        }
        
}
class Global {
    public static var _key:Array = new Array ( 256 ) ;
    public static var _canvas:BitmapData = new BitmapData ( 465 , 465 , false , 0x5080ff ) ;

}
class Scene extends Sprite
{
            private var bmp_data:BitmapData;
            private var bmp_obj:Bitmap;
            private var my_loader:Loader
            private var tile:Vector.<BitmapData>;
            private var _mario:Mario = new Mario();
            private var _enemy:Enemy = new Enemy();
            private var _map:MapData = new MapData();
            private var _score:Score = new Score();
            public function Scene(){
                my_loader=new Loader;
                my_loader.contentLoaderInfo.addEventListener(Event.COMPLETE,compLoad);
                my_loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/d/d1/d138/d13864aa14296b55009bee4cc25ac7fb541beeb5"),new LoaderContext(true));
                bmp_obj = new Bitmap(Global._canvas,PixelSnapping.AUTO,true);
                addChild(bmp_obj);
                Global._canvas.setPixel(10,10,0xff00ff);
            }
            public function compLoad(e:Event):void{
                var i:uint;
                var j:uint;
                var bmp:Bitmap=e.target.content as Bitmap;
                var dest:BitmapData = new BitmapData(384, 128,true,0x0);
                dest.threshold(bmp.bitmapData,new Rectangle(0,0,384,128),new Point(0,0),"==",0xc2c2c2,0x0,0xffffff,true);
                tile=new Vector.<BitmapData>();
                for (i = 0; i < 60; i++) {
                    tile[i] = new BitmapData(32, 32);
                }
                for (j = 0; j < 4; j++){
                    for (i = 0; i < 12;i++){
                        tile[j*12+i].copyPixels(dest, new Rectangle(i*32, j*32, i*32+32, j*32+32), new Point(0, 0));
                    }
                }
                addEventListener(Event.ENTER_FRAME, render);
            }
            public function render(e:Event):void{
                var rect:Rectangle = new Rectangle(0, 0, 32, 32);
                
                _mario.marioMove();      //主人公移動
                _mario.hitTest(_map);    //主人公当たり判定（壁）
                _enemy.enemymove(_map);  //敵移動
                _score.scoreMove();      //スコア移動
                var check:int = _enemy.enemyhittest(_mario);    //主人公と敵の当たり判定
                    if(check == 1) {                                 //敵を踏んだとき
                        _mario.vy = -4.0; 
                        if(_mario.chain<11){_mario.chain++;} 
                        _score.makeScore(_enemy.enemyx, _enemy.enemyy-16, 30, _mario.chain); 
                    }
                    if (check == 2) {                                //とまっている敵を踏んだとき
                        if (_mario.chain <9) {
                            _score.makeScore(_enemy.enemyx, _enemy.enemyy-16, 30, _mario.chain + 3); 
                        }else {
                            _score.makeScore(_enemy.enemyx, _enemy.enemyy-16, 30, 11); 
                        }
                    }
                Global._canvas.lock();
                Global._canvas.fillRect(new Rectangle(0, 0, 640, 480), 0x5080ff);
                for (var iy:int=0; iy < 12;iy++){
                    for (var ix:int=0; ix < 17; ix++) {
                        if (_map.WallhitTest(ix,iy) == 1) {  
                            Global._canvas.copyPixels(tile[1], rect, new Point(ix * 32-32, iy * 32));
                        }
                    }
                }
                //敵表示
                Global._canvas.copyPixels(tile[_enemy.anime + _enemy.direction * 3 ], rect, new Point((_enemy.enemyx) * 2 - 32, (_enemy.enemyy) * 2 + 16));
                //主人公表示
                Global._canvas.copyPixels(tile[_mario.anime], rect, new Point((_mario.x)*2-32, (_mario.y)*2));
                Global._canvas.copyPixels(tile[_mario.anime+12], rect, new Point((_mario.x)*2-32, (_mario.y)*2+32));
                //スコア表示
                if (_score.visibletime > 0) {
                    Global._canvas.copyPixels(tile[_score.score+36], rect, new Point((_score.x)*2-32, (_score.y)*2+32));
                }
                
                Global._canvas.unlock();
            }

}     
class Mario
{
    private var xzkey:int;
    private var beforexzkey:int;
    private var leftrightkey:int;
    private var mariostatus:int = 0;
    private const NORMAL:int = 0;
    private const JUMP:int = 1;
    private const FALL:int = 2;
    public var vx:Number = 0.0;
    public var vy:Number = 0.0;
    public var x:Number = 32.0;
    public var y:Number = 140.0;
    public var anime:int = 0;
    public var chain:int = 0;
    private var jumpy:Number;
    private var mariospeed:Number = 0.0;
    private var dashspeed:Number;
    private var maxvx:Number;
    private var vvx:Number;
    private var vvy:Number = 0.0;
    private var directionspeed:Number;
    private var direction:Number;
    private var gravity1:Number = 0.0;
    private var gravity2:Number = 0.0;
    private var animespeed:int = 0;
    private var animecount:int = 0;
    private var animecount2:int = 0;
    
    public function Mario() :void
    {
        x = 32.0;
        y = 140.0;
        vy = 1.0;    
    }
    public function marioMove():void {
        xzkey = Global._key[88] * 2 + Global._key[90];
        leftrightkey = Global._key[37] * 2 + Global._key[39];
        mainMove();
        animation();
        if (vx > 0) { directionspeed = 1; }
        if (vx < 0) { directionspeed = 2; }
        beforexzkey = xzkey;
    }
    private function mainMove():void {
        speed();
        switch(mariostatus) {
            case NORMAL:
                move();
            break;
            case JUMP:
                jump();
            break;
            case FALL:
                fall();
            break;
        }
        if (x < 16) { x = 16.0; vx = 0.0; }
        if (x > 232) { x = 232.0; vx = 0.0; } 
        
    }
    private function animation():void {
            
        switch(mariostatus) {
            case NORMAL:
                if(vx!=0 || leftrightkey!=0){
                    if (mariospeed > 0.56 && (directionspeed & direction) == 0 ) {
                        if (direction == 2) { anime = 22;}else{ anime = 16;}
                        animecount2 = 0;
                    }else{
                        if (animecount == 0) { 
                            animecount = animespeed;   
                            animecount2++; if (animecount2 > 2) { animecount2 = 0; }
                            if (direction == 2) { anime=19+animecount2;}else{ anime = 13 + animecount2} 
                        }
                    }
                }else { 
                    if (direction == 2) { anime = 18; } else { anime = 12; }
                }                
            break;
            case JUMP:
                if (direction == 2) { anime=23;}else{anime = 17;}
                animecount2 = 0; 
                
            break;
            case FALL:
                if (direction == 2) { anime=19+animecount2;}else{ anime = 13 + animecount2} 
            break;
                
        }

        if (animecount > 0) { animecount--;}
    }
    private function move():void {
        
        speedcheck();
        if (leftrightkey != 0) { direction = leftrightkey; }//向き
        speedupdown();
        x = x + vx;                //移動
    }
    private function jump():void {
        
        if (vy > 0) { vvy = gravity2; }
        if ((xzkey & 2 & beforexzkey) == 0) {
            if (jumpy != y) {
                vvy = gravity2;
            }
        }
        if (leftrightkey !=0) {    
            speedupdown();
        }
        x = x + vx;
        y = y + vy;
        vy = vy + vvy;
        if (vy > 4.0) { vy = 4.0;}
    }
    private function fall():void {

        vvy = gravity2;
        if (leftrightkey != 0) {
            speedupdown();
        }
        x = x + vx;
        y = y + vy;
        vy = vy + vvy;
        if (vy > 4.0) { vy = 4.0;}
    }
    private function speedcheck():void {
        animespeed = 2;
        if (mariospeed > 1.75) { 
            dashspeed = mariospeed; 
        } else {
            animespeed = 4;
            if (mariospeed < 0.87) { animespeed = 7;}
            if (leftrightkey == directionspeed) {
                dashspeed = 0;
            }else {
                if (mariospeed < 0.68) {
                    directionspeed = direction;
                    vx = 0;                        
                }
            }
        }
            
    }
    private function speedupdown():void {
        
        if (leftrightkey == 0) {//左右のキーを押していないとき
            if (vx > 0) {
                vx = vx - vvx;                //減速
                mariospeed = Math.abs(vx);
            }
            if (vx < 0) {
                vx = vx + vvx;                //減速
                mariospeed = Math.abs(vx);
            }
        }else {
            if (leftrightkey & 1) {//右キーを押しているとき
                vx = vx + vvx;                //加速
                if (maxvx < vx) { vx = maxvx; }
                mariospeed = Math.abs(vx);
            }
            if (leftrightkey & 2) {//左キーを押しているとき
                vx = vx - vvx;                //加速
                if ( -maxvx > vx) { vx = -maxvx; }
                mariospeed = Math.abs(vx);
            }
        }
    }
    private function speed():void {
        
        if ((xzkey & 2) == 2 && (beforexzkey & 2) == 0 && mariostatus==0) {
            mariostatus = JUMP;
            //ジャンプ開始
            jumpy = y;
            //スピードでジャンプ力と重力加速を決める gravity1はジャンプキーを押している間の重力加速 gravity2は押していないとき
            if (mariospeed < 0.56) {                        vy = -4.0; gravity1 = 0.12; gravity2 = 0.43; }
            if (mariospeed >= 0.56 && mariospeed < 1.0) {  vy = -4.0; gravity1 = 0.12; gravity2 = 0.43; }
            if (mariospeed >= 1.0 && mariospeed < 1.56) {  vy = -4.0; gravity1 = 0.11;  gravity2 = 0.37; }
            if (mariospeed >= 1.56 && mariospeed < 1.75) { vy = -5.0; gravity1 = 0.15;  gravity2 = 0.56; }
            if (mariospeed >= 1.75) {                        vy = -5.0; gravity1 = 0.15;  gravity2 = 0.56; }                
            vvy = gravity1;
        }
        if (mariostatus == NORMAL)                 //地面に立っているとき
        {
            maxvx = 2.5;                         //ダッシュ時の最高速度
            vvx = 0.056;                         //加速
            if (leftrightkey == directionspeed) {//押しているキーの向きと進んでいる方向が同じ    
                if ((xzkey & 1) == 0) {          //zキー(ダッシュキー)を押していないとき
                    normalspeed();                 //普通の速度
                }
            }
        }else {                                       //ジャンプしているか落下しているとき
            if (mariospeed <= 1.5) {             //速度が1.5より低いとき
                normalspeed();                     //普通の速度
            }else {
                maxvx = 2.5;                     //ダッシュ時の最高速度
                vvx = 0.056;                     //加速
            }
        }
        if (direction != directionspeed) {         //キャラクターの向きと進んでいる方向が逆の場合
            vvx = vvx * 2.0;                     //加速を２倍
        }
    }
    private function normalspeed():void {
        maxvx = 1.5;                            //最高速度
        vvx = 0.037;                            //加速
        if (dashspeed != 0 ) { 
            vvx = 0.05;    
        } else {
            if (mariospeed >= 2.0) {        
                vvx = 0.05;    
            }
        }
            
    }
    public function hitTest(_mapdata:MapData):void {
        
        if (y < 0) { return;}
        if (mariostatus == NORMAL) { mariostatus = FALL; }
    
        if (vy<0 && _mapdata.WallhitTest(Math.floor((x+8) / 16), Math.floor((y+4) / 16)) == 1) {
            vy = 1.0;
        }        
        //地面に当っているか
        if (y%16<4 && vy>=0.0 && (_mapdata.WallhitTest(Math.floor((x + 3) / 16), Math.floor((y + 32) / 16)) == 1 || _mapdata.WallhitTest(Math.floor((x + 12) / 16), Math.floor((y + 32) / 16)) == 1)) {
                y = Math.floor(y / 16)*16;
                vy = 0.0;
                vvy = 0.0;
                mariostatus = 0;
                chain = 0;
        }
        //左側が壁に当たっているか    
        if (vx<0 && _mapdata.WallhitTest(Math.floor((x + 2) / 16), Math.floor((y + 8) / 16)) == 1 || _mapdata.WallhitTest(Math.floor((x + 2) / 16), Math.floor((y + 24) / 16)) == 1) {
            x++;
            vx = 0.0;
        }
        //右側が壁に当っているか
        if (vx>0 && _mapdata.WallhitTest(Math.floor((x + 13) / 16), Math.floor((y + 8) / 16)) == 1 || _mapdata.WallhitTest(Math.floor((x + 13) / 16), Math.floor((y + 24) / 16)) == 1) {
            x--;
            vx = 0.0;
        }
            
    }
}   
class Enemy {
    public var enemyx:Number;
    public var enemyy:Number;
    public var anime:uint;
    public var direction:int = 0;
    private var enemyvx:Number;
    private var enemyvy:Number;
    private var enemyanime:uint;
    private var hitflag:Boolean = false
    private var kickflag:Boolean = false;    //蹴られているかどうか
    private var kickfall:Boolean = false;    //蹴られている状態で落下しているかどうか
    private var stomp:Boolean = false;        //踏まれたかどうか
    private var cc:int = 0;
    private var fall:Boolean = false;;

    public function Enemy() 
    {
        enemyx = 260;
        enemyy = 0;
        enemyvx =  -0.5;
        enemyvy = 0;
        enemyanime = 0;
        fall = false;
    }
    public function enemymove(_mapdata:MapData):void {
            
        if (kickfall==true || (kickflag==false && fall==true)) {
            enemyy = enemyy + enemyvy;
            enemyvy = enemyvy  + 0.23;            
            if (enemyvy > 4.0) { enemyvy = 4.0;}
        }
        if (fall == true && kickfall == true) { enemyx += enemyvx / 2 } else { enemyx += enemyvx;}
            
        if (enemyx < 0 || enemyx>260) { //画面外に出た
            stomp = false; 
            fall = false; 
            kickfall = false; 
            kickflag = false; 
            enemyx = 260; 
            enemyy = 8; 
            enemyvx = -0.5; 
            direction = 0;
        }
        enemyanime = (enemyanime + 1) & 0xff;
        anime = 2 + ((enemyanime & 8) >> 3);
        if (stomp == true) { anime = 4;}
        //地面に当っているか
        if (_mapdata.WallhitTest(Math.floor((enemyx + 8) / 16), Math.floor((enemyy + 24) / 16)) == 0) {
            fall = true;        //当っていない場合は落下
            if(kickflag==true){kickfall = true;}
        }else {                    //当った場合
            fall = false;
            kickfall = false;
            enemyy = Math.floor((enemyy+24)/16)*16-24
            enemyvy = 0.0;
            if (stomp == true && kickflag==false) { enemyvx = 0;}
        }
        //敵の左側か右側が壁にあたっているか
        if ((enemyvx<=0 && _mapdata.WallhitTest(Math.floor((enemyx) / 16), Math.floor((enemyy+ 20) / 16)) == 1) || (enemyvx>0 && _mapdata.WallhitTest(Math.floor((enemyx+16) / 16), Math.floor((enemyy + 20) / 16)) == 1))
        {
            enemyvx = -enemyvx;
            if(stomp==false){direction = (direction + 1) % 2;}    //向きを変える
        }
                
    
    }
    public function enemyhittest(_mario:Mario):int {
        //当たり判定
        var xhit:Boolean=false;
        var yhit:Boolean = false;
            

        cc = (cc + 1) % 2;if (cc == 0) { return 0;}
        if (_mario.x + 2 <= enemyx + 15 && enemyx + 2 <= _mario.x + 15) { xhit = true;} 
        if (_mario.y + 8 <= enemyy + 21 && enemyy + 9 <= _mario.y + 32) { yhit = true;}
        if (xhit==true && yhit==true) { 
                
            if (hitflag == false) { 
                hitflag = true;
                if (kickflag == true) {
                    if (_mario.vy > 0) {
                        stomp = true;        //蹴られた状態で踏まれた
                        enemyvx = 0;
                        kickflag = false;
                        return 1;
                    }else {  }
                }else{
                    if (stomp == false) {
                        if (_mario.vy > 0) {
                            stomp = true;    //踏まれた
                            kickflag = false;
                            return 1;
                        }else { }
                    }else {
                        kickflag = true;    //蹴られた
                        if (_mario.x > enemyx) { enemyvx = -3.0; } else { enemyvx = 3.0; }
                        return 2;
                    }
                }    
            }
        }else { hitflag = false;}
            
            
        return 0;
    }
}
class Score
{
    public var visibletime:int;        //表示時間
    public var score:int;            //スコア
    public var x:int;                //x座標
    public var y:int;                //y座標
    public function Score() 
    {
        
    }
    public function makeScore(_x:int,_y:int,_time:int,_num:int):void {
        x = _x;
        y = _y;
        visibletime = _time;
        score = _num;
        
    }
    public function scoreMove():void
    {
        if (visibletime > 0) {
            y--;
            visibletime--;
        }
    }
}