/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lK4s
 */

package 
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
    
    /**
     * ...
     * @author rettuce
     * 
     */
    public class Main extends Sprite
    {
        private var _ballArr:Array=[];
        private var _flgArr:Array=[];
        private var NUM:int = 20;
        private var LENGTH:int = 250;
        private var _spring:Number = 0.1;    // バネ係数
        private var _friction:Number = 0.5;    // 摩擦係数
        private var _gravity:Number = 5;    // 重力
        
        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init );
        }
        
        private function init(e:Event = null ):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init );
            setStage();

            loaderInfo.addEventListener(Event.UNLOAD, function(e:Event):void {
                removeEventListener(Event.ENTER_FRAME, enterframeHandler);
                stage.removeEventListener(Event.RESIZE, resizeEvent);
                loaderInfo.removeEventListener(Event.UNLOAD, arguments.callee );
            });
            
            for(var i:int =0; i<NUM; i++ ){
                var b:Ball = new Ball(10, 0x000000);                
                b.x = stage.stageWidth*Math.random();            
                b.y = stage.stageHeight*Math.random();            
                b.addEventListener(MouseEvent.MOUSE_DOWN, mousedownHandler);
                addChild(b);
                b.name = String(i);
                _ballArr[i]=b;
                _flgArr[i]=false;
            }
            addEventListener(Event.ENTER_FRAME, enterframeHandler);
            addEventListener(MouseEvent.MOUSE_UP, mouseupHandler);
        }
        
        private function enterframeHandler(e:Event):void
        {
            for(var i:int=0; i<NUM; i++){
                if(!_flgArr[i]){
                    for(var n:int=0; n<NUM; n++){
                        if(i!=n) springTo(_ballArr[i], _ballArr[n]);
                    }
                }                
            }
            _ballArr[0].x = 0;
            _ballArr[0].y = stage.stageHeight/2;
            _ballArr[NUM-1].x = stage.stageWidth;
            _ballArr[NUM-1].y = stage.stageHeight/2;
            
            graphics.clear();
            graphics.lineStyle(1, 0xFFFFFF);
            graphics.moveTo(_ballArr[0].x, _ballArr[0].y);
            
            for(i=0; i<NUM; i++){
                for(n=0; n<NUM; n++){
                    graphics.moveTo(_ballArr[i].x, _ballArr[i].y);
                    graphics.lineTo(_ballArr[n].x, _ballArr[n].y);
                }
            }
            graphics.lineTo(_ballArr[0].x, _ballArr[0].y);            
        }
        private function springTo(t0:Ball, t1:Ball):void
        {    
            var dx:Number = t1.x - t0.x;
            var dy:Number = t1.y - t0.y;
            var angle:Number = Math.atan2(dy,dx);
            var tx:Number = t1.x-Math.cos(angle)*LENGTH;
            var ty:Number = t1.y-Math.sin(angle)*LENGTH;
            t0._vx += (tx - t0.x)*_spring;
            t0._vy += (ty - t0.y)*_spring;
            t0._vx *= _friction;
            t0._vy *= _friction;    
            t0.x += t0._vx;
            t0.y += t0._vy;                
        }
        private function mousedownHandler(e:MouseEvent):void
        {
            e.target.startDrag();
            _flgArr[e.target.name] = true;
        }
        private function mouseupHandler(e:MouseEvent):void
        {
            stopDrag();
            for(var i:int=0; i<NUM; i++){
                _flgArr[i] = false;
            }
        }        
        
        /********* stage set ************/
        
        private function setStage():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, resizeEvent);
            resizeHandler();
        }
        private function resizeEvent(e:Event = null):void {
            resizeHandler();
        }        
        public function resizeHandler():void {            
        }        
    }
}

import flash.display.Sprite;
class Ball extends Sprite
{
    private var _radius:Number;
    private var _color:Number;
    public var _vx:Number = 0;
    public var _vy:Number = 0;
    
    public function Ball(radius:Number = 40, color:Number = 0xFF0000)
    {
        _radius = radius;
        _color = color;
        init();
    }
    
    public function init():void
    {
        graphics.beginFill(_color);
        graphics.lineStyle(1, 0xFFFFFF)
        graphics.drawCircle(0,0,_radius);
        graphics.endFill();
    }
}