/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lJ9z
 */

package {
    import caurina.transitions.Tweener;
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#000000")]
    
    public class FlashTest extends Sprite {
        private var viewer:Viewer;
        private var buttons:Buttons;
        private var sliders:Sliders;
        
        public function FlashTest() {
            setup();
            addEventListener(Event.ENTER_FRAME, update);            
        }
        
        private function setup():void {
            var w:int = stage.stageWidth;
            var h:int = stage.stageHeight;
            
            Attractor.setup();
            Attractor.paramRandom();
            
            viewer = new Viewer();
            viewer.setup(w, h);
            addChild(viewer);
            
            buttons = new Buttons();
            buttons.setup();
            buttons.action = drawByButton;
            buttons.y = h - 20;
            addChild(buttons);
            
            sliders = new Sliders();
            sliders.setup();
            sliders.action = drawBySlider;
            sliders.reset();
            addChild(sliders);
        }
        
        private function update(e:Event):void {
            viewer.update(Attractor.update());
        }
        
        private function drawByButton(values:Vector.<Number>):void {
            Tweener.addTween(Attractor, {"m":values[0], time:1.5, transition:"easeOutCubic", onStart:viewer.reset, onUpdate:sliders.reset});
        }
        
        private function drawBySlider():void {
            buttons.reset();
        }
    }
}

class Attractor {
    static public function get m():Number {return _m;}
    static public function set m(value:Number):void {_m = value;}
    static private var _m:Number;
    
    static public function get M_MIN():Number {return PARAMS[0];}
    static public function get M_MAX():Number {return PARAMS[1];}
    static public function get M_DEFAULT():Number {return PARAMS[2];}
    static private const PARAMS:Vector.<Number> = Vector.<Number>([-0.9, 0.9, -0.9]);
    
    static public function get numOfParticle():int {return numOfParticle_;}
    static private var numOfParticle_:int = 30000;
    
    static private var data_:Vector.<Number>;
    
    static private var x_:Number;
    static private var y_:Number;
    
    static public function setup():void {
        data = new Vector.<Number>(numOfParticle_ * 2, true);
        paramDefault();
    }
    
    static public function paramDefault():void {
        _m = M_DEFAULT;
    }
    
    static public function paramRandom():void {
        _m = Math.random() * (M_MAX - M_MIN) + M_MIN;
    }
    
    static public function update():Vector.<Number> {
        x_ = Math.random() * 10 - 5;
        y_ = Math.random() * 10 - 5;
        if(Math.random() < 0.5) x_ = -x_;
        if(Math.random() < 0.5) y_ = -y_;
        var len:int = numOfParticle_ * 2;
        for(var i:int=0; i<len; i+=2) {
            var xn:Number = y_ + f(x_);
            var yn:Number = -x_ + f(xn);
            data_[i] = xn;
            data_[i + 1] = yn;
            x_ = xn;
            y_ = yn;
        }
        return data_;
    }
    static private function f(x:Number):Number {
        var x2:Number = x * x;
        return _m * x + (2 * (1 - _m) * x2) / (1 + x2);
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.filters.BitmapFilterQuality;
import flash.filters.BlurFilter;
import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.geom.Rectangle;

class Viewer extends Bitmap {
    public function set fade(value:ColorTransform):void {
        _fade = value;
    }
    
    private var _fade:ColorTransform = new ColorTransform(0.95, 0.95, 0.95);
    
    public function set blur(value:BlurFilter):void {_blur = value;}
    private var _blur:BlurFilter = new BlurFilter(8, 8, BitmapFilterQuality.HIGH);
    
    private var start_:Number = 0.0;
    private var add_:Number = 0.5;
    private var renge_:Number = 150 / 360;
    
    private var bufferBmd_:BitmapData;
    private var rect_:Rectangle;
    private const ZERO_POINT:Point = new Point(0, 0);
    
    private var sw_:int;
    private var sh_:int;
    private var offsetX_:Number;
    private var offsetY_:Number;
    private const OFFSET_SCALE:int = 8;
    
    public function Viewer() {
        
    }
    
    public function setup(sw:Number, sh:Number):void {
        sw_ = sw;
        sh_ = sh;
        bufferBmd_ = new BitmapData(sw_, sh_, true, 0xff000000);
        bitmapData = bufferBmd_.clone();
        rect_ = new Rectangle(0, 0, sw_, sh_);
        offsetX_ = sw_ / 2;
        offsetY_ = sh_ / 2;
        reset();
        CycleRGB.alpha = 0x99;
    }
    public function update(data:Vector.<Number>):void {
        bufferBmd_.lock();
        bufferBmd_.fillRect(bufferBmd_.rect, 0x00000000);
        var len:uint = data.length;
        start_ += add_;
        for(var i:int = 0; i < len; i += 2) {
            var px:Number = (data[i] * OFFSET_SCALE + offsetX_) >> 0;
            var py:Number = (data[i + 1] * OFFSET_SCALE + offsetY_) >> 0;
            var offsetColorX:Number = (px > offsetX_) ? px - sw_ : px;
            var offsetColorY:Number = (py > offsetY_) ? py - sh_ : py;
            var offsetColor:Number = offsetColor = -offsetColor;
            bufferBmd_.setPixel32(px, py, CycleRGB.getColor32(offsetColor + start_));
        }
        bufferBmd_.unlock();
        
        bitmapData.lock();
        bitmapData.colorTransform(rect_, _fade);
        bitmapData.applyFilter(bitmapData, rect_, ZERO_POINT, _blur);
        bitmapData.draw(bufferBmd_);
        bitmapData.unlock();
    }
    
    public function reset():void {
        start_ = (Math.random() * 360) >> 0;
        add_ = ((Math.random() * 50 + 50) >> 0) / 100;
        renge_ = (Math.random() * 90 >> 0) + 90;
    }
}



