/**
 * Copyright Akkii ( http://wonderfl.net/user/Akkii )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lIYv
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.SampleDataEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Sound;
    import flash.utils.ByteArray;
    
   [SWF(backgroundColor = 0x404040, width = 465, height = 465, frameRate = 30)]  
    public class Main extends Sprite
    {
        private var soundLog:ByteArray = new ByteArray();
        private var bmp:BitmapData = new BitmapData(465, 465, true, 0);
        private var colorFade:ColorTransform = new ColorTransform(1, 1, 1, 0.5);
        
        public function Main()
        {
            // write as3 code here..
            var snd:Sound = new Sound();
            snd.addEventListener(SampleDataEvent.SAMPLE_DATA, soundGenerator());
            
            var bmpo:Bitmap = new Bitmap(bmp);
            this.addChild(bmpo);
            
            this.addEventListener(Event.ENTER_FRAME, drawWave);
            
            snd.play();
        }
        
        private function drawWave(event:Event):void
        {
            var g:Graphics = this.graphics;
            var h:int = 200;
            soundLog.position = 0;
            g.lineStyle(0, 0xf0f0f0);
            g.moveTo(0, h);
            var x:int = 0;
            for (var i:int = 0; i < soundLog.length; i++)
            {
                x = i * (stage.width / soundLog.length);
                g.lineTo(x, soundLog.readByte() + h + (i / 4));
            }
            bmp.lock();
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            bmp.colorTransform(rect, colorFade);
            bmp.copyPixels(bmp, rect, new Point(1, -1));
            bmp.draw(this);
            bmp.unlock();
            g.clear();
        }
        
        private function soundGenerator():Function
        {
            var cnt:int = 0;
            var pos:Number = 0;
            return function(event:SampleDataEvent):void
            {
                var data:ByteArray = byteSoundGenerator(cnt);
                data.position = 0;
                cnt += 512;
                for (var i:int = 0; i < 512; i++)
                {
                    var n:Number = data.readByte();
                    //8bitからノーマライズ
                    n /= 128;
                    //簡易的に8khz辺りにする
                    for (var j:int = 0; j < 6; j++)
                    {
                        event.data.writeFloat(n);
                        event.data.writeFloat(n);
                    }
                }
            };
        }
        
        private function byteSoundGenerator(cnt:int):ByteArray
        {
            var data:ByteArray = new ByteArray();
            soundLog.clear();
            for (var t:int = cnt; t < cnt + 512; t++)
            {
                var n:int = oneLineAlgorithmicMusic(t);
                data.writeByte(n);
                soundLog.writeByte(n);
            }
            return data;
        }
        
        private function oneLineAlgorithmicMusic(t:int):int
        {
            var n:int;
            //一行サウンド
            //n = t * ((t >> 12 | t >> 8) & 63 & t >> 4);
            n = (t >> 7 | t | t >> 6) * 10 + 4 * (t & t >> 13 | t >> 6);
            //n = (t * (t >> 5 | t >> 8)) >> (t >> 16);
            //n = t * ((t >> 9 | t >> 13) & 25 & t >> 6);
            //n = t * (t >>((t>> 9 | t >> 8)) & 63 & t >> 4);
            return n;
        }
    }
}