/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lIRc
 */

/*
 * CS5からのTLFの回り込み処理のテスト
 * 
 * 簡単にできると思いきや、1行1行個別にContainerControllerが必要みたい。
 * 回り込みサイズ可変のジェネレータ的なものにしようと
 * 思ったけど大変だったのでやめちゃった。
 * 
 * 回り込み対象をクリックで、テキストが格納されるコンテナが色分けされます。
 * 
 * */

package  {
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.text.engine.FontPosture;
	import flash.text.engine.JustificationStyle;
	import flash.text.engine.Kerning;
	import flashx.textLayout.container.ContainerController;
	import flashx.textLayout.container.ScrollPolicy;
	import flashx.textLayout.conversion.TextConverter;
	import flashx.textLayout.elements.Configuration;
	import flashx.textLayout.elements.TextFlow;
	import flashx.textLayout.formats.BlockProgression;
	import flashx.textLayout.formats.Direction;
	import flashx.textLayout.formats.JustificationRule;
	import flashx.textLayout.formats.TextAlign;
	import flashx.textLayout.formats.TextLayoutFormat;
	import flashx.textLayout.formats.WhiteSpaceCollapse;
	
	[SWF(backgroundColor="0xFFFFFF", frameRate="30", width="465", height="465")]
	
	/**
	 * ...
	 * @author 393
	 */
	
	 
	public class TFL_test extends Sprite{
		private var _str:String = ""
+"話題の3D映画のアバター、IMAXにて鑑賞してきました。"
+"アバター3Dが一番綺麗に見れるのはアイマックス。"
+"アイマックスの劇場は日本にまだ4軒しかないのです。"
+"んで、感想。"
+"確かに3Dスゲーって思った。"
+"最初の30分くらい画面の隅々まで観て楽しかった。"
+"が、いかんせん長い。"
+"後半は睡魔との闘い、ってか記憶がところどころ飛んだ。"
+"ありがちな展開なんだから1時間半くらいにまとめてください。"
+"あと結構後ろから観たんだけど、視界がスクリーンで埋まるくらいの距離で観た方がいいかもしんない。"
+"3D効果の物体がスクリーンで見切れた瞬間に2次元になっちゃうから。"
+"アリスは前の方で観てみようかな。"
+"あと今回は吹き替えで観たけど、字幕はきつそう。"
+"字幕も3Dだからふわふわしててなんか気持ち悪い。"
		
		private var _ball:Sprite;
		private var _square:Sprite;
		private var _sW:int = 465;
		private var _sH:int = 465;
		private var _tW:int = 400;
		private var _tH:int = 400;
		private var _offsetX:int = 30;
		private var _offsetY:int = 30;
		
		private var _squareLength:int = 40;
		//回り込みサイズ
		private var _squareMax:int = 2;
		private var _containers:Vector.<Sprite>;
		private var _containerRects:Vector.<Rectangle>;
		private var _containerControllers:Vector.<ContainerController>;
		private var _textLayoutFormat:TextLayoutFormat;
		private var _config:Configuration;
		private var _textFlow:TextFlow;
		private var _textContainer:Sprite;
		private var _isDrawContainer:Boolean = false;
		
		
		public function TFL_test() {
			addEventListener(Event.ADDED_TO_STAGE, addStageHandler);
		}		
		
		private function addStageHandler(e:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, addStageHandler);
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			addChild(_textContainer = new Sprite());
			_textContainer.graphics.beginFill(0xEEEEEE);			
			_textContainer.graphics.drawRect(0, 0, _tW, _tH);
			_textContainer.graphics.endFill();
			_textContainer.x = _offsetX;
			_textContainer.y = _offsetY;
			
			createContainer();
			init();
			
			//回り込み対象
			_textContainer.addChild(_square = createSquare(_squareLength));
			_square.x = 100
			_square.y = 100
			_square.buttonMode = true;
			//クリックイベント
			_square.addEventListener(MouseEvent.CLICK, 
				function(e:MouseEvent):void {
					if (_isDrawContainer) _isDrawContainer = false;
					else _isDrawContainer = true;
				}
			);

			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function enterFrameHandler(e:Event):void {
			_square.x += (_textContainer.mouseX - _square.x) * 0.1;
			_square.y += (_textContainer.mouseY - _square.y) * 0.1;
			//移動領域
			if (_square.x < _squareLength / 2) {
				_square.x  = _squareLength / 2;
			}else if (_square.x > _tW - _squareLength / 2) {
				_square.x  = _tW - _squareLength / 2;
			}
			if (_square.y < _squareLength / 2) {
				_square.y  = _squareLength / 2;
			}else if (_square.y > _tH - _squareLength / 2) {
				_square.y  = _tH - _squareLength / 2;
			}
			(0 | _square.x / _squareLength)
			//テキスト領域の更新
			updateContainer();
			//テキストの反映
			updateText();
		}
		
		private function createContainer():void {
			_containers = new Vector.<Sprite>();
			var containerMax:int = _squareMax * 4;
			for (var i:int = 0; i < containerMax; i++) {
				_containers.push(new Sprite());
				_textContainer.addChild(_containers[i]);
			};
		}
		private function init():void {
			//フォーマット
            _textLayoutFormat                    = new TextLayoutFormat();
			_textLayoutFormat.fontFamily = "_明朝";
            _textLayoutFormat.color              = 0x333333;
            _textLayoutFormat.fontSize           = 33;
            _textLayoutFormat.kerning            = Kerning.ON;
            _textLayoutFormat.fontStyle          = FontPosture.NORMAL;
            _textLayoutFormat.textAlign          = TextAlign.START;//一般的な揃え
            _textLayoutFormat.direction          = Direction.LTR;//左右揃え/上下揃え
            _textLayoutFormat.blockProgression   = BlockProgression.RL;//縦書きか横書き
            _textLayoutFormat.locale             = "ja";
            _textLayoutFormat.whiteSpaceCollapse = WhiteSpaceCollapse.PRESERVE;
            _textLayoutFormat.justificationRule  = JustificationRule.EAST_ASIAN;
            _textLayoutFormat.justificationStyle = JustificationStyle.PUSH_IN_KINSOKU;
            _textLayoutFormat.columnCount        = 1;
			
            _config            = new Configuration();
            _config.textFlowInitialFormat        = _textLayoutFormat;
			_textFlow = TextConverter.importToFlow(_str, TextConverter.PLAIN_TEXT_FORMAT,_config);
			
			//テキスト領域用のRectを生成
			_containerRects = new Vector.<Rectangle>();
			var containerMax:int = _squareMax * 4;
			
			for (var i:int = 0; i < containerMax; i++) {
				_containerRects.push(new Rectangle());
				var containerController:ContainerController = new ContainerController(_containers[i], 0, 0);
				containerController.verticalScrollPolicy = ScrollPolicy.OFF;
				containerController.horizontalScrollPolicy = ScrollPolicy.OFF;
				_textFlow.flowComposer.addController(containerController);
			};			
		}
		private function updateContainer():void {
			_square.x;
			setContainer();
			
			//Rectのアップロード
			_containerRects[0].height = _tH;
			_containerRects[0].width = _tW - ((0 | _square.x / _squareLength) * _squareLength + _squareLength)-_squareLength;
			
			_containerRects[1].height = _square.y - _squareLength / 2;
			if (_containerRects[1].height < _squareLength || _square.x > _tW - _squareLength) {
				_containerRects[1].width = 0;
			}else {
				_containerRects[1].width = _squareLength;
			}
			
			_containerRects[2].height = _tH - _square.y - _squareLength / 2;
			if (_containerRects[2].height < _squareLength || _square.x > _tW - _squareLength) {
				_containerRects[2].width = 0;
			}else {
				_containerRects[2].width = _squareLength;
			}
			
			_containerRects[3].height = _square.y - _squareLength / 2 - _squareLength;
			if (_containerRects[3].height < _squareLength) {
				_containerRects[3].width = 0;
			}else {
				_containerRects[3].width = _squareLength;
			}
			
			_containerRects[4].height = _tH - _square.y - _squareLength / 2 - _squareLength;
			if (_containerRects[4].height < _squareLength) {
				_containerRects[4].width = 0;
			}else {
				_containerRects[4].width = _squareLength;
			}
			_containerRects[5].height = _square.y - _squareLength / 2;
			if (_containerRects[5].height < _squareLength || _square.x < _squareLength) {
				_containerRects[5].width = 0;
			}else {
				_containerRects[5].width = _squareLength;
			}
			
			_containerRects[6].height = _tH - _square.y - _squareLength / 2;
			if (_containerRects[6].height < _squareLength || _square.x < _squareLength) {
				_containerRects[6].width = 0;
			}else {
				_containerRects[6].width = _squareLength;
			}
		
			_containerRects[_containers.length-1].height = _tH;
			_containerRects[_containers.length - 1].width = (0 | _square.x / _squareLength) * _squareLength - _squareLength;
			
		}
		private function updateText():void {
			for (var i:int = 0; i < _textFlow.flowComposer.numControllers; i++) {
				//コンテナのサイズを変更
				_textFlow.flowComposer.getControllerAt(i).setCompositionSize(Rectangle(_containerRects[i]).width, _containerRects[i].height);
			}
			//テキストフローの更新(コンテナのサイズとか変更したら更新する)
			_textFlow.flowComposer.updateAllControllers();
		}
		public function setContainer():void {
			
			_containers[0].x = (0 | _square.x / _squareLength) * _squareLength + _squareLength + _squareLength;
			_containers[0].y = 0;
			
			_containers[1].x = (0 | _square.x / _squareLength) * _squareLength + _squareLength;
			_containers[1].y = 0;
			
			_containers[2].x = (0 | _square.x / _squareLength) * _squareLength + _squareLength;
			_containers[2].y = _square.y + _squareLength / 2;
			
			
			_containers[3].x = (0 | _square.x / _squareLength) * _squareLength;
			_containers[3].y = 0;
			
			_containers[4].x = (0 | _square.x / _squareLength) * _squareLength;
			_containers[4].y = _square.y + _squareLength / 2 + _squareLength;
			
			_containers[5].x = (0 | _square.x / _squareLength) * _squareLength - _squareLength;
			_containers[5].y = 0;
			
			_containers[6].x = (0 | _square.x / _squareLength) * _squareLength - _squareLength;
			_containers[6].y = _square.y + _squareLength / 2;			
			
			_containers[_containers.length-1].x = 0;
			_containers[_containers.length - 1].y = 0;
			
			drawContainer();
		}
		
		private function drawContainer():void {
			//ContainerController対象の描画
			var spg0:Graphics = _containers[0].graphics;
			spg0.clear();
			var spg1:Graphics = _containers[1].graphics;
			spg1.clear();
			var spg2:Graphics = _containers[2].graphics;
			spg2.clear();
			var spg3:Graphics = _containers[3].graphics;
			spg3.clear();
			var spg4:Graphics = _containers[4].graphics;
			spg4.clear();
			var spg5:Graphics = _containers[5].graphics;
			spg5.clear();
			var spg6:Graphics = _containers[6].graphics;
			spg6.clear();
			var spg7:Graphics = _containers[_containers.length-1].graphics;
			spg7.clear();
			
			if (_isDrawContainer) {
				spg0.beginFill(0xFFCC00);
				spg0.drawRect(0, 0, _tW-((0|_square.x / _squareLength) * _squareLength + _squareLength)-_squareLength, _tH);
				spg0.endFill();
				spg1.beginFill(0xFF9933);
				spg1.drawRect(0, 0, _squareLength, _square.y-_squareLength/2);
				spg1.endFill();
				spg2.beginFill(0xFF6666);
				spg2.drawRect(0,0, _squareLength, _tH-_square.y-_squareLength/2);
				spg2.endFill();
				spg3.beginFill(0x99FF33);
				spg3.drawRect(0, 0, _squareLength, _square.y-_squareLength/2 - _squareLength);
				spg3.endFill();
				spg4.beginFill(0x33FFFF);
				spg4.drawRect(0,0, _squareLength, _tH-_square.y-_squareLength/2-_squareLength);
				spg4.endFill();
				spg5.beginFill(0x66ccFF);
				spg5.drawRect(0, 0, _squareLength, _square.y-_squareLength/2);
				spg5.endFill();
				spg6.beginFill(0xFF66FF);
				spg6.drawRect(0,0, _squareLength, _tH-_square.y-_squareLength/2);
				spg6.endFill();
				spg7.beginFill(0xFF3399);
				spg7.drawRect(0, 0, (0|_square.x / _squareLength) * _squareLength- _squareLength, _tH);
				spg7.endFill();
			}
		}
		
		//回り込み対象の描画
		public function createSquare(radius:int = 100):Sprite {
			var sp:Sprite = new Sprite();
			sp.graphics.beginFill(0xFFFF00);
			//中心
			sp.graphics.drawRect( -radius / 2, -radius / 2, radius,radius);
			//上
			sp.graphics.drawRect( -radius / 2, -radius / 2-radius, radius,radius);
			//下
			sp.graphics.drawRect( -radius / 2, -radius / 2+radius, radius,radius);
			//左
			sp.graphics.drawRect( -radius / 2-radius, -radius / 2, radius,radius);
			//右
			sp.graphics.drawRect( -radius / 2+radius, -radius / 2, radius,radius);
			sp.graphics.endFill();
			sp.alpha = 0.5;
			return sp;
		}
		
	}

}
