/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lHz2
 */

package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const N:uint = 1000000;
    static private const STARTX:Number = 10;
    static private const STARTY:Number = 0;
    static private const V:Number = 0.3;
    
    
    private function _init():void
    {
        _debug(
            "各テスト " + N + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        _measure("no sin", function ():void
        {
            var sx : Number = STARTX;
            var sy : Number = STARTY;
            var v : Number = V;
            
            var r : Number = Math.sqrt(sx * sx + sy * sy);
            var sq : Number = r / Math.sqrt(r * r + v * v);
            var rv : Number = v / r;
            var dx : Number;
            var dy : Number;
            for (var i:uint = 0; i < N; i++) {
                dx = (sx - sy * rv) * sq;
                dy = (sy + sx * rv) * sq;
                sx = dx;
                sy = dy;
            }
        _debug("" + sx + "\t" + sy + "\t" + (sx * sx + sy * sy) + "\n");
        }); 
        
        // さらに改良。でも誤差も半端ない
        _measure("no sin Ex", function ():void
        {
            var sx : Number = STARTX;
            var sy : Number = STARTY;
            var v : Number = V;
            
            var r : Number = Math.sqrt(sx * sx + sy * sy);
            var sq : Number = r / Math.sqrt(r * r + v * v);
            var rv : Number = v / r;
            var sqrv : Number = sq + rv * rv;
            for (var i:uint = 0; i < N; i++) {
                sx = (sx - sy * rv) * sq;
                sy = sy * sqrv + sx * rv;
            }
        _debug("" + sx + "\t" + sy + "\t" + (sx * sx + sy * sy) + "\n");
        }); 
        
        _measure("sin", function ():void
        {
            var sx : Number = STARTX;
            var sy : Number = STARTY;
            var t : Number = 0; // ゆるして
            var v : Number = V;
            var r : Number = Math.sqrt(sx * sx + sy * sy);
            
            var step : Number = Math.atan(v / r);
            for (var i:uint = 0; i < N; i++) {
                t += step;
                sx = r * Math.cos(t); 
                sy = r * Math.sin(t);
            }
        _debug("" + sx + "\t" + sy + "\t" + (sx * sx + sy * sy) + "\n");
        }); 
        
        _measure("none", function ():void
        {
            var sx : Number = STARTX;
            var sy : Number = STARTY;
            var t : Number = 0;
            var v : Number = V;
            var r : Number = Math.sqrt(sx * sx + sy * sy);
            
        _debug("" + sx + "\t" + sy + "\t" + (sx * sx + sy * sy) + "\n");
        }); 
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
