/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lHJy
 */

// forked from tkinjo's forked from: RingParticle
// forked from tkinjo's RingParticle
// forked from tkinjo's リングクラス
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * RingParticle
     * 
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private const MIN_INTERVAL:Number = 0;
        private const MAX_INTERVAL:Number = 1000;
        
        private const RING_MAX_RADIUS:Number = 100;
        
        private const RING_FADE_IN_SPEED:Number = 0.02;
        private const RING_FADE_OUT_SPEED:Number = 0.01;
        
        private const RING_ALPHA:Number = 0.5;
        
        private var ringParticles:RingParticle;
        private var lastRingParticle:RingParticle;
        private var ringFactoryTimer:Timer;
        
        public function Main() 
        {
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            ringParticles = new RingParticle( 0 );
            lastRingParticle = ringParticles;
            
            ringFactoryTimer = new Timer( 0 );
            ringFactoryTimer.addEventListener(TimerEvent.TIMER, ringFactoryTimerEventHandler);
            ringFactoryTimer.start();
        }
        
        private function enterFrameHandler( event:Event ):void {
            
            var previousRingParticle:RingParticle = ringParticles;
            var ringParticle:RingParticle;
            
            while ( ringParticle = previousRingParticle.next ) {
                
                ringParticle.scaleX = ringParticle.scaleY += 0.01;
                
                if ( ringParticle.fadeIn ) {
                    
                    ringParticle.alpha += RING_FADE_IN_SPEED;
                    
                    if ( ringParticle.alpha >= RING_ALPHA ) 
                        ringParticle.fadeIn = false;
                    
                    previousRingParticle = ringParticle;
                    
                } else {
                    
                    ringParticle.alpha -= RING_FADE_OUT_SPEED;
                    
                    if ( ringParticle.alpha <= 0 ) {
                        
                        removeChild( ringParticle );
                        previousRingParticle.next = ringParticle.next;
                        
                        if ( lastRingParticle == ringParticle )
                            lastRingParticle = previousRingParticle;
                        
                    } else {
                        
                        previousRingParticle = ringParticle;
                    }
                }
            }
        }
        
        private function ringFactoryTimerEventHandler( event:TimerEvent ):void {
            
            var ringRadius:Number = Math.random() * RING_MAX_RADIUS;
            var ringWidth:Number = Math.random() * ringRadius / 5;
            
            var ringParticle:RingParticle = createRingParticle( ringRadius, ringRadius - ringWidth, 0x0 );
            lastRingParticle.next = ringParticle;
            lastRingParticle = ringParticle;
            
            ringFactoryTimer.delay = Math.random() * ( MAX_INTERVAL - MIN_INTERVAL );
        }
        
        private function createRingParticle( radius:Number, innerRadius:Number = 0, color:Number = 0x0 ):RingParticle {
            
            var ringParticle:RingParticle = new RingParticle( radius, innerRadius, color );
            ringParticle.alpha = 0;
            ringParticle.x = Math.random() * stage.stageWidth;
            ringParticle.y = Math.random() * stage.stageHeight;
            addChild( ringParticle );
            
            var ringRadius:Number = Math.random() * innerRadius;
            var ringWidth:Number = Math.random() * ringRadius / 2;
            ringParticle.addChild( new RingParticle( ringRadius, ringRadius - ringWidth, color ) );
            
            return ringParticle;
        }
    }
    
}

import flash.display.*;

internal class RingParticle extends Sprite {
    
    public var fadeIn:Boolean = true;
    
    private var _ring:Ring;
    public function get ring():Ring {
        return _ring;
    }
    
    public var next:RingParticle;
    
    public function RingParticle( radius:Number, innerRadius:Number = 0, color:Number = 0 ):void {
        
        _ring = new Ring( radius, innerRadius, color );
        ring.x = -radius;
        ring.y = -radius;
        addChild( ring );
    }
}

internal class Ring extends Sprite {
    
    public function get radius():Number { return _radius; }
    public function set radius(value:Number):void 
    {
        _radius = value;
        draw();
    }
    private var _radius:Number;
    
    
    
    public function get innerRadius():Number { return _innerRadius; }
    public function set innerRadius(value:Number):void 
    {
        _innerRadius = value;
        draw();
    }
    private var _innerRadius:Number;
    
    
    
    public function get color():Number { return _color; }
    public function set color(value:Number):void 
    {
        _color = value;
        draw();
    }
    private var _color:Number;
    
    
    
    public function Ring( radius:Number, innerRadius:Number = 0, color:Number = 0 ) {
        
        _radius = radius;
        _innerRadius = innerRadius;
        _color = color;
        
        draw();
    }
    
    
    
    private function draw():void {
        
        graphics.clear();
        graphics.beginFill( color );
        graphics.drawCircle( radius, radius, radius);
        if ( innerRadius != 0 )
            graphics.drawCircle( radius, radius, innerRadius );
        graphics.endFill();
    }
}