/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lGvH
 */

/*
 * 直感でやってみたけど････
 * 綺麗じゃない…
 * */
package{
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;

	public class Scale9Grid_test2 extends Sprite{
		private const url:String = "http://assets.wonderfl.net/images/related_images/d/df/df46/df46c6a511db7120b0e5d399e84c37d7ad32ffbc";
		private var scale:Number = 0.99;
		public function Scale9Grid_test2(){
			var img:Loader = new Loader();
			img.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
			img.load( new URLRequest(url), new LoaderContext(true));
			
			function onComp( e:Event ):void{
				var r:Rectangle = new Rectangle(36,36, img.width-72, img.height-72);
				
				var bmp:Bitmap = img.content as Bitmap;
				var bs9g:BitmapScale9Grid = new BitmapScale9Grid( bmp.bitmapData, r) ;
				addChild(bs9g);
				
				//*
				addEventListener(Event.ENTER_FRAME, function(e:Event):void{
					if(bs9g.scaleX > 1.5) scale = 0.99;
					if(bs9g.scaleX < 0.5) scale = 1.01;
					bs9g.scaleX *= scale;
				});
				//*/
			}
		}
		//-----------------------------------------------------------------
	}
}
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.Rectangle;
	import flash.geom.Matrix;
	import flash.geom.Point;
	

class BitmapScale9Grid extends Sprite{
	private var lt:Bitmap;
	private var t:Bitmap;
	private var rt:Bitmap;
	
	private var l:Bitmap;
	private var m:Bitmap;
	private var r:Bitmap;
	
	private var lb:Bitmap;
	private var b:Bitmap;
	private var rb:Bitmap;
	
	private var w:Number, h:Number;
	private var insideWidth:Number;
	private var insideHeight:Number;
	
	private var left:Number;
	private var right:Number;
	private var top:Number;
	private var bottom:Number;
	
	private var _data:BitmapData;
	private var _grid:Rectangle;
	
	private var sX:Number = 1;
	private var sY:Number = 1;
	
	public function BitmapScale9Grid( data:BitmapData , grid:Rectangle){
		_data = data;
		_grid = grid;
		
		lt = new Bitmap();
		t = new Bitmap();
		rt = new Bitmap();
		
		l = new Bitmap();
		m = new Bitmap();
		r = new Bitmap();
		
		lb = new Bitmap();
		b = new Bitmap();
		rb = new Bitmap();
		
		add();
		setSource( data, grid);
	}
	public function setSource( data:BitmapData, grid:Rectangle):void{
		checkPos();
		setBitmapData();
		
		// top
		var rect:Rectangle = new Rectangle(0,0, left, top);
		var p:Point = new Point(0,0)
		lt.bitmapData.copyPixels( data, rect, p);
		
		rect = new Rectangle( left, 0, w - right, top);
		t.bitmapData.copyPixels( data, rect, p);
		
		rect = new Rectangle( w - right, 0, w, top);
		rt.bitmapData.copyPixels( data, rect, p);
		
		// m
		rect = new Rectangle(0,top, left, insideWidth);
		l.bitmapData.copyPixels( data, rect, p);
		
		rect = new Rectangle(left,top, w-right, insideWidth);
		m.bitmapData.copyPixels( data, rect, p);
		
		rect = new Rectangle(w-right,top, w, insideWidth);
		r.bitmapData.copyPixels( data, rect, p);
		
		// bottom
		rect = new Rectangle(0,h - bottom, left, bottom);
		lb.bitmapData.copyPixels( data, rect, p);
		
		rect = new Rectangle(left,h - bottom, w - right, bottom);
		b.bitmapData.copyPixels( data, rect, p);
		
		rect = new Rectangle( w - right,h - bottom, w, bottom);
		rb.bitmapData.copyPixels( data, rect, p);
		
		positioning( w, h);
	}
	private function checkPos():void{
		w = _data.width;
		h = _data.height;
		insideWidth = _grid.width;
		insideHeight = _grid.height;
		
		left = _grid.x;
		right = w - ( left + insideWidth );
		top = _grid.y;
		bottom = h - ( top + insideHeight );
	}
	private function setBitmapData():void{
		lt.bitmapData = new BitmapData( left, top);
		t.bitmapData = new BitmapData( insideWidth, top );
		rt .bitmapData = new BitmapData( right, top );
		
		l.bitmapData = new BitmapData( left, insideHeight );
		m.bitmapData = new BitmapData( insideWidth, insideHeight );
		r.bitmapData = new BitmapData( right, insideHeight );
		
		lb.bitmapData = new BitmapData(left, bottom );
		b.bitmapData = new BitmapData(insideWidth, bottom );
		rb.bitmapData = new BitmapData(right, bottom );
	}
	private function add():void{
		addChild( lt );
		addChild( t );
		addChild( rt );
		//*
		addChild( l );
		addChild( m );
		addChild( r );
		
		addChild( lb );
		addChild( b );
		addChild( rb );
		//*/
	}
	private function positioning( w:Number, h:Number):void{
		lt.x = l.x = lb.x = 0;
		t.x = m.x = b.x = left;
		rt.x = r.x = rb.x = w - right;
		l.y = m.y = r.y = top;
		lb.y = b.y = rb.y = h - bottom;
	}
	
	private function scaling( width:Number, height:Number):void{
		unlock();
		if( w != width){
			t.scaleX = m.scaleX = b.scaleX = (width - (left + right)) / insideWidth;
		}else{
			t.scaleX = m.scaleX = b.scaleX = 1;
		}
		if( h != height){
			l.scaleY = m.scaleY = r.scaleY = (height - (top + bottom)) / insideHeight;
		}else{
			l.scaleY = m.scaleY = r.scaleY = 1;
		}
		lock();
		positioning( width, height);
	}
	private function lock():void{
		lt.bitmapData.lock();
		t.bitmapData.lock();
		rt.bitmapData.lock();
		
		l.bitmapData.lock();
		m.bitmapData.lock();
		r.bitmapData.lock();
		
		lb.bitmapData.lock();
		b.bitmapData.lock();
		rb.bitmapData.lock();
	}
	private function unlock():void{
		lt.bitmapData.unlock();
		t.bitmapData.unlock();
		rt.bitmapData.unlock();
		
		l.bitmapData.unlock();
		m.bitmapData.unlock();
		r.bitmapData.unlock();
		
		lb.bitmapData.unlock();
		b.bitmapData.unlock();
		rb.bitmapData.unlock();
	}
	
	public override function get scaleX():Number{
		return sX;
	}
	public override function set scaleX(value:Number):void{
		scaling( w * value, h);
		sX = value;
	}
	public override function get scaleY():Number{
		return sY;
	}
	public override function set scaleY(value:Number):void{
		scaling(w, h*value);
		sY = value;
	}
	public override function set height(value:Number):void{
		scaling(w, value);
	}
	public override function set width(value:Number):void{
		scaling( value, h);
	}
}