/**
 * Copyright Kihara ( http://wonderfl.net/user/Kihara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lGrV
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    
    public class vertex_sample extends BasicView
    {
        private var plane:Plane;
        private var time:int = 0;
        
        public function vertex_sample()
        {
            var material:WireframeMaterial = new WireframeMaterial(0xFF00FF);
            material.doubleSided = true;
            plane = new Plane(material,500,500,10,10);
            plane.rotationY = 90;
            scene.addChild(plane);
            
            camera.y = 400;
            startRendering();
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
        public function onEnterFrame(e:Event):void{
            var max:int = plane.geometry.vertices.length;
            for(var i:int = 0;i<max;i++){
                var rot:Number = i/max*360;
                rot += time;
                var vertex:Vertex3D = plane.geometry.vertices[i];
                vertex.z = 200 * Math.sin(rot*Math.PI/180);
            }
            time += 4;
        }
    }
}