/**
 * Copyright ll_koba_ll ( http://wonderfl.net/user/ll_koba_ll )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lGO1
 */

// forked from ll_koba_ll's Threadの割り込みがうまくいかないことがある
// stageを連打してるとClickThreadのinterruptedが実行されないことがたまにある
// 一回目のクリックから3秒後にMainThreadからClickThreadにinterruptしてる

// とりあえずこんな感じで解決してみる

package
{
    import flash.display.*;
    import org.libspark.thread.Thread;
    import org.libspark.thread.EnterFrameThreadExecutor;

    public class InterruptTest extends Sprite
    {
        public function InterruptTest()
        {
            Thread.initialize(new EnterFrameThreadExecutor())
            new MainThread(this).start();
        }
    }
}

import flash.display.Sprite;
import flash.events.MouseEvent;
import org.libspark.thread.Thread;

class MainThread extends Thread
{
    private var _clickThread:ClickThread;
    private var _target:Sprite
    public function MainThread(target:Sprite)
    {
        _target = target;
    }

    protected override function run():void
    {
        event(_target.stage, MouseEvent.CLICK, hoge);   
    }
    
    private function hoge(e:MouseEvent):void
    {
        sleep(3000);
        next(exit);
        _clickThread = new ClickThread(_target);
        _clickThread.start();
    }

    private function exit():void
    {
        //_clickThread.interrupt();
        _clickThread.endFlag = true;
        trace("MainThread exit"); 
    }
}

class ClickThread extends Thread
{
    private var _target:Sprite;
    public var endFlag:Boolean = false;
    public function ClickThread(target:Sprite)
    {
        _target = target;
    }

    protected override function run():void
    {
        if (endFlag)
        {
            exit();
            return;
        }
        event(_target.stage, MouseEvent.CLICK, click);
        //interrupted(exit);
    }

    private function click(e:MouseEvent):void
    {
        trace("click");
        run();
    }

    private function exit():void
    {
        trace("exit!!!!!");
    }

}





