/**
 * Copyright kske ( http://wonderfl.net/user/kske )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lG0t
 */

// Action Script 3.0イメージエフェクト
// ボーンデジタル(株) Todd Yard / 永井勝則
// copywright(c) Todd Yard
// 


package {
    import flash.display.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.filters.*;
    import flash.events.*;
    
    [SWF(width=420, height=200, backgroundColor=0x0)]
    public class BurningLetters extends Sprite {
    		private static const FLICKER_RATE:Number = 10;
    		private var perlinNoise:BitmapData;
    		private var perlinOffset:Array;
    		private var perlinSeed:int;
        private var flame:BitmapData;
        private var blackField:TextField;
        public function BurningLetters() {
        		makeFlame();
        		makeFields();
        		makeNoise();
        		addEventListener(Event.ENTER_FRAME, onSpriteEnterFrame);
        }
        
        private function makeFlame():void {
        		flame = new BitmapData(
        			stage.stageWidth,
        			stage.stageHeight,
        			true,
        			0x0
        		);
        		addChild(new Bitmap(flame));
        }
        
        private function makeFields():void{
        		var field:TextField = createField();
        		field.filters = [
        			new GradientGlowFilter(
        				0, // distance
        				90, // angle
        				[0xff0000, 0xffff00], // colors
        				[1, 1], // alphas
        				[70, 255], // 色の分布
        				25, // blur X
        				15 // blur Y
        			)
        		];
        		blackField = createField();
        }
        
        private function createField():TextField{
        		var field:TextField = new TextField();	
        		field.autoSize = TextFieldAutoSize.LEFT;
        		field.selectable = false;
        		field.defaultTextFormat = new TextFormat("Impact", 80);
        		field.text = "HOT STUFF";
        		field.x = (stage.stageWidth - field.width) / 2;
        		field.y = stage.stageHeight - field.height;
        		addChild(field);
        		return field;
        }
        
        private function makeNoise():void{
        		perlinNoise = flame.clone();
        		perlinSeed = int(new Date());
        		perlinOffset = [new Point(), new Point(100, 0), new Point(), new Point()];
        }
        
        private function applyNoise():void{
        		perlinNoise.perlinNoise(
        			25, // base X
        			120, // base Y
        			4, // num octaves
        			perlinSeed, // seed
        			false, // ノイズのエッジを滑らかにするか
        			true, //  fractalか乱流か
        			BitmapDataChannel.RED, // ノイズ生成のチャンネル
        			true, // グレースケールにするか
        			perlinOffset // オクターブごとのオフセットの配列
        		);
        		(perlinOffset[0] as Point).y += FLICKER_RATE;
        		(perlinOffset[1] as Point).y += FLICKER_RATE / 2;
        }
        
        private function drawFlame():void{
        		flame.draw(
        			stage,
        			null,
        			new ColorTransform(.9, .9, .9, .7)
        		);
        		
        		flame.applyFilter(flame, flame.rect, new Point(), new BlurFilter(3, 5));
        		
        		flame.scroll(0, -4);
        		applyNoise();
        		
        		flame.applyFilter(flame, flame.rect, new Point(), new DisplacementMapFilter(
        			perlinNoise, // マップ
        			new Point(), // 左上px
        			BitmapDataChannel.RED, // X方向置き換えに使うchannel
        			BitmapDataChannel.RED, // Y方向置き換えに使うchannel
        			6, // X方向の歪曲量 // 大きくするともわもわするよ
        			15, // Y方向の歪曲量 // 大きくすると激しいよ
        			DisplacementMapFilterMode.CLAMP
        		)
        		);
        }
        	
        	private function onSpriteEnterFrame(event:Event):void{
        		blackField.visible = false;
        		drawFlame();
        		blackField.visible = true;
        	}
    }
}