/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lFkm
 */

package
{
    import com.bit101.components.HBox;
    import com.bit101.components.PushButton;
    
    import flash.display.Sprite;
    import flash.text.TextField;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#FFFFFF")]
    
    public class WonderflApp extends Sprite
    {
        private var firstItem:Item;
        private var firstFinalItem:FinalItem;
        
        private var logTextField:TextField = new TextField();
        private static const R:uint = 10000000;
        
        public function WonderflApp():void
        {
            logTextField.y = 20;
            logTextField.width = stage.stageWidth;
            logTextField.height = stage.stageHeight - logTextField.y;
            addChild(logTextField);
            
            var box:HBox = new HBox(this);
            box.spacing = 0;
            new PushButton(box, 0, 0, "Linked List", testLinked).width = 100;
            new PushButton(box, 0, 0, "Linked List Final", testLinkedFinal).width = 100;
        }
        
        private function log(message:String):void
        {
            logTextField.appendText(message + "\n");
            logTextField.scrollV = logTextField.maxScrollV;
        }
        
        private function measure(methodName:String):void
        {
            var method:Function = this[methodName];
            var t0:Date = new Date();
            method();
            var t:uint = new Date().time - t0.time;
            log(methodName + ": " + t + " ms.");
        }
        
        private function generateItems():void
        {
            if(firstItem)
                return;
            
            log("----- Generating items -----");
            var item:Item = new Item();
            var pItem:Item;
            pItem = firstItem = item;
            for(var i:uint = 1; i < R; i++)
            {
                item = new Item();
                pItem.next = item;
                pItem = item;
            }
        }
        
        private function testLinked(... rest):void
        {
            generateItems();
            log("--- Starting Linked List test --- (" + R +" iterations)");
            measure("testLinkedExe");
            log("");
        }
        
        public function testLinkedExe():void
        {
            var item:Item = firstItem;
            var count:uint;
            while(item)
            {
                //count++;
                item = item.next;
            }
        }
        
        
        private function generateFinalItems():void
        {
            if(firstFinalItem)
                return;
            
            log("----- Generating Final items -----");
            var item:FinalItem = new FinalItem();
            var pItem:FinalItem;
            pItem = firstFinalItem = item;
            for(var i:uint = 1; i < R; i++)
            {
                item = new FinalItem();
                pItem.next = item;
                pItem = item;
            }
        }
        
        private function testLinkedFinal(... rest):void
        {
            generateFinalItems();
            log("--- Starting Linked List Final test --- (" + R +" iterations)");
            measure("testLinkedFinalExe");
            log("");
        }
        
        public function testLinkedFinalExe():void
        {
            var item:FinalItem = firstFinalItem;
            var count:uint;
            while(item)
            {
                //count++;
                item = item.next;
            }
        }
    }
}

class Item
{
    public var next:Item;
    
    public function Item()
    {
    }
}

final class FinalItem
{
    public var next:FinalItem;
    
    public function FinalItem()
    {
    }
}