/**
 * Copyright J.J ( http://wonderfl.net/user/J.J )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lFcJ
 */

package {
    import flash.utils.clearInterval;
    import flash.filters.DropShadowFilter;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextField;
    import flash.utils.setInterval;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    /**
     * @author javid jafari
     */
    public class Maze extends Sprite {
        private  var main : Vector.<Vector.<uint>>;
        private var AvailableNeighbours:Array
        private  var FarNeighbour : Object;
        private  var NearNeighbour : Object;
        private  var List : Object;
        private var X : uint,Y : uint
        private var w : uint,h : uint
        private var bmp : Bitmap;
        private var txt : TextField;
        private var size:uint=20
        public function Maze() {
            w=stage.stageWidth;
            h=stage.stageWidth
            bmp=new Bitmap()
            bmp.bitmapData=new BitmapData(size+1, size+1,false,0xffffff)
            addChild(bmp)
            bmp.scaleX=bmp.scaleY=h/(size+1)
            txt=new TextField()
            txt.autoSize=TextFieldAutoSize.LEFT
            txt.multiline=true
            txt.textColor=0xff0000
            txt.filters=[new DropShadowFilter()]
            addChild(txt)
            initMain()
            X=Y=0
            generate()
            stage.addEventListener(MouseEvent.CLICK, clicked)
        }
        private function initMain() : void {
            main=Vector.<Vector.<uint>>([])
            for (var i : uint = 0; i <= size; i++) {
                main[i]=Vector.<uint>([])
                for (var j : uint = 0; j <= size; j++) {
                    main[i].push(0)
                }
            }
        }
        private function clicked(event : Event) : void {
            
            initMain()
            generate()
        }
        private function generate() : void {
            bmp.bitmapData.lock()
            bmp.bitmapData.fillRect(bmp.bitmapData.rect, 0xffffff)
            bmp.bitmapData.unlock()
            List={
            row:[X]
            ,column:[Y]
            }
            var id:uint=setInterval(start, 30)
            function start():void{
            if (List.column.length>0) {    
            X=List.row[List.row.length-1]
            Y=List.column[List.column.length-1]
            AvailableNeighbours=getAvailableNeighbours(X,Y)
            if(AvailableNeighbours.length>0){
            var p:Point=AvailableNeighbours[int(Math.random()*AvailableNeighbours.length)]
            var p2:Point
            for(var s:String in FarNeighbour) if(FarNeighbour[s]==p) p2=NearNeighbour[s]
            main[p.x][p.y]=main[p2.x][p2.y]=1
            List.row.push(p.x)
            List.column.push(p.y)
            }else{
            List.row.pop()
            List.column.pop()
            }
            traceMain()
            }else{clearInterval(id)}
            }
        }
        private function getAvailableNeighbours(_x:uint,_y:uint) : Array {
            var list:Array=[]
            NearNeighbour={
            left:checkDomain(_x-1, _y)
            ,right:checkDomain(_x+1, _y)
            ,top:checkDomain(_x,_y-1)
            ,down:checkDomain(_x,_y+1)
            }
            FarNeighbour={
            left:checkDomain(_x-2, _y)
            ,right:checkDomain(_x+2, _y)
            ,top:checkDomain(_x,_y-2)
            ,down:checkDomain(_x,_y+2)
            }

            for(var s:String in FarNeighbour){
            var p:Point=FarNeighbour[s]
            if(p!=null) if(main[p.x][p.y]!=1)list.push(p)    
            }        
            return list
        }
        private function checkDomain(_x:uint,_y:uint) : Point {
            if((_x>=0 && _x<=size) && (_y>=0 && _y<=size)) return new Point(_x,_y)
            else return null
        }
        private function traceMain() : void {
            var str:String=''
            for (var i : int = 0; i <=size; i++) {
                for (var j : int = 0; j <= size; j++) {
                    str+=main[j][i]+'   '
                    if(main[j][i]==1) bmp.bitmapData.setPixel(j, i, 0)
                }
                str+='\n'
            }
            txt.text=str
            //trace(str)
        }
    }
}



