/**
 * Copyright mex_ny ( http://wonderfl.net/user/mex_ny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lFcC
 */

// forked from mex's 【AS100本ノック】1本目：Hello World
/* 
 * AS100本ノック
 * 1本目のお題は「Hello World」
 * あなたなりの「Hello World」を表現してください。
 */

package {

	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.events.TweenEvent;
	
	[SWF(frameRate=60)]
	public class HelloWorld extends Sprite 
	{
		private const DQFONT:Array = [
			"3E3E3E003E3E3E",
			"013F3F033F3F01",
			"3F3F3F3F3F3F01",
			"635D3E3E3E5D63",
			"3E3E36222A5D5D",
			"073B3D3D3D3B07",
			"033D3D03373B3D",
		];
		private const MESSAGE:Array = [0, 1, 2, 2, 3, 4, 3, 6, 2, 5 ],BASE_Z:uint = 400,BASE_BLUR:uint = 16,BLUR_DEPTH:uint = 5;
		private var _charBitmapDataArray:Array = new Array(), _charSpArray:Array = new Array();
		private var _base:Sprite = new Sprite(),_stageWidth:uint,_stageHeight:uint,_count:uint = 0,_len:uint;

		public function HelloWorld()
		{
			Wonderfl.capture_delay( 10 );
			init();
		}
		
		private function init():void
		{
			_stageWidth = _stageHeight = 465;
			_len = MESSAGE.length;
			var bg:Sprite = new Sprite();
			bg.graphics.beginFill(0x000000);
			bg.graphics.drawRect(0, 0, _stageWidth, _stageHeight);
			addChild(bg);
			
			makeCharBitmapData();
			makeCharSprite();
			setChar();
			startTween();
		}
		
		private function makeCharBitmapData():void
		{
			var len:uint , binar:String, binarArray:Array = new Array();
			for ( var i:uint = 0; i < DQFONT.length; i++ )
			{
				len = DQFONT[i].length >> 1;
				for ( var x:uint = 0; x < len; x++ )
				{
					binarArray[x] = new Array();
					binar = uint( parseInt( DQFONT[i].substr( x << 1 ,  2 ) , 16 ) | 128 ).toString(2).substr( ( len == 7 ) ? 1 : 0 );
					for ( var y:uint = 0 ; y < len ; y++)
						binarArray[x][y] = binar.charAt( y );
				}
				_charBitmapDataArray.push( BitmapPatternBuilder.build( binarArray , [ 0xffffffff, 0x00000000 ] ) );
			}
		}

		private function makeCharSprite():void
		{
			var charSp:Sprite, charBitmap:Bitmap, blur:BlurFilter,blurValue:uint;
			
			for ( var i:uint = 0; i < _len; i++ )
			{
				charBitmap = new Bitmap( _charBitmapDataArray[ MESSAGE[ i ] ] );
				charBitmap.scaleX = charBitmap.scaleY = 35;
				charSp = new Sprite();
				charSp.name = i.toString();
				charSp.addChild( charBitmap );
				new Reflect( { target:charSp , alpha:30, ratio:150, distance:1, updateTime: -1, reflectionDropoff:0 } );
				
				blurValue = ( i + 1 ) * BASE_BLUR;
				if ( blurValue > ( BLUR_DEPTH+1 ) * BASE_BLUR ) blurValue = BLUR_DEPTH * BASE_BLUR;
				blur = new BlurFilter( blurValue , blurValue , 2 );
				charSp.filters = [ blur ];

				_charSpArray.push( charSp );
			}
		}
	
		private function setChar():void
		{
			addChild( _base );

			for ( var i:uint = 0; i < _len; i++ )
			{
				_base.addChildAt( _charSpArray[i] , 0 );
				_charSpArray[i].x = Math.round( Math.random() * 1000  );
				_charSpArray[i].z = i * BASE_Z;
			}
			_base.z = 5000;
			_base.x = ( _stageWidth - _charSpArray[0].width ) / 2;
			_base.y = ( _stageHeight - _charSpArray[0].width ) / 2;
		}
		
		private function startTween():void
		{
            var t:ITween = BetweenAS3.tween( _base, { z:BASE_Z }, null, 1);
            t.addEventListener( TweenEvent.COMPLETE, startTweenCompleteHandler );
			t.play();
		}
		
		private function startTweenCompleteHandler( e:TweenEvent ):void
		{
			e.target.removeEventListener( TweenEvent.COMPLETE, startTweenCompleteHandler );
			zoomUp();
		}
		
		private function zoomUp():void
		{
			var time1:Number = 1.0,num:uint = _count;
			var x:int = ( ( _stageWidth - _charSpArray[num].width ) / 2 ) - _charSpArray[num].x;
			var tweenArray:Array = new Array();
			
            var base_t:ITween = BetweenAS3.tween( _base, { x:x, z:_base.z - BASE_Z }, null, time1 );
			tweenArray.push( makeTimeRemapTween( base_t ) );
			
			var blurValue:int;
			var len:uint = _len - 1;
			for ( var i:uint = 0; i < _len; i++ )
			{
				if ( _base.getChildIndex(_charSpArray[i]) <= len && _base.getChildIndex(_charSpArray[i]) >= BLUR_DEPTH-1 )
				{
					blurValue = _charSpArray[i].filters[0].blurX - BASE_BLUR;
					if ( blurValue >= 0 )
					{
						base_t = BetweenAS3.tween( _charSpArray[i], { _blurFilter: { blurX:blurValue, blurY:blurValue } }, null, time1 );
						tweenArray.push( makeTimeRemapTween( base_t ) );
					}
				}
			}
			var t:ITween = BetweenAS3.parallel.apply( null , tweenArray );
			t.addEventListener( TweenEvent.COMPLETE, zoomUpCompleteHandler );
			t.play();
		}

		private function makeTimeRemapTween( base_t:ITween ):ITween
		{
			var time1:Number = 0.95, time2:Number = 0.3, time3:Number = 18;

            var t_1:ITween = BetweenAS3.slice( base_t , 0.0 , time1 , true );
            var t_2:ITween = BetweenAS3.slice( base_t , time1 , 1.0 , true );
            t_1 = BetweenAS3.scale( t_1 , time2 );
            t_2 = BetweenAS3.scale( t_2 , time3 );
			
			return BetweenAS3.serial( t_1 , t_2 );
		}
		

		private function zoomUpCompleteHandler( e:TweenEvent ):void
		{
			var num:uint = _count, sp:Sprite = _charSpArray[num], blurValue:uint = BLUR_DEPTH * BASE_BLUR;
            var t1:ITween = BetweenAS3.tween( sp, { _blurFilter: { blurX: 20, blurY: 20 } }, null, 0.2 );
			
			e.target.removeEventListener( TweenEvent.COMPLETE, zoomUpCompleteHandler );
			
			t1.addEventListener(TweenEvent.COMPLETE,
				function():void {
					t1.removeEventListener( TweenEvent.COMPLETE, arguments.callee);
					_base.removeChild( _charSpArray[num] );

					_charSpArray[num].x = Math.round( Math.random() * 1000 );
					_charSpArray[num].z += BASE_Z * _len;
					_charSpArray[num].filters = [ new BlurFilter( blurValue , blurValue , 2 ) ];
					_base.addChildAt( _charSpArray[num] , 0 );
				} 
			);
			t1.play();
			
			_count += 1;
			
			if ( _count >= _len ) {
				for ( var i:uint = 0; i < _len; i++ )
				{
					_charSpArray[i].z -= BASE_Z * _len;
				}

				_base.z = BASE_Z;
				_count = 0;
			}
			zoomUp();
		}
	}
}

import flash.display.DisplayObjectContainer;
import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.display.SpreadMethod;
import flash.display.GradientType;
import flash.geom.Matrix;

class Reflect {
	
	private var _target:DisplayObjectContainer,_targetBitmapData:BitmapData,_reflectBitmap:Bitmap;
	private var _gradientMask_sp:Sprite;
	private var _bounds:Object;
	private var _updateTime:Number;

	public function Reflect( o:Object )
	{
		_target = o.target;
		_updateTime = o.updateTime;
		_bounds = new Object();
		_bounds.width = _target.height;
		_bounds.height = _target.width;

		run( o.distance , o.alpha / 100 , o.ratio , o.reflectionDropoff );
	}
	
	private function run( distance:int = 0 , alpha:Number = 0 , ratio:int = 0 , reflectionDropoff:int = 0 ):void
	{
		_targetBitmapData = new BitmapData( _bounds.width, _bounds.height, true,0xFFFFFF);
		_targetBitmapData.draw( _target );
		_reflectBitmap = new Bitmap( _targetBitmapData );
		_reflectBitmap.scaleY = -1;
		_reflectBitmap.y = ( _bounds.height << 1 ) + distance;
		var reflectionBMPRef:DisplayObject =  _target.addChild( _reflectBitmap );
		reflectionBMPRef.name = "reflectionBMP";

		var gradientMaskRef:DisplayObject = _target.addChild( new Sprite() );
		gradientMaskRef.name = "gradientMask_sp";
		_gradientMask_sp = _target.getChildByName( "gradientMask_sp" ) as Sprite;

		var fillType:String = GradientType.LINEAR;
		var colors:Array = [0xFFFFFF, 0xFFFFFF];
		var alphas:Array = [ alpha, 0];
		var ratios:Array = [0, ratio];
		var spreadMethod:String = SpreadMethod.PAD;
		
		var matrix:Matrix = new Matrix();
		
		var matrixHeight:Number;
		matrixHeight = ( reflectionDropoff <= 0 ) ? _bounds.height : _bounds.height / reflectionDropoff;
		matrix.createGradientBox( _bounds.width, matrixHeight, (90 / 180) * Math.PI, 0, 0);
		
		_gradientMask_sp.graphics.beginGradientFill( fillType , colors , alphas , ratios , matrix , spreadMethod );
		_gradientMask_sp.graphics.drawRect( 0 , 0 , _bounds.width , _bounds.height );
		
		_gradientMask_sp.y = _target.getChildByName("reflectionBMP").y - _target.getChildByName("reflectionBMP").height;
		_gradientMask_sp.cacheAsBitmap = true;
		_target.getChildByName( "reflectionBMP" ).cacheAsBitmap = true;
		_target.getChildByName( "reflectionBMP" ).mask = _gradientMask_sp;
	}
}


/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}