/**
 * Copyright undo ( http://wonderfl.net/user/undo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lF6H
 */

//マウスクリックで遊ぼう
//マウスボタンを押してる間は上昇、離すと下降
//赤い壁に当たるか、ステージ上下に当たるとGAME OVER
//衝突判定はhitTestなのでかなり厳しいです。触れただけでアウト
package 
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.net.SharedObject;
	import flash.geom.Matrix;
	import flash.display.IBitmapDrawable;
	import flash.utils.Timer;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;

	import caurina.transitions.Tweener;
	public class FlashTest extends Sprite
	{
		private var ship:Sprite = new Sprite();
		private var shipContainer:Sprite = new Sprite();
		private var shipWidth:Number = 5;
		private var vy:Number = -5;
		private var grv:Number = 0.5;
		private var route:Bitmap = new Bitmap();
		private var walls:Array = new Array();
		private var maxWall:int = 5;
		private var wallInc:Number = 10;
		private var wallTimer:Timer = new Timer(2000,1);
		private var bomb:Sprite = new Sprite();
		private var tf:TextField = new TextField();
		private var score:uint = 0;
		private var scoretf:TextField = new TextField();
		private var hiscore:uint;
		private var hiscoretf:TextField = new TextField();
		private var so:SharedObject;
		public function FlashTest()
		{
			init();
		}
		private function init():void
		{
			stage.addChild(bomb);
			ship.graphics.beginFill(0x0000ff);
			ship.graphics.drawRect(-shipWidth,-shipWidth,shipWidth*2,shipWidth*2);
			ship.x = 150;
			ship.y = stage.stageHeight/2;
			shipContainer.addChild(ship);
			stage.addChild(shipContainer);
			shipContainer.addChild(route);
			tf.autoSize = TextFieldAutoSize.LEFT;
			stage.addChild(tf);
			scoretf.autoSize = TextFieldAutoSize.LEFT;
			stage.addChild(scoretf);
			hiscoretf.autoSize = TextFieldAutoSize.LEFT;
			stage.addChild(hiscoretf);

			so = SharedObject.getLocal("score");
			if(so.data.hiscore == undefined)
			{
				hiscoretf.text = "hiscore: 0";
				hiscore = 0;
				so.data.hiscore = 0;
				so.flush();
			}
			else
			{
				hiscoretf.text = "hiscore: " + so.data.hiscore;
				hiscore = so.data.hiscore;
			}
			scoretf.text = "score: 0";
			
			scoretf.x = 10;
			scoretf.y = 10;
			hiscoretf.x = stage.stageWidth - hiscoretf.width - 10;
			hiscoretf.y = 10;

			tf.text = "クリックでスタート";
			tf.x = (stage.stageWidth - tf.width)/2;
			tf.y = (stage.stageHeight - tf.height)/2;
			stage.addEventListener(MouseEvent.MOUSE_DOWN, startGame);
		}
		private function startGame(evt:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_DOWN, startGame);
			tf.text = "";

			wallTimer.addEventListener(TimerEvent.TIMER, generateWall);
			wallTimer.start();
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			stage.addEventListener(Event.ENTER_FRAME, onEnter);
		}
		private function onMouseDown(evt:MouseEvent):void
		{
			if (grv>0)
			{
				grv=-grv;
			}
		}
		private function onMouseUp(evt:MouseEvent):void
		{
			if (grv<0)
			{
				grv = -grv;
			}
		}
		private function generateWall(evt:TimerEvent):void
		{
			wallTimer.stop();
			wallTimer.reset();

			if (walls.length < maxWall)
			{
				var wall:Sprite = new Sprite();
				wall.graphics.beginFill(0xff0000);
				if (walls.length > 0)
				{
					wall.graphics.drawRect(-shipWidth,-shipWidth,shipWidth*2,walls[0].height);
				}
				else
				{
					wall.graphics.drawRect(-shipWidth,-shipWidth,shipWidth*2,shipWidth*2);
				}
				wall.graphics.endFill();
				wall.x = stage.stageWidth;
				wall.y = Math.random()*(stage.stageHeight - wall.height);
				stage.addChild(wall);
				walls.push(wall);

				wallTimer.start();
			}
		}
		private function onEnter(evt:Event):void
		{
			score ++;
			scoretf.text = "score: " + score;
			drawRoute();
			moveWall();
			moveShip();
			checkHit();
		}
		private function drawRoute():void
		{
			var bmd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true,0x00000000);
			var m:Matrix = new Matrix(1,0,0,1,-shipWidth);
			bmd.draw(shipContainer,m);
			route.bitmapData = bmd;
		}
		private function moveWall():void
		{
			for (var i:int = 0; i < walls.length; i++)
			{
				var wall:Sprite = walls[i];
				wall.x -= shipWidth;
				if (wall.x < -wall.width)
				{
					wall.height += wallInc;
					if (wall.height > stage.stageHeight/2)
					{
						wall.height = stage.stageHeight/2;
					}
					wall.x = stage.stageWidth;
					wall.y = Math.random()*(stage.stageHeight - wall.height);
				}
			}
		}
		private function moveShip():void
		{
			vy += grv;
			ship.y += vy;
		}
		private function checkHit():void
		{
			if (ship.y <= 0)
			{
				ship.y = 0;
				drawBomb();
			}
			else if (ship.y >= stage.stageHeight)
			{
				ship.y = stage.stageHeight;
				drawBomb();
			}
			else
			{
				for (var i:int = 0; i < walls.length; i++)
				{
					if (ship.hitTestObject(walls[i]))
					{
						drawBomb();
					}
				}
			}
		}
		private function drawBomb():void
		{
			stage.removeEventListener(Event.ENTER_FRAME, onEnter);
			wallTimer.stop();
			wallTimer.reset();
			bomb.x = ship.x;
			bomb.y = ship.y;
			bomb.graphics.beginFill(0xff5500);
			bomb.graphics.drawCircle(0,0,10);
			bomb.graphics.endFill();
			Tweener.addTween(bomb, {scaleX:10, scaleY:10, time:1, onComplete:resultScene, transition:"easeOutCubic"});
		}
		private function resultScene():void
		{
			if(score > hiscore)
			{
				so.data.hiscore = score;
				so.flush();
				hiscore = score;
				hiscoretf.text = "hiscore: " + hiscore;
                                hiscoretf.x = stage.stageWidth - hiscoretf.width - 10;
				tf.text = "GAME OVER\nハイスコア更新！\nクリックで再挑戦";
			}
			else
			{
				tf.text = "GAME OVER\nクリックで再挑戦";
			}
			tf.x = (stage.stageWidth - tf.width)/2;
			tf.y = (stage.stageHeight - tf.height)/2;

			stage.addEventListener(MouseEvent.CLICK, onGameOverClick);
		}
		private function onGameOverClick(evt:MouseEvent):void
		{
			score = 0;
			scoretf.text = "score: " + score;
			stage.removeEventListener(MouseEvent.CLICK, onGameOverClick);
			tf.text = "";
			route.bitmapData = null;
			for(var i:int = 0; i < walls.length; i++)
			{
				stage.removeChild(walls[i]);
			}
			walls = [];
			bomb.graphics.clear();
			bomb.scaleX = bomb.scaleY = 1;
			ship.y = stage.stageHeight/2;
			vy = -5;
			stage.addEventListener(Event.ENTER_FRAME, onEnter);
			wallTimer.start();
		}
	}
}
