/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lEz8
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    
    public class Pit extends Sprite {
        
        private var sprQuadrado:Sprite;
        private var txtCampo:TextField;
        
        public function Pit() {
            init();
        }
        
        private function init():void {
            sprQuadrado = new Sprite();
            addChild(sprQuadrado);
            sprQuadrado.graphics.beginFill(0x000000);
            sprQuadrado.graphics.drawRect(-2,-2,4,4);
            sprQuadrado.graphics.endFill();
            sprQuadrado.x = stage.stageWidth/2;
            sprQuadrado.y = stage.stageHeight/2;
            
            txtCampo = new TextField();
            addChild(txtCampo);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        private function onMouseMove(e:MouseEvent):void {
            graphics.clear();
            graphics.lineStyle(1,0,1);
            graphics.moveTo(sprQuadrado.x, sprQuadrado.y);
            graphics.lineTo(mouseX, mouseY);
            
            var dx:Number = sprQuadrado.x - mouseX;
            var dy:Number = sprQuadrado.y - mouseY;
            var numDistancia:Number = Math.sqrt(dx * dx + dy * dy);
            txtCampo.text = Math.round(numDistancia).toString();
        }


    }
}