/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lDfW
 */

// forked from kotobuki's Wanco x Gainer
// I/Oモジュール上のボタンと光センサでWancoをコントールするサンプル
package {
    import flash.display.Sprite;
    import net.wonderfl.widget.Wanco;

    import funnel.*;
    import funnel.ui.*;
    
    public class FlashTest extends Sprite {
        private var gainer:Gainer;
        private var sensorPin:Pin;
        private var wanco:Wanco;

        public function FlashTest() {
            gainer = new Gainer();
            
            // 光センサを接続したピン
            sensorPin = gainer.analogInput(0);

            wanco = new Wanco();
            wanco.x = stage.stageWidth / 2;
            wanco.y = stage.stageHeight / 2;
            addChild(wanco);

            // I/Oモジュール上のボタンに対してイベントリスナをセット
            gainer.button.addEventListener(ButtonEvent.PRESS, onButtonPress);
            gainer.button.addEventListener(ButtonEvent.LONG_PRESS, onButtonLongPress);

            // 光センサの変化に対してイベントリスナをセット
            sensorPin.addFilter(new SetPoint([0.6, 0.05]));
            sensorPin.addEventListener(PinEvent.RISING_EDGE, onBrightnenUp);
            sensorPin.addEventListener(PinEvent.FALLING_EDGE, onDarkenUp);
        }

        // I/Oモジュール上のボタンを押したらジャンプ        
        private function onButtonPress(e:ButtonEvent):void {
            wanco.jump1();
        }

        // I/Oモジュール上のボタンを長押ししたらロングジャンプ
        private function onButtonLongPress(e:ButtonEvent):void {
            wanco.jump2();
        }

        // 明るくなったら起きる
        private function onBrightnenUp(e:PinEvent):void {
            wanco.wakeUp(); 
        }

        // 暗くなったら寝る
        private function onDarkenUp(e:PinEvent):void {
            wanco.sleep();
        }
    }
}