/**
 * Copyright bioRex21 ( http://wonderfl.net/user/bioRex21 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lCkr
 */

// forked from bioRex21's Construct Image from tiles
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.FileFilter;
    import flash.net.FileReference;
    import flash.net.URLRequest;
    import com.greensock.TweenLite;
   

    public class ConstructImage extends Sprite
    {
        
        private var loader:Loader;
        private var imageUrl:URLRequest;
        private var sourceBmd:BitmapData;
        private var sectionBmd:BitmapData;
        private var sectionWidth:Number;
        private var sectionHeigth:Number;
        
        private var horFrames:Number;
        private var verFrames:Number;
        
        private var btn:Button;
        private var fileRef:FileReference;
                
        public function ConstructImage()
        {
            // horFrames*verFrames = total paticles
            horFrames = 30;
            verFrames = 30;            
            
            btn = new Button("click here to load an image");
            addChild(btn);
            btn.x = 320;
            btn.addEventListener(MouseEvent.CLICK, browseFiles);            
        }
        
        public function browseFiles(e:MouseEvent):void
        {
            fileRef = new FileReference();
            fileRef.addEventListener(Event.SELECT, selectHandler);
            
            var arr:Array = [];
                        arr.push(new FileFilter("Images", ".gif;*.jpeg;*.jpg;*.png"));
            fileRef.browse(arr);
        }
        
        
        public function selectHandler(e:Event):void
        {
            fileRef.load();
            fileRef.addEventListener ( Event.COMPLETE, onDataLoaded ) ;
        }
        
        public function onDataLoaded(e:Event):void
        {
            var tempFileRef:FileReference = FileReference (e.target) ;
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
            loader.loadBytes(tempFileRef.data);
        }
 
        private function onImageLoaded (e:Event):void
        {
            sourceBmd = (e.target.content).bitmapData;
            imageReady();
        }

        
        public function imageReady():void
        {
            var w:Number = loader.content.width;
            var h:Number = loader.content.height;
            
            sectionWidth = Math.round(w/horFrames);
            sectionHeigth = Math.round(h/verFrames);
            sourceBmd = new BitmapData(w,h);
            sourceBmd.draw(loader.content);
            
            var i:Number = 1;
            var rect:Rectangle = new Rectangle();
            var yMultiplier:Number = 0;
            var xMultiplier:Number = 0;
            
            for(i; i<=(horFrames * verFrames); i++)
            {
                sectionBmd = new BitmapData(sectionWidth, sectionHeigth);
                
                rect.x = xMultiplier* sectionWidth;
                rect.y = yMultiplier* sectionHeigth;
                rect.width = sectionWidth;
                rect.height = sectionHeigth;
                
                sectionBmd.copyPixels(sourceBmd, rect, new Point());
                xMultiplier++;
                
                if(i % horFrames == 0 )    
                {
                    yMultiplier++;
                    xMultiplier = 0;
                }
                tweenTile(sectionBmd, rect.x, rect.y );
            } 
            //put the btn over the image
            setChildIndex(btn, (numChildren - 1));
        }
        
        
        public function tweenTile(sectionData:BitmapData, destX:Number, destY:Number):void
        {
            //places tile at initial ranmdom coords
            var bitmapContainer:TweeningSprite = new TweeningSprite();
            bitmapContainer.x =  Math.floor(Math.random() * (1+550-10)) + 10;
            bitmapContainer.y = Math.floor(Math.random() * (1+200-400)) + 200;           
            bitmapContainer.finalX = destX;
            bitmapContainer.finalY = destY;
            
            bitmapContainer.addEventListener(MouseEvent.MOUSE_OVER, onTileMouseOver);
            
            addChild(bitmapContainer);
            
            var b:Bitmap = new Bitmap(sectionData);          
            bitmapContainer.addChild(b);
            
            //tweens to final coords so the image will be displayed
            TweenLite.to(bitmapContainer, 2,{x:destX, y:destY, onComplete:bitmapContainer.enable} );
        }
        
        private function onTileMouseOver(e:MouseEvent):void
        {
            if(e.currentTarget.tweenEnabled)
            {
                (e.currentTarget as TweeningSprite).tweenEnabled = false;
                dropTile(e.currentTarget as TweeningSprite);
            }

        }
        
        private function dropTile(tile:TweeningSprite):void 
        {
            
            TweenLite.to(tile, 1, {y:"+250", alpha:0, scaleY:0.1, scaleX:0.1, rotationZ:180, rotationX:180, onComplete:delayRestore, onCompleteParams:[tile]} );
        }
        
        private function delayRestore(tile:TweeningSprite):void
        {
           
            TweenLite.delayedCall(3, restoreTile, [tile]); 
        }
        
        
        
        private function restoreTile(tile:TweeningSprite):void 
        {
            tile.tweenEnabled = false;            
            TweenLite.to(tile, 1, {x:tile.finalX, y:tile.finalY, alpha:1, scaleY:1, scaleX:1, rotationZ:0, rotationX:0, onComplete:tile.enable } ) ;
            
        }


        
        
    }//ConstructImage Class
}
import flash.geom.Orientation3D;//package

import flash.display.Sprite;

class TweeningSprite extends Sprite
{
    //to avoid tween interrupt
    public var tweenEnabled:Boolean = false;
    public var finalX:Number;
    public var finalY:Number;
        
    public function TweeningSprite()
    {        
    }    
    
    public function enable():void
    {
        tweenEnabled = true;
    }
    
    public function disable():void
    {
        tweenEnabled = false;
    }

}

import flash.display.Sprite;
import flash.text.TextField;

class Button extends Sprite
{
    
    private var texto:TextField;
        
    public function Button(label:String="label")
    {
        graphics.beginFill(0xff00ff);
        graphics.drawRect(0,0, 200, 20);
        graphics.endFill();
        
        texto = new TextField();
        texto.textColor = 0x000000;
        texto.width = 200;
        texto.text = label;
        texto.selectable = false;
        
        addChild(texto);
    }    
}
