/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lCiy
 */

package {
  // Explanation:
  // http://www.smbc-comics.com/index.php?db=comics&id=1914#comic
  import flash.display.*;
  import flash.events.*;
  import flash.media.*;
  import flash.text.*;
  
  [SWF(width='465', height='465', backgroundColor='#777777', frameRate='15')]
  public class Main extends Sprite {
    
    private const ratio: Number = 10;
    private const finger: Number = ratio * 0.5;
    private const margin: Number = 6;
    private const min: Number = 5;
    private const max: Number = 10;
    private const origin1x: Number =                     margin;
    private const origin1y: Number =       ratio * 10  + margin;
    private const origin2x: Number =       ratio * 10  + margin;
    private const origin2y: Number = 230 + ratio * 10;
    private const white:    uint = 0xFFFFFF;
    private const positive: uint = 0xBBBBBB;
    private const negative: uint = 0x444444;
    
    private var dragging: Boolean = false;
    private var vx: int = 7;
    private var vy: int = 8;
    
    
    private var handle: Sprite;
    
    public function Main() {
      handle = new Sprite();
      handle.buttonMode = true;
      addChild(handle);
      
      handle.graphics.beginFill(0xFFFFFF);
      handle.graphics.drawRect(0, -18, 18, 18);
      handle.graphics.endFill();
      handle.graphics.lineStyle(1);
      handle.graphics.moveTo(20, -2);
      handle.graphics.lineTo(2, -20);
      handle.graphics.moveTo(14, -2);
      handle.graphics.lineTo(2, -14);
      handle.graphics.moveTo(8, -2);
      handle.graphics.lineTo(2, -8);
      
      handle.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
      stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
      stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
      
      render();
      
      var format: TextFormat = new TextFormat();
      format.align = TextFormatAlign.LEFT;
      format.bold = true;
      format.font = "Arial";
      format.size = 20;
		  
		  var instructionText: TextField = new TextField();
      instructionText.width = 400 - margin * 2;
      instructionText.x = margin;
      instructionText.height = 30;
      instructionText.y = 465 - instructionText.height - margin;
      instructionText.wordWrap = false;
      instructionText.type = TextFieldType.DYNAMIC;
      instructionText.textColor = 0x000000;
      instructionText.selectable = false;
      instructionText.mouseEnabled = false;
      instructionText.defaultTextFormat = format;
      instructionText.text = "^Drag corner!"
      addChild(instructionText);
      
		  var instruction2Text: TextField = new TextField();
      instruction2Text.width = 100;
      instruction2Text.x = 320;
      instruction2Text.height = 30;
      instruction2Text.y = origin1y + 15;
      instruction2Text.wordWrap = false;
      instruction2Text.type = TextFieldType.DYNAMIC;
      instruction2Text.textColor = 0x000000;
      instruction2Text.selectable = false;
      instruction2Text.mouseEnabled = false;
      instruction2Text.defaultTextFormat = format;
      instruction2Text.text = "x10"
      addChild(instruction2Text);
      
      format.size = 16;
    }
    
    private function mouseDown(event: MouseEvent): void {
      dragging = true;
    }
    
    private function mouseUp(event: MouseEvent): void {
      dragging = false;
    }
    
    private function mouseMove(event: MouseEvent): void {
      if (!dragging) return;
      vx = -(mouseX - origin2x) / ratio;
      vy =  (mouseY - origin2y) / ratio;
      if (vx < min) vx = min;
      if (vy < min) vy = min;
      if (vx > max) vx = max;
      if (vy > max) vy = max;
      render();
    }
    
    private function render(): void {
      graphics.clear();
      
      graphics.beginFill(0x777777);
      graphics.drawRect(0, 0, 465, 465);
      graphics.endFill();
      
      graphics.beginFill(negative);
      graphics.drawRect(origin1x, origin1y, ratio * 10, -ratio * 10);
      graphics.endFill();
      drawHand(negative, 5, true, origin1x, origin1y);
      drawHand(negative, 5, true, origin1x + ratio * 5, origin1y);
      
      graphics.beginFill(positive);
      graphics.drawRect(origin1x + margin + ratio * 10, 
                        origin1y,
                        ratio * vx, -ratio * 10);
      graphics.endFill();
      drawHand(positive, 5, true, origin1x + margin + ratio * 10, origin1y);
      drawHand(white, vx-5, true, origin1x + margin + ratio * 15, origin1y);
      
      graphics.beginFill(positive);
      graphics.drawRect(origin1x + margin + ratio * 10 + margin + ratio * 10, 
                        origin1y,
                        ratio * vy, -ratio * 10);
      graphics.endFill();
      drawHand(positive, 5, true, origin1x + margin * 2 + ratio * 20, origin1y);
      drawHand(white, vy-5, true, origin1x + margin * 2 + ratio * 25, origin1y);
      
      graphics.beginFill(positive);
      graphics.drawRect(origin2x + margin, origin2y - margin, ratio * 10, -ratio * 10);
      graphics.endFill();
      graphics.beginFill(negative);
      graphics.drawRect(origin2x, origin2y - margin, -ratio * vx, -ratio * 10);
      graphics.endFill();
      graphics.beginFill(negative);
      graphics.drawRect(origin2x + margin, origin2y, ratio * 10, ratio * vy);
      graphics.endFill();
      graphics.beginFill(white);
      graphics.drawRect(origin2x, origin2y, -ratio * vx, ratio * vy);
      graphics.endFill();
      
      drawHand(negative, vx - 5, false, origin2x - ratio * max + finger * 0, origin2y - ratio * 10 - finger * 11);
      drawHand(negative, 5, false, origin2x - ratio * max + finger * 10, origin2y - ratio * 10 - finger * 11);
      drawHand(positive, 5, false, origin2x - ratio * max + finger * 20 + margin, origin2y - ratio * 10 - finger * 11);
      drawHand(positive, 5, false, origin2x - ratio * max + finger * 30 + margin, origin2y - ratio * 10 - finger * 11);
      drawHand(white, 10 - vx, false, origin2x - ratio * max + finger * 30 + margin, origin2y - ratio * 10 - finger * 11);
      
      drawHandSideways(positive, 5, false, origin2x + margin + ratio * 10, origin2y - margin - ratio * 10 + finger * 0);
      drawHandSideways(white, 10 - vy, false, origin2x + margin + ratio * 10, origin2y - margin - ratio * 10 + finger * 0);
      drawHandSideways(positive, 5, false, origin2x + margin + ratio * 10, origin2y - margin - ratio * 10 + finger * 10);
      drawHandSideways(negative, 5, false, origin2x + margin + ratio * 10, origin2y - margin - ratio * 10 + finger * 20 + margin);
      drawHandSideways(negative, vy - 5, false, origin2x + margin + ratio * 10, origin2y - margin - ratio * 10 + finger * 30 + margin);
      /*
      drawHand(positive, 10 - vx, false, 200, origin2y + finger);
      drawHand(positive, 10 - vy, false, 200 + finger * 10, origin2y + finger);
      */
      
      handle.x = origin2x - ratio * vx;
      handle.y = origin2y + ratio * vy;
    }
    
    private function drawHand(color: uint, count: int, forward: Boolean, dx: Number, dy: Number): void {
      var i: int;
      graphics.lineStyle(1, color);
      graphics.drawRect(dx, dy + finger * 3, finger * 9, finger * 5);
      graphics.lineStyle();
      for (i = 0; i < count; i++) {
        graphics.beginFill(color);
        graphics.drawRect(dx + (forward ? i : 4 - i) * finger * 2,
                          dy + finger,
                          finger, finger * 2);
        graphics.endFill();
      }
    }
    
    private function drawHandSideways(color: uint, count: int, forward: Boolean, dx: Number, dy: Number): void {
      var i: int;
      graphics.lineStyle(1, color);
      graphics.drawRect(dx + finger, dy, finger * 5, finger * 9);
      graphics.lineStyle();
      for (i = 0; i < count; i++) {
        graphics.beginFill(color);
        graphics.drawRect(dx + finger * 6,
                          dy + (forward ? 4 - i : i) * finger * 2,
                          finger * 2, finger);
        graphics.endFill();
      }
    }
  }
}