/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lBxA
 */

package {

    import flash.events.Event;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        public function FlashTest() {

            vecLine = new Array();
            var a:XLine;
            
            cx = 200;
            cy = 200;
            
            a = new XLine(20,20, 400, 20);   vecLine.push(a);
            a = new XLine(20,400, 400, 400);   vecLine.push(a);
            a = new XLine(20,20, 20, 400);   vecLine.push(a);
            a = new XLine(400,20, 400, 400);   vecLine.push(a);
            
            a = new XLine(100, 150, 200, 150); vecLine.push(a);
            
            addLine(20, 300, 150, 400);
            addLine(300,400, 450, 300);            
                        
            
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, kup);
        }//ctor
        
        public function addLine(x0:Number, y0:Number, x1:Number, y1:Number):void
        {
            if (vecLine == null) { vecLine = new Array(); }
            vecLine.push( new XLine(x0, y0, x1, y1) );
        }//addline
        
        public function kdown(e:KeyboardEvent):void
        { vecKey[e.keyCode] = true; }//kdown

        public function kup(e:KeyboardEvent):void
        { vecKey[e.keyCode] = false; }//kup 
        
        public var vecLine:Array;
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512, false);

        public var cx:Number = 320;
        public var cy:Number = 240;
        public var vx:Number = 0;
        public var vy:Number = 0;

        public var fakex:Number = 0;
        public var fakey:Number = 0;
        public var px:Number = 0;
        public var py:Number = 0;
        public var sx:Number = 0;
        public var sy:Number = 0;
        public var ex:Number = 0;
        public var ey:Number = 0;
        public var rad:Number = 16;
        public var h:Number = 32;
        public var air:int = 0;
        
        public function onEnter(e:Event):void
        {
            var i:int;
            var a:XLine;
            var num:int;

            num = vecLine.length;

            graphics.clear();
            graphics.lineStyle(1, 0);
            
            for (i = 0; i < num; i++)
            {
                a = vecLine[i];
                
                graphics.moveTo(a.ax, a.ay);
                graphics.lineTo(a.bx, a.by);
                graphics.moveTo(a.cx, a.cy);
                graphics.lineTo(a.cx + a.nx * 6, a.cy + a.ny * 6);

            }//nexti
            

            var bGround:Boolean;
            bGround = false;

            if (vy < 0) { air = 1; }

            if (vy >= 0)
            if (air <= 0)
            if (calcClose(cx, cy-16, cx, cy + 300))
            {
                //if ( cy > py - 32) { bGround = true; }
                if ( cy > py - h-16) { bGround = true; }
            }//endif

            vy += 0.4;

            if (vecKey[Keyboard.LEFT]) { vx -= 2.8; }
            if (vecKey[Keyboard.RIGHT]) { vx += 2.8; }
            if (vecKey[Keyboard.UP]) { vy -= 2.8; }
            if (vecKey[Keyboard.DOWN]) { vy += 2.8; }


            var mag:Number;
            
            mag = Math.sqrt(vx * vx + vy * vy);
            
            //if (mag > 8) //was  a premature optimisation, unneccessary and causes bugs
            {
                if (calcClose(cx, cy, cx + vx, cy + vy))
                {
                    vx = 0;
                    vy = 0;
                }
            }//endif

            vx *= 0.95;
            vy *= 0.95;

            //if (vx < -8) { vx = -8; }
            //if (vx > 8) { vx = 8; }
            //if (vy < -8) { vy = -8; }
            //if (vy > 8) { vy = 8; }


            if (vy < 0 && cy +vy < 0 ) { cy = 0; vy = 0; }
            if (vy > 0 && cy +vy > 480 ) { cy = 480; vy = 0; }
            if (vx < 0 && cx +vx < 0 ) { cx = 0; vx = 0; }
            if (vx > 0 && cx +vx > 640 ) { cx = 640; vx = 0; }
   

            if (calcClose(cx, cy, cx, cy - 300))
            {
                if (vy < 0 && cy < py + 16) { vy = 0; cy = py + 16;  }
            }//endif

            
            graphics.drawCircle(px, py, 4);
            graphics.moveTo(sx, sy);
            graphics.lineTo(px, py);

            if (calcClose(cx, cy, cx, cy + 300))
            {
                if (vy > 0 && cy > py - h) { vy = 0; cy = py - h; air = 0; }
            }//endif

            
            graphics.drawCircle(px, py, 4);
            graphics.moveTo(sx, sy);
            graphics.lineTo(px, py);

            if (calcClose(cx, cy, cx-64, cy))
            {
                if (vx < 0 && Math.abs(sx+vx - px) < 8) { vx = 0; }
            }//endif


            graphics.drawCircle(px, py, 4);
            graphics.moveTo(sx, sy);
            graphics.lineTo(px, py);
            
            if (calcClose(cx, cy, cx+64, cy))
            {
                if (vx > 0 && Math.abs(sx+vx - px) < 8) { vx = 0; }
            }//endif
            
            graphics.drawCircle(px, py, 4);
            graphics.moveTo(sx, sy);
            graphics.lineTo(px, py);

            cx += vx;
            cy += vy;
   
            if (vy >= 0)
            if (bGround)
            if (calcClose(cx, cy, cx, cy + 300))
            { 
                if ( Math.abs(sy - py) < 64) 
                { 
                    vx *= 0.9; 
                    if (py < cy - 5) { vx *= 0.9; }
                    cy = py - h; 
                    vy = 0; 
                }
                else { air = 1; }
            }//endif

            if (bGround)
            {
                fakex += (cx - fakex) * 0.5;
                fakey += (cy - fakey) * 0.25;
            }
            else
            {
                fakex = cx;
                fakey = cy;
            }

            graphics.lineStyle(2, 0);
            graphics.drawCircle(fakex, fakey, 14);

        }//onenter
        
        
        
        
        
        
        
        

    
        public function calcClose(x1:Number,y1:Number, x2:Number, y2:Number):Boolean
        {
            var i:int;
            var a:XLine;
            var num:int;
            var t:Number;
            var dist:Number;

            sx=x1;
            sy=y1;
            ex=x2;
            ey=y2;
            px = ex;
            py = ey;

            dist = 999;

            num = vecLine.length;

            for (i = 0; i < num; i++)
            {
                a = vecLine[i];
                t = lineLineInter(sx, sy, ex, ey, a.ax, a.ay, a.bx, a.by);

                if (t < dist)
                {
                    dist = t;
                }
            }//nexti

            if ((dist >= 0 && dist <= 1))
            {
                px = sx + (ex - sx) * dist;
                py = sy + (ey - sy) * dist;
            }//endif

            return (dist >= 0 && dist <= 1);

        }//calclose
        

       public function lineLineInter(
         v0x:Number, v0y:Number,
         v1x:Number, v1y:Number,
         v2x:Number, v2y:Number,
         v3x:Number, v3y:Number ):Number
         {
             var ua:Number;
             var ub:Number;
             var bot:Number;

             bot = ((v3y-v2y)*(v1x-v0x))-((v3x-v2x)*(v1y-v0y));
             if (bot == 0) { return 999;}

              ua = (((v3x-v2x)*(v0y-v2y))-((v3y-v2y)*(v0x-v2x))) / bot;
              ub = (((v1x-v0x)*(v0y-v2y))-((v1y-v0y)*(v0x-v2x))) / bot;
              if (ua > 1 || ua < 0 || ub > 1 || ub < 0) { return 999; }          

              return ua;
         }//lineline
        
        
    }//classend
}

internal class XLine
{
    public var ax:Number = 0;
    public var ay:Number = 0;
    public var bx:Number = 0;
    public var by:Number = 0;
    public var nx:Number = 0;
    public var ny:Number = 0;
    public var cx:Number = 0;
    public var cy:Number = 0;

    public function XLine(x1:Number, y1:Number, x2:Number, y2:Number):void
    {
        ax = x1;
        ay = y1;
        bx = x2;
        by = y2;

        cx = ax + (bx - ax) * 0.5;
        cy = ay + (by - ay) * 0.5;

        var mag:Number;
        var dx:Number; 
        var dy:Number;

        dx = ax - bx;
        dy = ay - by;

        mag = Math.sqrt(dx * dx + dy * dy);
        if (mag == 0) { mag = 0.0000001; }

        nx = -(dy / mag);
        ny = dx / mag;

    }//ctor

    

    

}//xline