/**
 * Copyright k__ ( http://wonderfl.net/user/k__ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lBQQ
 */


package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import org.papervision3d.cameras.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.materials.special.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.utils.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.render.*;
	import org.papervision3d.scenes.*;
	import org.papervision3d.view.*;
	import org.papervision3d.lights.*;
	
	public class Main extends Sprite {
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var viewport:Viewport3D;
		private var renderer:BasicRenderEngine;
		private var objects:Array = [];
		private var materials:Array = [];
		private var light:PointLight3D;

		public function Main() {
			//bg
			graphics.beginFill(0x000000);
			graphics.drawRect(0,0,500,500);
			scene = new Scene3D();
			//camera
			camera = new Camera3D();
			camera.x = camera.y = 0;
			camera.z = -1000;
			camera.focus = 100;
			camera.zoom = 10;
			//vieport
			viewport = new Viewport3D(500,500);
			addChild(viewport);

			//renderer
			renderer = new BasicRenderEngine();

			//light
			light = new PointLight3D();
			light.x = 100;
			light.y = 100;
			light.z = -100;
			scene.addChild(light);

			// create materials
			
			var bmp = new BitmapData(100,100);
			bmp.noise(0);
			var bmp2 = new BitmapData(100,100);
			bmp2.perlinNoise(20,20,3,0,true,true,3);
			
			materials = [
			new FlatShadeMaterial(light, 0xff0000, 0x550000),
			new CellMaterial(light, 0xff0000, 0x550000,5),
			new CellMaterial(light, 0xffffff, 0x000000,15),
			new EnvMapMaterial(light, bmp,bmp2, 0x777777),
			new GouraudMaterial(light, 0xffffff, 0x555555,15)	,
			new PhongMaterial(light, 0x00a0ff, 0x005088,15),
			new ColorMaterial(0x339966),
			new WireframeMaterial(0x0000ff),
			new BitmapMaterial(bmp2),
			new MovieMaterial(this,true,true,false,new Rectangle(0,0,300,300))
			];
			
			//create objects
			var cnt = 0;
			var mList:MaterialsList;
			var object:DisplayObject3D;
			for (var j:uint = 0; j <= 300; j += 100) {
				for (var i:uint = 0; i <= 300; i += 100) {
					cnt ++;
					mList= new MaterialsList();
					mList.addMaterial(materials[cnt % materials.length],"all");
					object=new Cube(mList,50,50,50,2,2,2);
					object.x=i - 150;
					object.y=j - 150;
					objects.push(object);
					scene.addChild(object);
				}
			}
			stage.addEventListener(Event.ENTER_FRAME, drawPapervision3d);
		}

		private function drawPapervision3d(e:Event):void {
			for (var i:uint = 0; i < objects.length; i ++) {
				objects[i].rotationX+=1;
				objects[i].rotationY+=1;
				objects[i].rotationZ+=1;
			}
			renderer.renderScene(scene, camera, viewport);
		}

	}
}