/**
 * Copyright poepoemix ( http://wonderfl.net/user/poepoemix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l9v8
 */

package {
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.media.SoundTransform;
    import flash.media.Video;
    import flash.net.NetStream;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.external.ExternalInterface;
    
    public class FlashTest extends Sprite {
        private var compHelper:*; // 表示コンポーネント補助
        private var takStreamingFactory:Class = null; // takStreaming生成用クラス
        public function FlashTest() {
            if(stage) {pre_init();}
            else {addEventListener(Event.ADDED_TO_STAGE, pre_init);}
        }
        private function pre_init():void {
            removeEventListener(Event.ADDED_TO_STAGE, pre_init);
            if(!stage) {return;}

            // コンポーネント表示補助http://wonderfl.net/c/7YEy
            var comp:* = new MyLoader("http://swf.wonderfl.net/swf/usercode/3/37/37ea/37ea71571d353e8be4841dd5730420e9bb4cfb85.swf");
            // takStreamingライブラリ読み込み
            var library:* = new MyLoader("http://49.212.39.17/library/TakStreamingFactory.swf");
            // ライブラリ読み込み実施
            MyLoader.loadAll(function():void {
                // 表示コンポーネント
                var HelperClass:Class = comp.getClass("ComponentHelper");
                compHelper = new HelperClass();
                compHelper.gray();
                var logger:* = compHelper.logger();
                logger.setup(stage);
                Logger.setLogger(logger);

                // factory
                takStreamingFactory = library.getClass("TakStreamingFactory");
                // 内部動作ログを捕捉
                takStreamingFactory["setLogger"](logger);
                // 初期化
                init();
            });
        }
        private function init():void {
            // uiの準備をしておく。
            var panel:* = compHelper.base({parent:this, left:10, top:10, width:stage.stageWidth - 20, height:stage.stageHeight - 20, log:true});
            // ビデオ表示領域設定
            var videoPanel:* = compHelper.panel({parent:panel, left:10, top:10, width:320, height:240});
            // takStreamingのセットアップ
            try {
                // ソースとなるストリームを設定
                takStreamingFactory["addSource"]("http://49.212.39.17/tak/test.flf", "test");
                // 提供先ストリームを追加
                takStreamingFactory["setSupply"]("rtmfp:", "test");
                // netStreamを取得
                var stream:NetStream = takStreamingFactory["getStream"]() as NetStream;
                // videoを取得
                var video:Video = takStreamingFactory["getVideo"]() as Video;
                videoPanel.addChild(video);
                stream.bufferTime = 2;
                stream.soundTransform = new SoundTransform(0);
                stream.play(null);
                // volume
                var volume:* = compHelper.label({parent:panel, left:10, top:260, text:"volume:0"});
                // volumeSlider
                var volumeSlider:* = compHelper.hSlider({parent:panel, left:80, top: 263, func:function():void {
                    volume.text = "volume:" + int(volumeSlider.value);
                    stream.soundTransform = new SoundTransform(volumeSlider.value / 100);
                }});
                var list:* = compHelper.list({parent:panel, left:335, top:10});
                list.setSize(105, 240);
                var timer:Timer = new Timer(500);
                timer.addEventListener(TimerEvent.TIMER, function(event:TimerEvent):void {
                    list.removeAll();
                    list.addItem("bufferLength");
                    list.addItem(stream.bufferLength);
                    list.addItem("fps");
                    list.addItem(stream.currentFPS);
                    list.addItem("volume");
                    list.addItem(stream.soundTransform.volume);
                    list.addItem("time");
                    list.addItem(stream.time);
                    list.addItem("audioCodec");
                    list.addItem(stream.audioCodec);
                    list.addItem("videoCodec");
                    list.addItem(stream.videoCodec);
                });
                timer.start();
            }
            catch(e:Error) {
                Logger.error(e.message);
            }
        }
    }
}

import flash.display.LoaderInfo;
import flash.system.ApplicationDomain;
import flash.system.LoaderContext;
import flash.system.SecurityDomain;
import flash.system.Security;
import flash.net.URLRequest;
import flash.events.Event;
import flash.display.Loader;

/**
 * ロガー
 */
class Logger {
    // compHelperのロガーを登録しておく。
    public static var logger:* = null;
    public static function setLogger(logger:*):void {
        Logger.logger = logger;
    }
    public static function fatal(obj:*):void {if(logger != null)logger.fatal(obj);}
    public static function error(obj:*):void {if(logger != null)logger.error(obj);}
    public static function warn(obj:*):void  {if(logger != null)logger.warn(obj);}
    public static function info(obj:*):void  {if(logger != null)logger.info(obj);}
    public static function debug(obj:*):void {if(logger != null)logger.debug(obj);}
}

/**
 * ロード動作の補助
 */
class MyLoader {
    // 全ローダーの保持
    private static var loaderSet:Array = [];
    // 残りの読み込むターゲット数
    private static var targetNum:int = 0;
    // 各ローダー用のドメイン空間
    private var domain:ApplicationDomain = null;
    // 各ローダー用のターゲットURL
    private var url:String = null;
    /**
     * コンストラクタ
     */
    public function MyLoader(url:String) {
        this.url = url;
        loaderSet.push(this);
    }
    /**
     * クラス参照
     */
    public function getClass(name:String):Class {
        if(domain == null) {
            throw new Error("loding is not complete yet...");
        }
        return domain.getDefinition(name) as Class;
    }
    /**
     * 全ローダー読み込み完了時にfuncを実行
     */
    public static function loadAll(func:Function):void {
        targetNum = loaderSet.length;
        var token:String = "?" + (new Date()).getTime();
        for each(var myLoader:MyLoader in loaderSet) {
            load(myLoader, token, func);
        }
    }
    /**
     * 個別のローダーの読み込み動作
     * securityエラー等は考慮せず
     */
    private static function load(myLoader:MyLoader, token:String, func:Function):void {
        var loader:Loader = new Loader();
        var context:LoaderContext = new LoaderContext();
        context.checkPolicyFile = true;
        context.applicationDomain = ApplicationDomain.currentDomain;
        context.securityDomain = SecurityDomain.currentDomain;
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(event:Event):void {
            myLoader.domain = LoaderInfo(event.target).applicationDomain;
            targetNum --;
            if(targetNum == 0) {
                func();
            }
        });
        loader.load(new URLRequest(myLoader.url + token), context);
    }
}
