/**
 * Copyright prototype ( http://wonderfl.net/user/prototype )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l94I
 */

package {
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite
    import flash.events.MouseEvent;
    import flash.filters.BevelFilter;
    
    
    [SWF(width = 720, height = 480,backgroundColor = '#000000')]
    
    public class OrbitalFun extends Sprite {
        
        private var balls:Array;
        private var planets:Array;
        private var flying:Array;
       
        public function OrbitalFun() 
        {
            initTrace(stage);
            
            planets = new Array;
            balls = new Array;
            flying = new Array;
            
            planets = createBalls(10, 30, true);
            balls = createBalls(10, 5,false);
            linkBallsToPlanets();
           
            
            addEventListener(Event.ENTER_FRAME, update);
            addEventListener(MouseEvent.CLICK,clickHandler);
            
        }
        
        public function update(e:Event):void
        {
            //checkBallCollision();
            updateOrbiters(planets);
            updateFlying();
            checkFlyingCollision();
            
            
        }
        
        public function clickHandler(e:MouseEvent):void
        {
            for (var index:int = 0;index < planets.length;index++)
            {
                var curObject:Object = planets[index];
                var curPlanet:Sprite = curObject.sprite;
                if (curPlanet.hitTestPoint(mouseX,mouseY))
                {
                    for (var orbiterIndex:int = 0;orbiterIndex < curObject.orbiters.length;orbiterIndex++)
                    {
                        var curOrbiterObject:Object = curObject.orbiters[orbiterIndex];
                        var curOrbiter:Sprite = curOrbiterObject.sprite;
                        var launchAngle:Number = getAngle(curPlanet.x,curPlanet.y,curOrbiter.x,curOrbiter.y);
                        curOrbiterObject.xv = curOrbiterObject.speed * Math.cos(launchAngle);
                        curOrbiterObject.yv = curOrbiterObject.speed * Math.sin(launchAngle);
                        
                        flying.push(curOrbiterObject);
                        curObject.orbiters.splice(orbiterIndex,1);
                        orbiterIndex--;
                    }
                }
            }
        }


        private function updateFlying():void
        {
            for(var index:int = 0;index < flying.length;index++)
            {
                var curObject:Object = flying[index];
                var curOrbiter:Sprite = curObject.sprite;
                
                //trace(curOrbiter.x +"," + curOrbiter.y);
                curOrbiter.x += curObject.xv;
                curOrbiter.y += curObject.yv;
            }

        }

        private function checkFlyingCollision():void
        {
            for(var index:int = 0;index < flying.length;index++)
            {
                var curObject:Object = flying[index];
                var curOrbiter:Sprite = curObject.sprite;
                
                for(var planetIndex:int =0;planetIndex < planets.length;planetIndex++)
                {
                    var curPlanetObject:Object = planets[planetIndex];
                    var curPlanet:Sprite = curPlanetObject.sprite;
                    if (curPlanet.hitTestObject(curOrbiter))
                    {
                        curPlanetObject.orbiters.push(curObject);
                        
                        curObject.angle = getAngle(curPlanet.x, curPlanet.y, curOrbiter.x, curOrbiter.y);
                        flying.splice(index,1);
                        index--;
                    }
                }
                
            }

        }
        
        private function updateOrbiters(planetArray:Array):void
        {
            for (var index:int =0;index < planetArray.length;index++)
            {
                var curObject:Object = planetArray[index];
                var curPlanet:Sprite = curObject.sprite;
                for (var orbiterIndex:int = 0;orbiterIndex < curObject.orbiters.length;orbiterIndex++)
                {
                    var curOrbiterObject:Object = curObject.orbiters[orbiterIndex];
                    curOrbiterObject.angle += .05;
                    curOrbiterObject.sprite.x = curPlanet.x + 40 * Math.cos(curOrbiterObject.angle);
                    curOrbiterObject.sprite..y = curPlanet.y + 40 * Math.sin(curOrbiterObject.angle);
                }
            }

        }

        
        private function linkBallsToPlanets():void
        {
            trace ("linkBallsToPlanets");
            for (var index:int = 0;index < planets.length;index++)
            {
                var curPlanetObject:Object = planets[index] as Object;
                var curOrbiterObject:Object = balls[index] as Object;
                var curPlanet:Sprite = curPlanetObject.sprite;
                var curOrbiter:Sprite = curOrbiterObject.sprite;
                
                //trace (index + " : " + curOrbiter.x +"," + curOrbiter.y);
                
                curPlanetObject.orbiters.push(curOrbiterObject);
                curOrbiter.x = curPlanet.x + 40 * Math.cos(curOrbiterObject.angle);
                curOrbiter.y = curPlanet.y + 40 * Math.sin(curOrbiterObject.angle);
                
            }

        }

        

        public function checkBallCollision():void
        {
            for (var index:int = 0;index < planets.length;index++)
            {
                var curObject:Object = planets[index]
                var curBall:Sprite = curObject.sprite;
                if (curBall.hitTestPoint(mouseX, mouseY, true))
                {
                    curBall.scaleX += .01;
                    curBall.scaleY += .01;
                }

            }

        }
        
        private function getValidLoc(testArray:Array, thresholdDistance:Number):Point
        {
            var validLoc:Boolean = false;
            var tries:int = 0;
            
            while (!validLoc && tries < 1500)
            {
                tries++;
                validLoc = true;
                var locX:Number = Math.random() * 620 + 40;
                var locY:Number = Math.random() * 400 + 40;
                
                for (var index:int = 0;index < testArray.length;index++)
                {
                    var curBallObject:Object = testArray[index];
                    var curBall:Sprite = curBallObject.sprite;
                    var distance:Number = getDistance(curBall.x,curBall.y, locX, locY);
                    
                    if (distance < thresholdDistance)
                    {
                        validLoc = false;
                    }
                }
            }
            var validPoint:Point = new Point(locX,locY);
            //trace ("tries : "+ tries);
            return validPoint;

        }
        
         private function getDistance(x1:Number,y1:Number,x2:Number,y2:Number):Number
        {
            var distance:Number;
            
            distance = Math.sqrt(((x1 - x2) * (x1 - x2)) +  ((y1 - y2) * (y1 - y2)));
            
            return distance;
        }
        
        private function getAngle(locX:Number,locY:Number,targetX:Number,targetY:Number):Number
        {
            return Math.atan2(targetY - locY, targetX -locX);
        }


        public function createBalls(amount:int, radius:Number, checkCollision:Boolean = false):Array
        {
            var ballArray:Array = new Array;
            var ballColor:int = 0xFF0000;
            var newLoc:Point;
            
            for (var index:int = 0;index < amount;index++)
            {
                var ballObject:Object = new Object;
                var newSprite:Sprite;
                
                if (checkCollision)
                {
                    ballColor = 0xFF0000;
                    //trace ("planet " + index + " check collision : " + newSprite.x + "," + newSprite.y);
                    newSprite = getBall(ballColor,radius);
                    newLoc = getValidLoc(ballArray, 125);
                    newSprite.x = newLoc.x;
                    newSprite.y = newLoc.y;
                    ballObject.orbiters = new Array;
                    
                }
                    else
                    {
                        ballColor = 0x0000FF;
                        newSprite = getBall(ballColor,radius);
                        newSprite.x = 50;
                        newSprite.y = index * 30;
                        //trace ("ball, not planet" + index + " : " + newSprite.x + "," + newSprite.y);
                    }
                bevel(newSprite, 0xFFFFFF, .5, 0x000000,.25,3,45,3,3,50,3,"inner",false);
                ballObject.sprite = newSprite;
                ballObject.angle = Math.random() * 360;
                ballObject.speed = 15;
               
                //ballColor -= 0x220000;
                addChild(newSprite);
                
                ballArray.push(ballObject);
            }
            return ballArray;
        }

        
        public function getBall(colorCode:int, ballRadius:Number):Sprite
        {
            var ballSprite:Sprite = new Sprite;
            
            ballSprite.graphics.lineStyle(3,colorCode);
            ballSprite.graphics.beginFill(colorCode);
            ballSprite.graphics.drawCircle(0,0,ballRadius);
            
            return ballSprite;
        }
        
        public function bevel(sourceClip:Sprite, highlightColor:int,highlightAlpha:Number, shadowColor:int,shadowAlpha:Number, distance:Number, angle:Number, blurX:Number, blurY:Number, strength:Number, quality:int, type:String, knockout:Boolean):void
        {
            var bevel:BevelFilter = new BevelFilter;
            var filtersArray:Array = new Array;
            
            filtersArray = sourceClip.filters;
            
            bevel.distance = distance;
            bevel.angle = angle;
            bevel.highlightColor = highlightColor;
            bevel.highlightAlpha = highlightAlpha;
            bevel.shadowColor = shadowColor;
            bevel.shadowAlpha = shadowAlpha;
            bevel.blurX = blurX;
            bevel.blurY = blurY;
            bevel.strength = strength;
            bevel.quality = quality;
            bevel.type = type;
            bevel.knockout = knockout; 
            filtersArray.push(bevel);
            sourceClip.filters = filtersArray;
        }

    }
}
import flash.display.Sprite;



import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;



class Orbiter extends Sprite 
{
    public var ballSprite:Sprite;
    public var color:int;
    public var ballRadius:Number;
    public var angle:Number;
    public var speed:Number;
    
   
    public function Orbiter(colorCode:int, ballRadius:Number) 
    {
       
        ballSprite = new Sprite;
        
        ballSprite.graphics.lineStyle(3,colorCode);
        ballSprite.graphics.beginFill(colorCode);
        ballSprite.graphics.drawCircle(0,0,ballRadius);
        addChild(ballSprite);
    }
    


}




class Planet extends Sprite 
{
    public var ballSprite:Sprite;
    public var color:int;
    public var ballRadius:Number;
    public var orbiters:Array;
    
   
    public function Planet(colorCode:int, ballRadius:Number) 
    {
        orbiters = new Array;
        ballSprite = new Sprite;
        
        ballSprite.graphics.lineStyle(3,colorCode);
        ballSprite.graphics.beginFill(colorCode);
        ballSprite.graphics.drawCircle(0,0,ballRadius);
        addChild(ballSprite);
    }

}







var txt:TextField=new TextField();
txt.defaultTextFormat=new flash.text.TextFormat("courier new,courier,arial",16);
txt.mouseEnabled=false;
txt.selectable=false;
txt.alpha=.5;
var initTrace:Function=function(s:Stage):void{s.addChild(txt);};


txt.autoSize = TextFieldAutoSize.LEFT;
function trace(mess:*):void
{
    var s:Stage=txt.stage;
    txt.appendText(mess.toString()+"\n");
    if(s===null)
        return;
    txt.y=s.stageHeight-txt.textHeight;
   
};