/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l91T
 */

package  
{
    import com.bit101.charts.LineChart;
    import com.bit101.components.Label;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.getTimer;
    import flash.utils.Timer;
    /**
     * 
     */
    public class TimerTest extends Sprite
    {
        private var arr:Array;
        private var lineChart:LineChart;
        private var sh:Shape;
        
        public function TimerTest() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            arr = [];
            stage.scaleMode = StageScaleMode.NO_SCALE;
            lineChart = new LineChart(this);
            lineChart.maximum = 1000, lineChart.minimum = 0;
            lineChart.setSize(stage.stageWidth, stage.stageHeight);
            lineChart.autoScale = false;
            addChild(sh = new Shape());
            var g: Graphics = sh.graphics;
            g.lineStyle(1, 0xCCCCCC, 0.5);
            var i: int, n: int = 10, h: int;
            for (i = 0; i < n; i ++)
            {
                g.moveTo(0, h = stage.stageHeight * i / n);
                g.lineTo(stage.stageWidth, h);
                new Label(this, 0, h, (1000 - 1000 * i / n) + "ms");
            }
            var timer: Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
            arr.push(getTimer());
        }
        
        private function onTimer(e:TimerEvent):void 
        {
            arr.unshift(getTimer());
            if (arr.length > 200) arr.pop();
            var i: int, n: int = arr.length, t: int = arr[0];
            var res: Array = [];
            for (i = 1; i < n; i ++)
            {
                res.push(t - arr[i]);
                t = arr[i];
            }
            lineChart.data = res;
        }
    }
}