/**
 * Copyright code ( http://wonderfl.net/user/code )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/l5pc
 */

// forked from hacker_w2kqj15r's forked from: forked from: forked from: forked from: 3D tag cloud
// forked from pakyao's forked from: forked from: forked from: 3D tag cloud
// forked from CarlitosWay's forked from: forked from: 3D tag cloud
// forked from soulside's forked from: 3D tag cloud
// forked from esabear's 3D tag cloud

//　
//　強制的に回転しちゃうのはなんでー？！
//　文字の配置がとっても素敵です！参考になりました！
package {
	import flash.display.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.filters.GlowFilter;
	import flash.filters.BlurFilter;
	import flash.filters.BitmapFilterQuality;
	import org.papervision3d.materials.special.BitmapParticleMaterial;
	import org.papervision3d.core.geom.Particles;
	import org.papervision3d.core.geom.renderables.Particle;
	import org.papervision3d.events.InteractiveScene3DEvent;

	import org.papervision3d.scenes.Scene3D;  
	import org.papervision3d.view.Viewport3D;  
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.objects.DisplayObject3D;  
	import org.papervision3d.render.BasicRenderEngine;	

	public class FlashTest extends Sprite {
		private var scale:Number = 4;
		private var radius:Number = 550;
		private var smoothing:Boolean = true;
		private var minAlpha:Number = 0.3;
		private var glow:GlowFilter;
		private var tags:Array;
		private var tag_num:uint;
		private var tagArray:Array;
		private var view:Viewport3D;
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var renderer:BasicRenderEngine; 
		private var tagContainer:DisplayObject3D;
		
		
		private var myAngle:Number=Math.PI/500;
		private var axisAngle:Number=Math.PI*2/3;
		private var isMouseOut:Boolean=true;
		
		public function FlashTest() {
			// write as3 code here..
			init ();

		}
		
		private function init ():void {
			glow = new GlowFilter (0x003366, 1, 8, 8, 2, BitmapFilterQuality.LOW, true, false);
			tags = ["Neo Academism","Over Lord","師資相承","Silver　Pentagram","形態学","死に至る病","特殊意志２．０","構造主義","GR計画","攻性批評","人類知","Globalism", "Zero作戦", "新しい天使", "不完全性定理", "連続体仮説", "量子力学","相対性理論","バナッハ・タルスキ","ゲーデル","量子的存在","ロゴス","サイバーパンク","ノーバート・ウィナー","フォン・ノイマン","イーガン","ベンヤミン","モナドロジー","ライプニッツ","ゲーテ"];
			tag_num = tags.length;
			tagArray = [];
			tagContainer = new DisplayObject3D ();
			tagContainer.x = -radius * 0.2;
			tagContainer.y =  radius * 0.2;

			view = new Viewport3D(0,0,true,true);
			scene = new Scene3D();
			camera = new Camera3D();
			camera.z = -2 * radius;
			camera.zoom = 20;
			renderer = new BasicRenderEngine();

			this.addChild (view);
			scene.addChild (camera);
			scene.addChild(tagContainer);

			buildTags ();

			addEventListener (Event.ENTER_FRAME, enterFrameHandler);
			stage.addEventListener(MouseEvent.MOUSE_OUT, mouseOutHandler);
			stage.addEventListener(MouseEvent.MOUSE_OVER, mouseOverHandler);
			
			var mouseBase:Sprite=new Sprite();
			mouseBase.graphics.beginFill(0xffffff,0);
			mouseBase.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
			mouseBase.graphics.endFill();
			addChild(mouseBase);
			
		}
		

		private function buildTags ():void {
			var i:uint;
			for (i = 0; i < tag_num; i++) {
			// 2D
			var txt:TextField = new TextField ();
			txt.text = tags[i];
			txt.filters = [new BlurFilter(1.1, 1.1)];
			var txtW:Number = txt.textWidth + 4;
			var txtH:Number = txt.textHeight + 4;
			var bitmap:BitmapData = new BitmapData (txtW, txtH, true, 0x01FFFFFF);
			bitmap.draw (txt);

			var phi:Number = Math.acos((2 * (i + 1) - 1) / tag_num - 1);
			var theta:Number = Math.sqrt(tag_num * Math.PI) * phi;

			// 3D
			var material:BitmapParticleMaterial = new BitmapParticleMaterial (bitmap);
			material.interactive = true;
			material.smooth = smoothing;

			var tag:Particle = new Particle (material, scale, 0, 0, 0);
			var tagHolder:Particles = new Particles ();
 			tagHolder.addParticle (tag);
			tagHolder.x = radius * Math.cos (theta) * Math.sin (phi);
			tagHolder.y = radius * Math.sin (theta) * Math.sin (phi);
 			tagHolder.z = radius * Math.cos (phi);
 			tagHolder.useOwnContainer = true;
			tagHolder.autoCalcScreenCoords = true;
 			tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OVER, objectOverHandler);
			tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OUT, objectOutHandler);
			//tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_PRESS, objectPressHandler);

			tagContainer.addChild (tagHolder);
			tagArray.push (tagHolder);
			}
			

			
		}

		private function objectOverHandler (e:InteractiveScene3DEvent):void {
			view.buttonMode = true;
			e.target.filters = [glow];
		}

		private function objectOutHandler (e:InteractiveScene3DEvent):void {
			view.buttonMode = false;

			for (var j:uint = 0; j < tag_num; j++) {
				tagArray [j].filters = [];
			}
		}

		private function enterFrameHandler (e:Event):void {
			//回転量
			if (isMouseOut) {
				myAngle = myAngle* 0.97;
			}else {
				myAngle = -Math.min(radius, Math.max(Math.abs(mouseY - stage.stageHeight / 2), Math.abs(mouseX - stage.stageWidth / 2))) / 2000;	
			}
			
			
			//回転軸 
			axisAngle= Math.atan2((mouseX - stage.stageWidth/2),(mouseY-stage.stageHeight/2));
		
			//任意の軸の単位ベクトル
			var vx:Number = Math.cos(axisAngle);
			var vy :Number= Math.sin(axisAngle);
			var myCos:Number = Math.cos(myAngle);
			var mySin:Number = Math.sin(myAngle);	
		
			for (var i:uint = 0; i < tag_num; i++) {
				var posX:Number = tagArray[i].x*((1 - myCos) *Math.pow(vx,2) + myCos) + tagArray[i].y*(vx * vy*(1 - myCos)) - tagArray[i].z*vy * mySin;
				var posY:Number= tagArray[i].x*(vx * vy*(1 - myCos)) +tagArray[i].y*((1 - myCos) * Math.pow(vy,2) + myCos) +tagArray[i].z*vx* mySin;
				var posZ:Number= tagArray[i].x*vy * mySin - tagArray[i].y*vx * mySin +tagArray[i].z*myCos;
		
				tagArray[i].x=posX;
				tagArray[i].y=posY;
				tagArray[i].z=posZ;		
		
				renderer.renderScene (scene,camera,view);
		
				tagArray[i].alpha = minAlpha + (1 - minAlpha) * (1 - (tagArray[i].screen.z - radius) / (2 * radius));
			}
		}
		
		private function mouseOutHandler(e:MouseEvent):void 
		{
			isMouseOut = true;
		}
				
		private function mouseOverHandler(e:MouseEvent):void 
		{
			isMouseOut = false;
		}
		
	}
}
